/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.solutionstore;

import java.util.HashSet;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.viatra.dse.api.SolutionTrajectory;
import org.eclipse.viatra.dse.base.ThreadContext;
import org.eclipse.viatra.dse.solutionstore.ISolutionFoundHandler;
import org.eclipse.viatra.dse.solutionstore.ISolutionNameProvider;
import org.eclipse.viatra.dse.solutionstore.IdBasedSolutionNameProvider;
import org.eclipse.viatra.dse.util.EMFHelper;

public class ModelSaverSolutionFoundHandler
implements ISolutionFoundHandler {
    private HashSet<Object> savedSolutions = new HashSet();
    private ISolutionNameProvider solutionNameProvider;

    public ModelSaverSolutionFoundHandler() {
        this.solutionNameProvider = new IdBasedSolutionNameProvider("solution", "xmi");
    }

    public ModelSaverSolutionFoundHandler(String extension) {
        this.solutionNameProvider = new IdBasedSolutionNameProvider("solution", extension);
    }

    public ModelSaverSolutionFoundHandler(String prefix, String extension) {
        this.solutionNameProvider = new IdBasedSolutionNameProvider(prefix, extension);
    }

    public ModelSaverSolutionFoundHandler(ISolutionNameProvider solutionNameProvider) {
        this.solutionNameProvider = solutionNameProvider;
    }

    @Override
    public void solutionTriedToSave(ThreadContext context, SolutionTrajectory trajectory) {
    }

    @Override
    public void solutionFound(ThreadContext context, SolutionTrajectory trajectory) {
        Object stateCode = trajectory.getSolution().getStateCode();
        if (this.savedSolutions.contains(stateCode)) {
            return;
        }
        this.savedSolutions.add(stateCode);
        Notifier clonedModel = EMFHelper.clone(context.getModel());
        EMFHelper.saveModel(clonedModel, this.solutionNameProvider.getName());
    }
}

