/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.osgi.common;

import java.util.Arrays;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.util.math.Range;

public final class Version
implements Comparable<Version> {
    private static final int DEFAULT_VERSION_COMPONENT = 0;
    private static final String MINIMUM_VERSION_STRING = "0";
    public static final Version MINIMUM_VERSION;
    public static final Version MAXIMUM_VERSION;
    private final org.osgi.framework.Version version;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    static {
        Factory factory = new Factory("Version.java", Class.forName("org.eclipse.virgo.kernel.osgi.common.Version"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "compareTo", "org.eclipse.virgo.kernel.osgi.common.Version", "org.eclipse.virgo.kernel.osgi.common.Version:", "v2:", "", "int"), 60);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "stringToVersionRange", "org.eclipse.virgo.kernel.osgi.common.Version", "java.lang.String:", "stringRange:", "", "org.eclipse.virgo.util.math.Range"), 73);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "hashCode", "org.eclipse.virgo.kernel.osgi.common.Version", "", "", "", "int"), 96);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "equals", "org.eclipse.virgo.kernel.osgi.common.Version", "java.lang.Object:", "obj:", "", "boolean"), 103);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toString", "org.eclipse.virgo.kernel.osgi.common.Version", "", "", "", "java.lang.String"), 120);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.osgi.common.Version");
        MINIMUM_VERSION = new Version(MINIMUM_VERSION_STRING);
        MAXIMUM_VERSION = new Version(Arrays.asList(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE));
    }

    public Version(String v) {
        this.version = org.osgi.framework.Version.parseVersion((String)v);
    }

    public Version(org.osgi.framework.Version version) {
        this.version = version;
    }

    public Version(List<Integer> comp) {
        if (comp.size() > 3) {
            throw new NumberFormatException("Versions may have at most three numeric components");
        }
        int major = comp.size() >= 1 ? comp.get(0) : 0;
        int minor = comp.size() >= 2 ? comp.get(1) : 0;
        int micro = comp.size() == 3 ? comp.get(2) : 0;
        this.version = new org.osgi.framework.Version(major, minor, micro);
    }

    @Override
    public int compareTo(Version v2) {
        try {
            Version.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
            int n = this.version.compareTo(v2.version);
            Version.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return n;
        }
        catch (Throwable throwable) {
            Version.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    public static Range<Version> stringToVersionRange(String stringRange) {
        try {
            Range range;
            Version.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
            if (stringRange == null) {
                range = Version.stringToVersionRange(MINIMUM_VERSION_STRING);
            } else {
                boolean delimitedRange;
                boolean floorInc = stringRange.startsWith("[");
                boolean floorExc = stringRange.startsWith("(");
                boolean ceilingInc = stringRange.endsWith("]");
                boolean ceilingExc = stringRange.endsWith(")");
                int separatorIndex = stringRange.indexOf(",");
                boolean bl = delimitedRange = !(!floorInc && !floorExc || !ceilingInc && !ceilingExc || separatorIndex == -1);
                if (delimitedRange) {
                    String floor = stringRange.substring(1, separatorIndex);
                    String ceiling = stringRange.substring(separatorIndex + 1, stringRange.length() - 1);
                    range = new Range((Comparable)new Version(floor), floorInc, (Comparable)new Version(ceiling), ceilingInc);
                } else {
                    range = new Range((Comparable)new Version(stringRange), true, (Comparable)MAXIMUM_VERSION, false);
                }
            }
            Version.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
            return range;
        }
        catch (Throwable throwable) {
            Version.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    public int hashCode() {
        try {
            Version.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_2);
            int n = this.version.hashCode();
            Version.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_2);
            return n;
        }
        catch (Throwable throwable) {
            Version.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    public boolean equals(Object obj) {
        try {
            boolean bl;
            Version.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_3);
            if (this == obj) {
                bl = true;
            } else if (obj == null) {
                bl = false;
            } else if (this.getClass() != obj.getClass()) {
                bl = false;
            } else {
                Version other = (Version)obj;
                bl = this.version.equals((Object)other.version);
            }
            Version.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_3);
            return bl;
        }
        catch (Throwable throwable) {
            Version.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    public String toString() {
        try {
            Version.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_4);
            String result = this.version.toString();
            while (result.endsWith(".0")) {
                result = result.substring(0, result.length() - 2);
            }
            String string = result;
            Version.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_4);
            return string;
        }
        catch (Throwable throwable) {
            Version.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_4);
            throw throwable;
        }
    }
}

