/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.osgi.region.hook;

import java.util.Collection;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.virgo.kernel.osgi.region.Region;
import org.eclipse.virgo.kernel.osgi.region.RegionDigraph;
import org.eclipse.virgo.kernel.osgi.region.RegionFilter;
import org.eclipse.virgo.kernel.osgi.region.hook.RegionDigraphVisitorBase;
import org.eclipse.virgo.kernel.serviceability.Assert;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.osgi.framework.Bundle;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;

final class RegionResolverHook
implements ResolverHook {
    private static final long INVALID_BUNDLE_ID = -1L;
    private static final Boolean DEBUG;
    private final RegionDigraph regionDigraph;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    static {
        Factory factory = new Factory("RegionResolverHook.java", Class.forName("org.eclipse.virgo.kernel.osgi.region.hook.RegionResolverHook"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "filterMatches", "org.eclipse.virgo.kernel.osgi.region.hook.RegionResolverHook", "org.osgi.framework.wiring.BundleRequirement:java.util.Collection:", "requirement:candidates:", "", "void"), 50);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "end", "org.eclipse.virgo.kernel.osgi.region.hook.RegionResolverHook", "", "", "", "void"), 129);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "filterResolvable", "org.eclipse.virgo.kernel.osgi.region.hook.RegionResolverHook", "java.util.Collection:", "candidates:", "", "void"), 133);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "filterSingletonCollisions", "org.eclipse.virgo.kernel.osgi.region.hook.RegionResolverHook", "org.osgi.framework.wiring.BundleCapability:java.util.Collection:", "singleton:collisionCandidates:", "", "void"), 137);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "debugEntry", "org.eclipse.virgo.kernel.osgi.region.hook.RegionResolverHook", "org.osgi.framework.wiring.BundleRevision:java.util.Collection:", "requirer:candidates:", "", "void"), 141);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "debugExit", "org.eclipse.virgo.kernel.osgi.region.hook.RegionResolverHook", "org.osgi.framework.wiring.BundleRevision:java.util.Collection:", "requirer:candidates:", "", "void"), 164);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1008", "access$0", "org.eclipse.virgo.kernel.osgi.region.hook.RegionResolverHook", "org.eclipse.virgo.kernel.osgi.region.hook.RegionResolverHook:org.osgi.framework.wiring.BundleRevision:", "arg0:arg1:", "", "org.eclipse.virgo.kernel.osgi.region.Region"), 96);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.osgi.region.hook.RegionResolverHook");
        DEBUG = false;
    }

    RegionResolverHook(RegionDigraph regionDigraph) {
        this.regionDigraph = regionDigraph;
    }

    public void filterMatches(BundleRequirement requirement, Collection<BundleCapability> candidates) {
        try {
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
            BundleRevision requirer = requirement.getRevision();
            try {
                if (DEBUG.booleanValue()) {
                    this.debugEntry(requirer, candidates);
                }
                if (this.getBundleId(requirer) != 0L) {
                    Region requirerRegion = this.getRegion(requirer);
                    if (requirerRegion == null) {
                        candidates.clear();
                    } else {
                        Visitor visitor = new Visitor(candidates);
                        requirerRegion.visitSubgraph(visitor);
                        Set allowed = visitor.getAllowed();
                        candidates.retainAll(allowed);
                    }
                }
            }
            finally {
                if (DEBUG.booleanValue()) {
                    this.debugExit(requirer, candidates);
                }
            }
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return;
        }
        catch (Throwable throwable) {
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    private Region getRegion(BundleRevision bundleRevision) {
        Bundle bundle = bundleRevision.getBundle();
        if (bundle != null) {
            return this.getRegion(bundle);
        }
        Long bundleId = this.getBundleId(bundleRevision);
        return this.getRegion(bundleId);
    }

    private Region getRegion(Long bundleId) {
        return this.regionDigraph.getRegion(bundleId);
    }

    private Long getBundleId(BundleRevision bundleRevision) {
        Bundle bundle = bundleRevision.getBundle();
        if (bundle != null) {
            return bundle.getBundleId();
        }
        if (bundleRevision instanceof BundleDescription) {
            BundleDescription bundleDescription = (BundleDescription)bundleRevision;
            return bundleDescription.getBundleId();
        }
        Assert.isTrue((boolean)false, (String)"Cannot determine bundle id of BundleRevision '%s'", (Object[])new Object[]{bundleRevision});
        return -1L;
    }

    private Region getRegion(Bundle bundle) {
        return this.regionDigraph.getRegion(bundle);
    }

    public void end() {
        try {
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
            return;
        }
        catch (Throwable throwable) {
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    public void filterResolvable(Collection<BundleRevision> candidates) {
        try {
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_2);
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_2);
            return;
        }
        catch (Throwable throwable) {
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    public void filterSingletonCollisions(BundleCapability singleton, Collection<BundleCapability> collisionCandidates) {
        try {
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_3);
            collisionCandidates.clear();
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_3);
            return;
        }
        catch (Throwable throwable) {
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    private void debugEntry(BundleRevision requirer, Collection<BundleCapability> candidates) {
        try {
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
            System.out.println("Requirer: " + requirer.getSymbolicName() + "_" + requirer.getVersion() + "[" + this.getBundleId(requirer) + "]");
            System.out.println("  Candidates: ");
            for (BundleCapability c : candidates) {
                BundleRevision providerRevision;
                String namespace = c.getNamespace();
                if ("osgi.wiring.package".equals(namespace)) {
                    providerRevision = c.getRevision();
                    String pkg = (String)c.getAttributes().get("osgi.wiring.package");
                    System.out.println("    Package " + pkg + " from provider " + providerRevision.getSymbolicName() + "_" + providerRevision.getVersion() + "[" + this.getBundleId(providerRevision) + "]");
                    if (!pkg.equals("slow")) continue;
                    System.out.println(">>> put breakpoint here <<<");
                    continue;
                }
                providerRevision = c.getRevision();
                System.out.println("    Bundle from provider " + providerRevision.getSymbolicName() + "_" + providerRevision.getVersion() + "[" + this.getBundleId(providerRevision) + "]");
            }
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
            return;
        }
        catch (Throwable throwable) {
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
            throw throwable;
        }
    }

    private void debugExit(BundleRevision requirer, Collection<BundleCapability> candidates) {
        try {
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_5);
            System.out.println("  Filtered candidates: ");
            for (BundleCapability c : candidates) {
                BundleRevision providerRevision;
                String namespace = c.getNamespace();
                if ("osgi.wiring.package".equals(namespace)) {
                    providerRevision = c.getRevision();
                    String pkg = (String)c.getAttributes().get("osgi.wiring.package");
                    System.out.println("    Package " + pkg + " from provider " + providerRevision.getSymbolicName() + "_" + providerRevision.getVersion() + "[" + this.getBundleId(providerRevision) + "]");
                    if (!pkg.equals("slow")) continue;
                    System.out.println(">>> put breakpoint here <<<");
                    continue;
                }
                providerRevision = c.getRevision();
                System.out.println("    Bundle from provider " + providerRevision.getSymbolicName() + "_" + providerRevision.getVersion() + "[" + this.getBundleId(providerRevision) + "]");
            }
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_5);
            return;
        }
        catch (Throwable throwable) {
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_5);
            throw throwable;
        }
    }

    static /* synthetic */ Region access$0(RegionResolverHook arg0, BundleRevision arg1) {
        try {
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_6);
            Region region = arg0.getRegion(arg1);
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_6);
            return region;
        }
        catch (Throwable throwable) {
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_6);
            throw throwable;
        }
    }

    private class Visitor
    extends RegionDigraphVisitorBase<BundleCapability> {
        private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

        private Visitor(Collection<BundleCapability> candidates) {
            super(candidates);
        }

        @Override
        protected boolean contains(Region region, BundleCapability candidate) {
            try {
                Visitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_0);
                boolean bl = region.equals(RegionResolverHook.access$0(RegionResolverHook.this, candidate.getRevision()));
                Visitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_0);
                return bl;
            }
            catch (Throwable throwable) {
                Visitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_0);
                throw throwable;
            }
        }

        @Override
        protected boolean isAllowed(BundleCapability candidate, RegionFilter filter) {
            try {
                Visitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
                boolean bl = filter.isAllowed(candidate) || filter.isAllowed(candidate.getRevision());
                Visitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
                return bl;
            }
            catch (Throwable throwable) {
                Visitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
                throw throwable;
            }
        }

        static {
            Factory factory = new Factory("RegionResolverHook.java", Class.forName("org.eclipse.virgo.kernel.osgi.region.hook.RegionResolverHook$Visitor"));
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "contains", "org.eclipse.virgo.kernel.osgi.region.hook.RegionResolverHook$Visitor", "org.eclipse.virgo.kernel.osgi.region.Region:org.osgi.framework.wiring.BundleCapability:", "region:candidate:", "", "boolean"), 86);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "isAllowed", "org.eclipse.virgo.kernel.osgi.region.hook.RegionResolverHook$Visitor", "org.osgi.framework.wiring.BundleCapability:org.eclipse.virgo.kernel.osgi.region.RegionFilter:", "candidate:filter:", "", "boolean"), 91);
            ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.osgi.region.hook.RegionResolverHook$Visitor");
        }
    }
}

