/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.osgi.region.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.osgi.region.Region;
import org.eclipse.virgo.kernel.osgi.region.RegionDigraph;
import org.eclipse.virgo.kernel.osgi.region.RegionDigraphVisitor;
import org.eclipse.virgo.kernel.osgi.region.RegionFilter;
import org.eclipse.virgo.kernel.serviceability.NonNull;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.util.math.ConcurrentHashSet;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

final class BundleIdBasedRegion
implements Region {
    private static final String REGION_LOCATION_DELIMITER = "@";
    private static final String REFERENCE_SCHEME = "reference:";
    private static final String FILE_SCHEME = "file:";
    private final Set<Long> bundleIds = new ConcurrentHashSet();
    private final Object updateMonitor = new Object();
    private final String regionName;
    private final RegionDigraph regionDigraph;
    private final BundleContext systemBundleContext;
    private final ThreadLocal<Region> threadLocal;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;

    BundleIdBasedRegion(@NonNull String regionName, @NonNull RegionDigraph regionDigraph, @NonNull BundleContext systemBundleContext, @NonNull ThreadLocal<Region> threadLocal) {
        this.regionName = regionName;
        this.regionDigraph = regionDigraph;
        this.systemBundleContext = systemBundleContext;
        this.threadLocal = threadLocal;
    }

    @Override
    public String getName() {
        return this.regionName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBundle(Bundle bundle) throws BundleException {
        try {
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
            Object object = this.updateMonitor;
            synchronized (object) {
                this.checkBundleNotAssociatedWithAnotherRegion(bundle);
                this.bundleIds.add(bundle.getBundleId());
            }
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return;
        }
        catch (Throwable throwable) {
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    private void checkBundleNotAssociatedWithAnotherRegion(Bundle bundle) throws BundleException {
        try {
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
            for (Region r : this.regionDigraph) {
                if (this.equals(r) || !r.contains(bundle)) continue;
                throw new BundleException("Bundle '" + bundle + "' is already associated with region '" + r + "'", 2);
            }
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
            return;
        }
        catch (Throwable throwable) {
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBundle(long bundleId) {
        try {
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_2);
            Object object = this.updateMonitor;
            synchronized (object) {
                this.bundleIds.add(bundleId);
            }
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_2);
            return;
        }
        catch (Throwable throwable) {
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    @Override
    public Bundle installBundle(String location, InputStream input) throws BundleException {
        try {
            Bundle bundle;
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_3);
            this.setRegionThreadLocal();
            try {
                Bundle bundle2 = this.systemBundleContext.installBundle(String.valueOf(this.regionName) + REGION_LOCATION_DELIMITER + location, input);
                bundle = bundle2;
            }
            finally {
                this.removeRegionThreadLocal();
            }
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_3);
            return bundle;
        }
        catch (Throwable throwable) {
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    @Override
    public Bundle installBundle(String location) throws BundleException {
        try {
            Bundle bundle;
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_4);
            this.setRegionThreadLocal();
            try {
                Bundle bundle2 = this.systemBundleContext.installBundle(String.valueOf(this.regionName) + REGION_LOCATION_DELIMITER + location, this.openBundleStream(location));
                bundle = bundle2;
            }
            finally {
                this.removeRegionThreadLocal();
            }
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_4);
            return bundle;
        }
        catch (Throwable throwable) {
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_4);
            throw throwable;
        }
    }

    private void setRegionThreadLocal() {
        this.threadLocal.set(this);
    }

    private void removeRegionThreadLocal() {
        try {
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_5);
            this.threadLocal.remove();
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_5);
            return;
        }
        catch (Throwable throwable) {
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_5);
            throw throwable;
        }
    }

    private InputStream openBundleStream(String location) throws BundleException {
        try {
            InputStream inputStream;
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_6);
            String absoluteBundleUriString = this.getAbsoluteUriString(location);
            try {
                inputStream = new URL(REFERENCE_SCHEME + absoluteBundleUriString).openStream();
            }
            catch (MalformedURLException e) {
                throw new BundleException("Location '" + location + "' resulted in an invalid bundle URI '" + absoluteBundleUriString + "'", (Throwable)e);
            }
            catch (IOException e) {
                throw new BundleException("Location '" + location + "' referred to an invalid bundle at URI '" + absoluteBundleUriString + "'", (Throwable)e);
            }
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_6);
            return inputStream;
        }
        catch (Throwable throwable) {
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_6);
            throw throwable;
        }
    }

    private String getAbsoluteUriString(String location) throws BundleException {
        if (!location.startsWith(FILE_SCHEME)) {
            throw new BundleException("Cannot install from location '" + location + "' which did not start with '" + FILE_SCHEME + "'");
        }
        String filePath = location.substring(FILE_SCHEME.length());
        return FILE_SCHEME + new File(filePath).getAbsolutePath();
    }

    @Override
    public Bundle getBundle(@NonNull String symbolicName, @NonNull Version version) {
        for (long bundleId : this.bundleIds) {
            Bundle bundle = this.systemBundleContext.getBundle(bundleId);
            if (bundle == null || !symbolicName.equals(bundle.getSymbolicName()) || !version.equals((Object)bundle.getVersion())) continue;
            return bundle;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectRegion(Region headRegion, RegionFilter filter) throws BundleException {
        try {
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_7);
            Object object = this.updateMonitor;
            synchronized (object) {
                this.regionDigraph.connect(this, filter, headRegion);
            }
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_7);
            return;
        }
        catch (Throwable throwable) {
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_7);
            throw throwable;
        }
    }

    @Override
    public boolean contains(Bundle bundle) {
        try {
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_8);
            boolean bl = this.bundleIds.contains(bundle.getBundleId());
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_8);
            return bl;
        }
        catch (Throwable throwable) {
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_8);
            throw throwable;
        }
    }

    public int hashCode() {
        try {
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_9);
            int result = 1;
            int n = result = 31 * result + this.regionName.hashCode();
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_9);
            return n;
        }
        catch (Throwable throwable) {
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_9);
            throw throwable;
        }
    }

    public boolean equals(Object obj) {
        try {
            boolean bl;
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_10);
            if (this == obj) {
                bl = true;
            } else if (obj == null) {
                bl = false;
            } else if (!(obj instanceof BundleIdBasedRegion)) {
                bl = false;
            } else {
                BundleIdBasedRegion other = (BundleIdBasedRegion)obj;
                bl = this.regionName.equals(other.regionName);
            }
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_10);
            return bl;
        }
        catch (Throwable throwable) {
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_10);
            throw throwable;
        }
    }

    @Override
    public boolean contains(long bundleId) {
        try {
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_11);
            boolean bl = this.bundleIds.contains(bundleId);
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_11);
            return bl;
        }
        catch (Throwable throwable) {
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_11);
            throw throwable;
        }
    }

    @Override
    public void removeBundle(Bundle bundle) {
        try {
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_12);
            this.removeBundle(bundle.getBundleId());
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_12);
            return;
        }
        catch (Throwable throwable) {
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_12);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBundle(long bundleId) {
        try {
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_13);
            Object object = this.updateMonitor;
            synchronized (object) {
                this.bundleIds.remove(bundleId);
            }
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_13);
            return;
        }
        catch (Throwable throwable) {
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_13);
            throw throwable;
        }
    }

    public String toString() {
        try {
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_14);
            String string = this.getName();
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_14);
            return string;
        }
        catch (Throwable throwable) {
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_14);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Long> getBundleIds() {
        HashSet<Long> bundleIds = new HashSet<Long>();
        Object object = this.updateMonitor;
        synchronized (object) {
            bundleIds.addAll(this.bundleIds);
        }
        return bundleIds;
    }

    @Override
    public Set<RegionDigraph.FilteredRegion> getEdges() {
        return this.regionDigraph.getEdges(this);
    }

    @Override
    public void visitSubgraph(RegionDigraphVisitor visitor) {
        try {
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_15);
            this.regionDigraph.visitSubgraph(this, visitor);
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_15);
            return;
        }
        catch (Throwable throwable) {
            BundleIdBasedRegion.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_15);
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("BundleIdBasedRegion.java", Class.forName("org.eclipse.virgo.kernel.osgi.region.internal.BundleIdBasedRegion"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addBundle", "org.eclipse.virgo.kernel.osgi.region.internal.BundleIdBasedRegion", "org.osgi.framework.Bundle:", "bundle:", "org.osgi.framework.BundleException:", "void"), 85);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkBundleNotAssociatedWithAnotherRegion", "org.eclipse.virgo.kernel.osgi.region.internal.BundleIdBasedRegion", "org.osgi.framework.Bundle:", "bundle:", "org.osgi.framework.BundleException:", "void"), 93);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "equals", "org.eclipse.virgo.kernel.osgi.region.internal.BundleIdBasedRegion", "java.lang.Object:", "obj:", "", "boolean"), 212);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "contains", "org.eclipse.virgo.kernel.osgi.region.internal.BundleIdBasedRegion", "long:", "bundleId:", "", "boolean"), 230);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removeBundle", "org.eclipse.virgo.kernel.osgi.region.internal.BundleIdBasedRegion", "org.osgi.framework.Bundle:", "bundle:", "", "void"), 238);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removeBundle", "org.eclipse.virgo.kernel.osgi.region.internal.BundleIdBasedRegion", "long:", "bundleId:", "", "void"), 247);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toString", "org.eclipse.virgo.kernel.osgi.region.internal.BundleIdBasedRegion", "", "", "", "java.lang.String"), 257);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "visitSubgraph", "org.eclipse.virgo.kernel.osgi.region.internal.BundleIdBasedRegion", "org.eclipse.virgo.kernel.osgi.region.RegionDigraphVisitor:", "visitor:", "", "void"), 279);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addBundle", "org.eclipse.virgo.kernel.osgi.region.internal.BundleIdBasedRegion", "long:", "bundleId:", "", "void"), 105);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "installBundle", "org.eclipse.virgo.kernel.osgi.region.internal.BundleIdBasedRegion", "java.lang.String:java.io.InputStream:", "location:input:", "org.osgi.framework.BundleException:", "org.osgi.framework.Bundle"), 115);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "installBundle", "org.eclipse.virgo.kernel.osgi.region.internal.BundleIdBasedRegion", "java.lang.String:", "location:", "org.osgi.framework.BundleException:", "org.osgi.framework.Bundle"), 128);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "removeRegionThreadLocal", "org.eclipse.virgo.kernel.osgi.region.internal.BundleIdBasedRegion", "", "", "", "void"), 141);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "openBundleStream", "org.eclipse.virgo.kernel.osgi.region.internal.BundleIdBasedRegion", "java.lang.String:", "location:", "org.osgi.framework.BundleException:", "java.io.InputStream"), 145);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "connectRegion", "org.eclipse.virgo.kernel.osgi.region.internal.BundleIdBasedRegion", "org.eclipse.virgo.kernel.osgi.region.Region:org.eclipse.virgo.kernel.osgi.region.RegionFilter:", "headRegion:filter:", "org.osgi.framework.BundleException:", "void"), 189);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "contains", "org.eclipse.virgo.kernel.osgi.region.internal.BundleIdBasedRegion", "org.osgi.framework.Bundle:", "bundle:", "", "boolean"), 199);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "hashCode", "org.eclipse.virgo.kernel.osgi.region.internal.BundleIdBasedRegion", "", "", "", "int"), 205);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.osgi.region.internal.BundleIdBasedRegion");
    }
}

