/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.osgicommand;

import org.eclipse.osgi.framework.console.CommandProvider;
import org.eclipse.virgo.kernel.osgi.framework.OsgiFrameworkUtils;
import org.eclipse.virgo.kernel.osgi.framework.OsgiServiceHolder;
import org.eclipse.virgo.kernel.osgicommand.internal.OsgiKernelShellCommand;
import org.eclipse.virgo.kernel.osgicommand.internal.commands.classloading.ClassLoadingCommandProvider;
import org.eclipse.virgo.kernel.shell.CommandExecutor;
import org.eclipse.virgo.util.osgi.ServiceRegistrationTracker;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    private static final int COMMAND_EXECUTOR_SERVICE_WAIT = 20000;
    private static final int SERVICE_WAIT_PAUSE = 100;
    private static final String PROVIDER_NAME = "org.eclipse.osgi.framework.console.CommandProvider";
    private ServiceRegistration<?> providerRegistration = null;
    private final ServiceRegistrationTracker registrationTracker = new ServiceRegistrationTracker();

    public void start(BundleContext context) throws Exception {
        boolean registerCommands = true;
        try {
            Class.forName(PROVIDER_NAME);
        }
        catch (ClassNotFoundException classNotFoundException) {
            registerCommands = false;
        }
        if (registerCommands) {
            ClassLoadingCommandProvider provider = new ClassLoadingCommandProvider(context);
            this.providerRegistration = context.registerService(PROVIDER_NAME, (Object)provider, null);
        }
        PostStartInitialisationRunnable runnable = new PostStartInitialisationRunnable(context, this.registrationTracker);
        Thread thread = new Thread(runnable);
        thread.setDaemon(true);
        thread.start();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.providerRegistration != null) {
            this.providerRegistration.unregister();
        }
        this.providerRegistration = null;
        this.registrationTracker.unregisterAll();
    }

    private static <T> T getPotentiallyDelayedService(BundleContext context, Class<T> serviceClass, long millis) {
        Object service = null;
        while (service == null) {
            try {
                OsgiServiceHolder serviceHolder = OsgiFrameworkUtils.getService((BundleContext)context, serviceClass);
                if (serviceHolder == null) continue;
                service = serviceHolder.getService();
            }
            catch (IllegalStateException illegalStateException) {
                block5: {
                    try {
                        if ((millis -= 100L) <= 0L) break block5;
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return null;
            }
        }
        return (T)service;
    }

    private static final class PostStartInitialisationRunnable
    implements Runnable {
        private final BundleContext context;
        private final ServiceRegistrationTracker registrationTracker;

        public PostStartInitialisationRunnable(BundleContext context, ServiceRegistrationTracker registrationTracker) {
            this.context = context;
            this.registrationTracker = registrationTracker;
        }

        @Override
        public void run() {
            CommandExecutor commandExecutor = (CommandExecutor)Activator.getPotentiallyDelayedService(this.context, CommandExecutor.class, 20000L);
            if (commandExecutor == null) {
                return;
            }
            this.registrationTracker.track(this.context.registerService(CommandProvider.class.getName(), (Object)new OsgiKernelShellCommand(commandExecutor), null));
        }
    }
}

