/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.context.internal.classloader;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.osgi.framework.Bundle;
import org.springframework.osgi.context.internal.classloader.BundleClassLoaderFactory;
import org.springframework.osgi.util.BundleDelegatingClassLoader;

class CachingBundleClassLoaderFactory
implements BundleClassLoaderFactory {
    private static final String DELIMITER = "|";
    private final Map cache = new WeakHashMap();

    CachingBundleClassLoaderFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader createClassLoader(Bundle bundle) {
        ClassLoader loader = null;
        Object key = this.createKeyFor(bundle);
        HashMap<Object, WeakReference<ClassLoader>> loaders = null;
        HashMap<Object, WeakReference<ClassLoader>> hashMap = this.cache;
        synchronized (hashMap) {
            loaders = (HashMap<Object, WeakReference<ClassLoader>>)this.cache.get(bundle);
            if (loaders == null) {
                loaders = new HashMap<Object, WeakReference<ClassLoader>>(4);
                loader = this.createBundleClassLoader(bundle);
                loaders.put(key, new WeakReference<ClassLoader>(loader));
                return loader;
            }
        }
        hashMap = loaders;
        synchronized (hashMap) {
            WeakReference reference = (WeakReference)loaders.get(key);
            if (reference != null) {
                loader = (ClassLoader)reference.get();
            }
            if (loader == null) {
                loader = this.createBundleClassLoader(bundle);
                loaders.put(key, new WeakReference<ClassLoader>(loader));
            }
            return loader;
        }
    }

    private Object createKeyFor(Bundle bundle) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(bundle.getBundleId());
        buffer.append(DELIMITER);
        buffer.append(Long.toHexString(bundle.getLastModified()));
        buffer.append(DELIMITER);
        buffer.append(bundle.getClass().getName());
        return buffer.toString();
    }

    private ClassLoader createBundleClassLoader(Bundle bundle) {
        return BundleDelegatingClassLoader.createBundleClassLoaderFor(bundle);
    }
}

