/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.shell.internal.completers;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.shell.CommandCompleter;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.repository.management.ArtifactDescriptorSummary;
import org.eclipse.virgo.repository.management.RepositoryInfo;

public class InstallCompleter
implements CommandCompleter {
    private static final String FILE_PREFIX = "file:";
    private static final String FILE_PATH_CANDIDATE_FORMAT = "file:%s%s";
    private static final String REPOSITORY_PREFIX = "repository:";
    private static final String REPOSITORY_TYPE_NAME_VERSION_FORMAT = "repository:%s/%s/%s";
    private static final String REPOSITORY_TYPE_NAME_FORMAT = "repository:%s/%s/";
    private static final String REPOSITORY_TYPE_FORMAT = "repository:%s/";
    private static final String[] SCHEMES;
    private final MBeanServer server = ManagementFactory.getPlatformMBeanServer();
    private final ObjectName repositoryQuery = new ObjectName("org.eclipse.virgo.kernel:type=Repository,*");
    private final ObjectName hostedRepositoryQuery = new ObjectName("org.eclipse.virgo.server:type=HostedRepository,*");
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    static {
        Factory factory = new Factory("InstallCompleter.java", Class.forName("org.eclipse.virgo.kernel.shell.internal.completers.InstallCompleter"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "file", "org.eclipse.virgo.kernel.shell.internal.completers.InstallCompleter", "java.lang.String:", "subcommand:", "", "java.util.Set"), 84);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "repository", "org.eclipse.virgo.kernel.shell.internal.completers.InstallCompleter", "java.lang.String:", "subcommand:", "", "java.util.Set"), 103);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "type", "org.eclipse.virgo.kernel.shell.internal.completers.InstallCompleter", "java.lang.String:", "type:", "", "java.util.Set"), 124);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "name", "org.eclipse.virgo.kernel.shell.internal.completers.InstallCompleter", "java.lang.String:java.lang.String:", "type:name:", "", "java.util.Set"), 138);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "version", "org.eclipse.virgo.kernel.shell.internal.completers.InstallCompleter", "java.lang.String:java.lang.String:java.lang.String:", "type:name:version:", "", "java.util.Set"), 152);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.shell.internal.completers.InstallCompleter");
        SCHEMES = new String[]{FILE_PREFIX, REPOSITORY_PREFIX};
    }

    @Override
    public List<String> getCompletionCandidates(String subcommand, String ... arguments) {
        Set<Object> candidates;
        if (arguments.length == 0) {
            if (subcommand.startsWith(REPOSITORY_PREFIX)) {
                candidates = this.repository(subcommand);
            } else if (subcommand.startsWith(FILE_PREFIX)) {
                candidates = this.file(subcommand);
            } else {
                candidates = new HashSet();
                String[] stringArray = SCHEMES;
                int n = SCHEMES.length;
                int n2 = 0;
                while (n2 < n) {
                    String scheme = stringArray[n2];
                    if (scheme.startsWith(subcommand)) {
                        candidates.add(scheme);
                    }
                    ++n2;
                }
            }
        } else {
            candidates = new HashSet();
        }
        ArrayList<String> candidateList = new ArrayList<String>(candidates);
        Collections.sort(candidateList);
        return candidateList;
    }

    private Set<String> file(String subcommand) {
        try {
            InstallCompleter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_0);
            ArrayList candidates = new ArrayList();
            String path = subcommand.substring(FILE_PREFIX.length());
            int completionIndex = 0;
            HashSet<String> candidateSet = new HashSet<String>(candidates.size());
            if (completionIndex >= 0) {
                String completablePath = path.substring(0, completionIndex);
                for (String candidate : candidates) {
                    candidateSet.add(String.format(FILE_PATH_CANDIDATE_FORMAT, completablePath, candidate));
                }
            }
            HashSet<String> hashSet = candidateSet;
            InstallCompleter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_0);
            return hashSet;
        }
        catch (Throwable throwable) {
            InstallCompleter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    private Set<String> repository(String subcommand) {
        try {
            InstallCompleter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
            List<String> uriParts = this.getUriParts(subcommand);
            Set<String> set = uriParts.size() == 1 ? this.type(uriParts.get(0)) : (uriParts.size() == 2 ? this.name(uriParts.get(0), uriParts.get(1)) : (uriParts.size() == 3 ? this.version(uriParts.get(0), uriParts.get(1), uriParts.get(2)) : Collections.emptySet()));
            InstallCompleter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
            return set;
        }
        catch (Throwable throwable) {
            InstallCompleter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    private List<String> getUriParts(String subcommand) {
        ArrayList<String> uriParts = new ArrayList<String>((Collection)Arrays.asList(subcommand.substring(REPOSITORY_PREFIX.length()).split("/")));
        if (subcommand.endsWith("/")) {
            uriParts.add("");
        }
        return uriParts;
    }

    private Set<String> type(String type) {
        try {
            InstallCompleter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
            HashSet<String> types = new HashSet<String>();
            for (RepositoryInfo repository : this.getRepositories()) {
                for (ArtifactDescriptorSummary artifact : repository.getAllArtifactDescriptorSummaries()) {
                    if (!artifact.getType().startsWith(type)) continue;
                    types.add(String.format(REPOSITORY_TYPE_FORMAT, artifact.getType()));
                }
            }
            HashSet<String> hashSet = types;
            InstallCompleter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
            return hashSet;
        }
        catch (Throwable throwable) {
            InstallCompleter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    private Set<String> name(String type, String name) {
        try {
            InstallCompleter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
            HashSet<String> names = new HashSet<String>();
            for (RepositoryInfo repository : this.getRepositories()) {
                for (ArtifactDescriptorSummary artifact : repository.getAllArtifactDescriptorSummaries()) {
                    if (!artifact.getType().equals(type) || !artifact.getName().startsWith(name)) continue;
                    names.add(String.format(REPOSITORY_TYPE_NAME_FORMAT, artifact.getType(), artifact.getName()));
                }
            }
            HashSet<String> hashSet = names;
            InstallCompleter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
            return hashSet;
        }
        catch (Throwable throwable) {
            InstallCompleter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    private Set<String> version(String type, String name, String version) {
        try {
            InstallCompleter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
            HashSet<String> versions = new HashSet<String>();
            for (RepositoryInfo repository : this.getRepositories()) {
                for (ArtifactDescriptorSummary artifact : repository.getAllArtifactDescriptorSummaries()) {
                    if (!artifact.getType().equals(type) || !artifact.getName().equals(name) || !artifact.getVersion().startsWith(version)) continue;
                    versions.add(String.format(REPOSITORY_TYPE_NAME_VERSION_FORMAT, artifact.getType(), artifact.getName(), artifact.getVersion()));
                }
            }
            HashSet<String> hashSet = versions;
            InstallCompleter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
            return hashSet;
        }
        catch (Throwable throwable) {
            InstallCompleter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
            throw throwable;
        }
    }

    private Set<RepositoryInfo> getRepositories() {
        HashSet<String> hostedRepositoryNames = new HashSet<String>();
        for (ObjectName objectName : this.server.queryNames(this.hostedRepositoryQuery, null)) {
            hostedRepositoryNames.add(objectName.getKeyProperty("name"));
        }
        HashSet<RepositoryInfo> repositories = new HashSet<RepositoryInfo>();
        for (ObjectName objectName : this.server.queryNames(this.repositoryQuery, null)) {
            String name = objectName.getKeyProperty("name");
            if (hostedRepositoryNames.contains(name)) continue;
            repositories.add(JMX.newMXBeanProxy(this.server, objectName, RepositoryInfo.class));
        }
        return repositories;
    }
}

