/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.apps.admin.web;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.virgo.apps.admin.core.DumpInspectorService;
import org.eclipse.virgo.apps.admin.web.internal.DumpListFormatterUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public final class DumpController {
    private final DumpInspectorService dumpInspectorService;
    private final DumpListFormatterUtil dumpListFormatterUtil;
    private static final int DUMP_TYPE = 1;
    private static final int ENTRY_TYPE = 2;

    @Autowired
    public DumpController(DumpInspectorService dumpManagerService, DumpListFormatterUtil dumpListFormatterUtil) {
        this.dumpInspectorService = dumpManagerService;
        this.dumpListFormatterUtil = dumpListFormatterUtil;
    }

    @RequestMapping(value={"/dump/inspector.htm"})
    public ModelAndView dump() {
        Map dumps = this.dumpListFormatterUtil.getAvaliableDumps();
        List dumpEntries = Collections.emptyList();
        String inspection = "";
        return this.createContextDumpModelAndView(dumps, null, dumpEntries, null, inspection);
    }

    @RequestMapping(value={"/dump/entry.htm"})
    public ModelAndView dumpEntry(HttpServletRequest request) {
        String dumpID = ServletRequestUtils.getStringParameter((ServletRequest)request, (String)"dumpID", null);
        int requestType = this.getRequestType(request);
        Map dumps = this.dumpListFormatterUtil.getAvaliableDumps();
        String dumpEntryName = null;
        List dumpEntries = null;
        String inspection = null;
        if (requestType == 2 || dumpID == null) {
            dumpEntryName = ServletRequestUtils.getStringParameter((ServletRequest)request, (String)"dumpEntryName", null);
            dumpEntries = this.dumpInspectorService.getDumpEntries(dumpID);
            inspection = this.dumpInspectorService.getDumpEntry(dumpID, dumpEntryName);
        }
        return this.createContextDumpModelAndView(dumps, dumpID, dumpEntries, dumpEntryName, inspection);
    }

    private ModelAndView createContextDumpModelAndView(Map<String, String> dumps, String selectedDump, List<String> entries, String selectedEntry, String inspection) {
        String formattedSelectedDump = null;
        if (selectedDump != null) {
            formattedSelectedDump = dumps.get(selectedDump);
        }
        return new ModelAndView("dump-overview").addObject("dumps", dumps).addObject("selectedDump", (Object)selectedDump).addObject("formattedSelectedDump", (Object)formattedSelectedDump).addObject("entries", entries).addObject("selectedEntry", (Object)selectedEntry).addObject("inspection", (Object)inspection);
    }

    private int getRequestType(HttpServletRequest request) {
        try {
            String buttonName = ServletRequestUtils.getStringParameter((ServletRequest)request, (String)"Operation");
            if ("Select Dump".equals(buttonName)) {
                return 1;
            }
            return 2;
        }
        catch (ServletRequestBindingException servletRequestBindingException) {
            return 1;
        }
    }
}

