/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.deployer.model.internal;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.deployer.core.DeployUriNormaliser;
import org.eclipse.virgo.kernel.deployer.core.DeploymentException;
import org.eclipse.virgo.kernel.deployer.core.DeploymentIdentity;
import org.eclipse.virgo.kernel.deployer.core.internal.StandardDeploymentIdentity;
import org.eclipse.virgo.kernel.deployer.model.DuplicateDeploymentIdentityException;
import org.eclipse.virgo.kernel.deployer.model.DuplicateFileNameException;
import org.eclipse.virgo.kernel.deployer.model.DuplicateLocationException;
import org.eclipse.virgo.kernel.deployer.model.RuntimeArtifactModel;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.serviceability.Assert;
import org.eclipse.virgo.kernel.serviceability.NonNull;
import org.eclipse.virgo.kernel.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.kernel.serviceability.enforcement.NonNullAssertionEnforcer;
import org.eclipse.virgo.medic.log.EntryExitTrace;

final class StandardRuntimeArtifactModel
implements RuntimeArtifactModel {
    private static final String CLASH_MESSAGE_FORMAT = "The artifact %s at URI '%s' cannot be stored in the runtime artifact model as it clashes with the artifact %s which is already present.";
    private static final String URI_PATH_SEPARATOR = "/";
    private final Object monitor;
    private final Map<URI, InstallArtifact> artifactByUri;
    private final Map<DeploymentIdentity, URI> uriByIdentity;
    private final Map<String, URI> uriByFileName;
    private final DeployUriNormaliser uriNormaliser;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    StandardRuntimeArtifactModel(DeployUriNormaliser uriNormaliser) {
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.monitor = new Object();
            this.artifactByUri = new HashMap<URI, InstallArtifact>();
            this.uriByIdentity = new HashMap<DeploymentIdentity, URI>();
            this.uriByFileName = new HashMap<String, URI>();
            this.uriNormaliser = uriNormaliser;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public DeploymentIdentity add(@NonNull URI uRI, @NonNull InstallArtifact installArtifact) throws DuplicateFileNameException, DuplicateLocationException, DuplicateDeploymentIdentityException, DeploymentException {
        InstallArtifact installArtifact2 = installArtifact;
        URI uRI2 = uRI;
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$1$7118cd8((Object)uRI2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$2$ea5bfc82((Object)installArtifact2);
        try {
            try {
                DeploymentIdentity deploymentIdentity;
                StandardRuntimeArtifactModel.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                Object object = this.monitor;
                synchronized (object) {
                    void installArtifact3;
                    void location;
                    this.checkLocation((URI)location, (InstallArtifact)installArtifact3);
                    String fileName = this.getFileName((URI)location);
                    this.checkFileName((URI)location, (InstallArtifact)installArtifact3, fileName);
                    DeploymentIdentity deploymentIdentity2 = this.getDeploymentIdentity((InstallArtifact)installArtifact3);
                    this.checkDeploymentIdentity((URI)location, (InstallArtifact)installArtifact3, deploymentIdentity2);
                    this.updateState((URI)location, (InstallArtifact)installArtifact3, fileName, deploymentIdentity2);
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3] lbl17 : MonitorExitStatement: MONITOREXIT : var3_5
                    deploymentIdentity = deploymentIdentity2;
                }
                StandardRuntimeArtifactModel.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                return deploymentIdentity;
            }
            catch (Throwable throwable) {
                StandardRuntimeArtifactModel.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void checkLocation(URI location, InstallArtifact installArtifact) throws DuplicateLocationException {
        try {
            try {
                StandardRuntimeArtifactModel.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
                if (this.artifactByUri.containsKey(location)) {
                    InstallArtifact clashingArtifact = this.artifactByUri.get(location);
                    throw new DuplicateLocationException(this.getClashMessage(location, installArtifact, clashingArtifact));
                }
                StandardRuntimeArtifactModel.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
                return;
            }
            catch (Throwable throwable) {
                StandardRuntimeArtifactModel.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void checkFileName(URI location, InstallArtifact installArtifact, String fileName) throws DuplicateFileNameException {
        try {
            try {
                StandardRuntimeArtifactModel.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
                if (this.uriByFileName.containsKey(fileName)) {
                    InstallArtifact clashingArtifact = this.artifactByUri.get(this.uriByFileName.get(fileName));
                    throw new DuplicateFileNameException(this.getClashMessage(location, installArtifact, clashingArtifact));
                }
                StandardRuntimeArtifactModel.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
                return;
            }
            catch (Throwable throwable) {
                StandardRuntimeArtifactModel.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void checkDeploymentIdentity(URI location, InstallArtifact installArtifact, DeploymentIdentity deploymentIdentity) throws DuplicateDeploymentIdentityException {
        try {
            try {
                StandardRuntimeArtifactModel.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
                if (this.uriByIdentity.containsKey(deploymentIdentity)) {
                    InstallArtifact clashingArtifact = this.artifactByUri.get(this.uriByIdentity.get(deploymentIdentity));
                    throw new DuplicateDeploymentIdentityException(this.getClashMessage(location, installArtifact, clashingArtifact));
                }
                StandardRuntimeArtifactModel.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
                return;
            }
            catch (Throwable throwable) {
                StandardRuntimeArtifactModel.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private String getClashMessage(URI location, InstallArtifact installArtifact, InstallArtifact clashingArtifact) {
        try {
            return String.format(CLASH_MESSAGE_FORMAT, installArtifact, location, clashingArtifact);
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - void declaration
     */
    DeploymentIdentity getDeploymentIdentity(@NonNull InstallArtifact installArtifact) {
        InstallArtifact installArtifact2 = installArtifact;
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$1$7118cd8((Object)installArtifact2);
        try {
            void installArtifact3;
            return new StandardDeploymentIdentity(installArtifact3.getType(), installArtifact3.getName(), installArtifact3.getVersion().toString());
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - void declaration
     */
    String getFileName(@NonNull URI uRI) throws DeploymentException {
        URI uRI2 = uRI;
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$1$7118cd8((Object)uRI2);
        try {
            int separatorIndex;
            void location;
            URI normalisedLocation = this.uriNormaliser.normalise((URI)location);
            String path = normalisedLocation.getPath();
            if (path.endsWith(URI_PATH_SEPARATOR)) {
                path = path.substring(0, path.length() - 1);
            }
            return (separatorIndex = path.lastIndexOf(URI_PATH_SEPARATOR)) != -1 ? path.substring(separatorIndex + 1) : path;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public InstallArtifact get(@NonNull DeploymentIdentity deploymentIdentity) {
        DeploymentIdentity deploymentIdentity2 = deploymentIdentity;
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$1$7118cd8((Object)deploymentIdentity2);
        try {
            Object object = this.monitor;
            synchronized (object) {
                void deploymentIdentity3;
                URI location = this.uriByIdentity.get(deploymentIdentity3);
                return location == null ? null : this.artifactByUri.get(location);
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public InstallArtifact get(@NonNull URI uRI) {
        URI uRI2 = uRI;
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$1$7118cd8((Object)uRI2);
        try {
            Object object = this.monitor;
            synchronized (object) {
                void location;
                return this.artifactByUri.get(location);
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URI getLocation(DeploymentIdentity deploymentIdentity) {
        try {
            Object object = this.monitor;
            synchronized (object) {
                return this.uriByIdentity.get(deploymentIdentity);
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeploymentIdentity[] getDeploymentIdentities() {
        try {
            Object object = this.monitor;
            synchronized (object) {
                Set<DeploymentIdentity> deploymentIdentities = this.uriByIdentity.keySet();
                return deploymentIdentities.toArray(new DeploymentIdentity[deploymentIdentities.size()]);
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InstallArtifact delete(DeploymentIdentity deploymentIdentity) throws DeploymentException {
        try {
            try {
                InstallArtifact installArtifact;
                StandardRuntimeArtifactModel.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_4);
                Object object = this.monitor;
                synchronized (object) {
                    URI location;
                    block8: {
                        location = this.uriByIdentity.get(deploymentIdentity);
                        if (location != null) break block8;
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 4] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
                        installArtifact = null;
                    }
                    InstallArtifact installArtifact2 = this.artifactByUri.get(location);
                    Assert.notNull((Object)installArtifact2, (String)"Broken invariant: artifactByUri is missing an entry for URI '%s' but this URI is present in uriByIdentity for '%s'", (Object[])new Object[]{location, deploymentIdentity});
                    String fileName = this.getFileName(location);
                    Assert.isTrue((boolean)this.uriByFileName.containsKey(fileName), (String)"Broken invariant: uriByFileName is missing an entry for file name '%s' but URI '%s' is present in uriByIdentity for '%s'", (Object[])new Object[]{fileName, location, deploymentIdentity});
                    this.removeState(deploymentIdentity, location, fileName);
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 3, 4] lbl18 : MonitorExitStatement: MONITOREXIT : var2_2
                    installArtifact = installArtifact2;
                }
                StandardRuntimeArtifactModel.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_4);
                return installArtifact;
            }
            catch (Throwable throwable) {
                StandardRuntimeArtifactModel.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_4);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void updateState(URI location, InstallArtifact installArtifact, String fileName, DeploymentIdentity deploymentIdentity) {
        try {
            try {
                StandardRuntimeArtifactModel.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_5);
                this.artifactByUri.put(location, installArtifact);
                this.uriByIdentity.put(deploymentIdentity, location);
                this.uriByFileName.put(fileName, location);
                StandardRuntimeArtifactModel.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_5);
                return;
            }
            catch (Throwable throwable) {
                StandardRuntimeArtifactModel.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_5);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void removeState(DeploymentIdentity deploymentIdentity, URI location, String fileName) {
        try {
            try {
                StandardRuntimeArtifactModel.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_6);
                this.artifactByUri.remove(location);
                this.uriByIdentity.remove(deploymentIdentity);
                this.uriByFileName.remove(fileName);
                StandardRuntimeArtifactModel.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_6);
                return;
            }
            catch (Throwable throwable) {
                StandardRuntimeArtifactModel.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_6);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static {
        Factory factory = new Factory("StandardRuntimeArtifactModel.java", Class.forName("org.eclipse.virgo.kernel.deployer.model.internal.StandardRuntimeArtifactModel"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "add", "org.eclipse.virgo.kernel.deployer.model.internal.StandardRuntimeArtifactModel", "java.net.URI:org.eclipse.virgo.kernel.install.artifact.InstallArtifact:", "location:installArtifact:", "org.eclipse.virgo.kernel.deployer.model.DuplicateFileNameException:org.eclipse.virgo.kernel.deployer.model.DuplicateLocationException:org.eclipse.virgo.kernel.deployer.model.DuplicateDeploymentIdentityException:org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "org.eclipse.virgo.kernel.deployer.core.DeploymentIdentity"), 66);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkLocation", "org.eclipse.virgo.kernel.deployer.model.internal.StandardRuntimeArtifactModel", "java.net.URI:org.eclipse.virgo.kernel.install.artifact.InstallArtifact:", "location:installArtifact:", "org.eclipse.virgo.kernel.deployer.model.DuplicateLocationException:", "void"), 85);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkFileName", "org.eclipse.virgo.kernel.deployer.model.internal.StandardRuntimeArtifactModel", "java.net.URI:org.eclipse.virgo.kernel.install.artifact.InstallArtifact:java.lang.String:", "location:installArtifact:fileName:", "org.eclipse.virgo.kernel.deployer.model.DuplicateFileNameException:", "void"), 92);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkDeploymentIdentity", "org.eclipse.virgo.kernel.deployer.model.internal.StandardRuntimeArtifactModel", "java.net.URI:org.eclipse.virgo.kernel.install.artifact.InstallArtifact:org.eclipse.virgo.kernel.deployer.core.DeploymentIdentity:", "location:installArtifact:deploymentIdentity:", "org.eclipse.virgo.kernel.deployer.model.DuplicateDeploymentIdentityException:", "void"), 100);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "delete", "org.eclipse.virgo.kernel.deployer.model.internal.StandardRuntimeArtifactModel", "org.eclipse.virgo.kernel.deployer.core.DeploymentIdentity:", "deploymentIdentity:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "org.eclipse.virgo.kernel.install.artifact.InstallArtifact"), 166);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "updateState", "org.eclipse.virgo.kernel.deployer.model.internal.StandardRuntimeArtifactModel", "java.net.URI:org.eclipse.virgo.kernel.install.artifact.InstallArtifact:java.lang.String:org.eclipse.virgo.kernel.deployer.core.DeploymentIdentity:", "location:installArtifact:fileName:deploymentIdentity:", "", "void"), 188);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "removeState", "org.eclipse.virgo.kernel.deployer.model.internal.StandardRuntimeArtifactModel", "org.eclipse.virgo.kernel.deployer.core.DeploymentIdentity:java.net.URI:java.lang.String:", "deploymentIdentity:location:fileName:", "", "void"), 194);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.deployer.model.internal.StandardRuntimeArtifactModel");
    }
}

