/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.apps.admin.core.dump;

import java.io.File;
import java.io.IOException;
import java.util.Dictionary;
import org.eclipse.virgo.apps.admin.core.dump.DumpPathLocator;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

final class StandardDumpPathLocator
implements DumpPathLocator {
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String CONFIG_POINT = "org.eclipse.virgo.medic";
    private static final String CONFIG_PROPERTY = "dump.root.directory";
    private final ConfigurationAdmin configurationAdmin;

    public StandardDumpPathLocator(ConfigurationAdmin configurationAdmin) {
        if (configurationAdmin == null) {
            throw new IllegalArgumentException("Configuration Admin must not be null.");
        }
        this.configurationAdmin = configurationAdmin;
    }

    @Override
    public File getDumpDirectory() {
        File dumpDir;
        String path = this.getDumpConfigValue();
        if (path != null && (dumpDir = new File(path)).exists() && dumpDir.isDirectory()) {
            return dumpDir;
        }
        return null;
    }

    @Override
    public File getDumpFolder(String folderName) {
        String path = String.format("%s%s%s", this.getDumpConfigValue(), FILE_SEPARATOR, folderName);
        File dumpDir = new File(path);
        if (dumpDir.exists() && dumpDir.isDirectory()) {
            return dumpDir;
        }
        return null;
    }

    @Override
    public File getDumpEntryFile(String folderName, String fileName) {
        String path = String.format("%s%s%s%s%s", this.getDumpConfigValue(), FILE_SEPARATOR, folderName, FILE_SEPARATOR, fileName);
        File dumpEntry = new File(path);
        if (dumpEntry.exists() && dumpEntry.isFile()) {
            return dumpEntry;
        }
        return null;
    }

    private String getDumpConfigValue() {
        String result = null;
        try {
            Configuration configurations = this.configurationAdmin.getConfiguration(CONFIG_POINT);
            Dictionary properties = configurations.getProperties();
            if (properties != null) {
                return (String)properties.get(CONFIG_PROPERTY);
            }
        }
        catch (IOException iOException) {}
        return result;
    }
}

