/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.apps.admin.core.state;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.virgo.apps.admin.core.BundleHolder;
import org.eclipse.virgo.apps.admin.core.ServiceHolder;
import org.eclipse.virgo.apps.admin.core.state.ObjectFormatter;
import org.eclipse.virgo.apps.admin.core.state.StandardBundleHolder;
import org.eclipse.virgo.kernel.module.ModuleContextAccessor;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiBundle;
import org.eclipse.virgo.kernel.shell.state.QuasiLiveBundle;
import org.eclipse.virgo.kernel.shell.state.QuasiLiveService;
import org.springframework.util.StringUtils;

final class StandardServiceHolder
implements ServiceHolder {
    private static final String MULTIPLE_OBJECT_CLASSES_SUFFIX = ", ...";
    private final QuasiLiveService quasiLiveService;
    private final ModuleContextAccessor moduleContextAccessor;

    public StandardServiceHolder(QuasiLiveService quasiLiveService, ModuleContextAccessor moduleContextAccessor) {
        if (quasiLiveService == null || moduleContextAccessor == null) {
            throw new IllegalArgumentException("QuasiLiveService and ModuleContextAccessor must not be null");
        }
        this.quasiLiveService = quasiLiveService;
        this.moduleContextAccessor = moduleContextAccessor;
    }

    @Override
    public long getServiceId() {
        return this.quasiLiveService.getServiceId();
    }

    @Override
    public String getFormattedObjectClass() {
        return this.formatObjectClass(this.quasiLiveService.getProperties().get("objectClass"));
    }

    @Override
    public List<BundleHolder> getConsumers() {
        List consumers = this.quasiLiveService.getConsumers();
        ArrayList<BundleHolder> bundleHolders = new ArrayList<BundleHolder>();
        for (QuasiLiveBundle quasiLiveBundle : consumers) {
            bundleHolders.add(new StandardBundleHolder((QuasiBundle)quasiLiveBundle, this.moduleContextAccessor));
        }
        return bundleHolders;
    }

    @Override
    public Map<String, String> getProperties() {
        return ObjectFormatter.formatMapValues(this.quasiLiveService.getProperties());
    }

    @Override
    public BundleHolder getProvider() {
        return new StandardBundleHolder((QuasiBundle)this.quasiLiveService.getProvider(), this.moduleContextAccessor);
    }

    @Override
    public int compareTo(ServiceHolder o) {
        return Long.valueOf(this.getServiceId()).compareTo(o.getServiceId());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.quasiLiveService.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StandardServiceHolder other = (StandardServiceHolder)obj;
        return this.quasiLiveService.equals(other.quasiLiveService);
    }

    private String formatObjectClass(Object objectClass) {
        String[] objectClasses;
        StringBuilder sb = new StringBuilder();
        if (objectClass == null) {
            objectClass = new String[]{};
        }
        if ((objectClasses = objectClass instanceof String ? StringUtils.commaDelimitedListToStringArray((String)((String)objectClass)) : (objectClass instanceof Object[] ? objectClass : StringUtils.commaDelimitedListToStringArray((String)objectClass.toString()))).length == 0) {
            sb.append("<none>");
        } else {
            String formattedObjectClass = objectClasses[0];
            sb.append(formattedObjectClass);
            if (objectClasses.length > 1) {
                sb.append(MULTIPLE_OBJECT_CLASSES_SUFFIX);
            }
        }
        return sb.toString();
    }
}

