/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.apps.admin.core.state;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.virgo.apps.admin.core.BundleHolder;
import org.eclipse.virgo.apps.admin.core.DumpExtractor;
import org.eclipse.virgo.apps.admin.core.ExportedPackageHolder;
import org.eclipse.virgo.apps.admin.core.FailedResolutionHolder;
import org.eclipse.virgo.apps.admin.core.ImportedPackageHolder;
import org.eclipse.virgo.apps.admin.core.PackagesCollection;
import org.eclipse.virgo.apps.admin.core.ServiceHolder;
import org.eclipse.virgo.apps.admin.core.StateHolder;
import org.eclipse.virgo.apps.admin.core.state.StandardBundleHolder;
import org.eclipse.virgo.apps.admin.core.state.StandardExportedPackageHolder;
import org.eclipse.virgo.apps.admin.core.state.StandardFailedResolutionHolder;
import org.eclipse.virgo.apps.admin.core.state.StandardImportedPackageHolder;
import org.eclipse.virgo.apps.admin.core.state.StandardPackagesCollection;
import org.eclipse.virgo.apps.admin.core.state.StandardServiceHolder;
import org.eclipse.virgo.kernel.module.ModuleContextAccessor;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiBundle;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiExportPackage;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiFramework;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiFrameworkFactory;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiImportPackage;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiResolutionFailure;
import org.eclipse.virgo.kernel.shell.state.QuasiLiveService;
import org.eclipse.virgo.kernel.shell.state.StateService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class StandardStateHolder
implements StateHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardStateHolder.class);
    private static final String LIVE = "Live";
    private final StateService stateService;
    private final DumpExtractor stateDumpExtractor;
    private final ModuleContextAccessor moduleContextAccessor;
    private final QuasiFrameworkFactory quasiFrameworkFactory;

    public StandardStateHolder(StateService stateService, DumpExtractor dumpStateExtractor, ModuleContextAccessor moduleContextAccessor, QuasiFrameworkFactory quasiFrameworkFactory) {
        this.stateService = stateService;
        this.stateDumpExtractor = dumpStateExtractor;
        this.moduleContextAccessor = moduleContextAccessor;
        this.quasiFrameworkFactory = quasiFrameworkFactory;
    }

    @Override
    public List<BundleHolder> getAllBundles(String source) {
        File dumpDirectory = null;
        if (source != null && !LIVE.equals(source)) {
            dumpDirectory = this.getDumpDirectory(source);
        }
        List allBundles = this.stateService.getAllBundles(dumpDirectory);
        ArrayList<BundleHolder> heldBundles = new ArrayList<BundleHolder>();
        for (QuasiBundle quasiBundle : allBundles) {
            if (quasiBundle == null) continue;
            heldBundles.add(new StandardBundleHolder(quasiBundle, this.moduleContextAccessor));
        }
        return heldBundles;
    }

    @Override
    public List<ServiceHolder> getAllServices(String source) {
        File dumpDirectory = null;
        ArrayList<ServiceHolder> serviceHolders = new ArrayList<ServiceHolder>();
        if (source != null && !LIVE.equals(source)) {
            dumpDirectory = this.getDumpDirectory(source);
        }
        List allServices = this.stateService.getAllServices(dumpDirectory);
        for (QuasiLiveService quasiLiveService : allServices) {
            serviceHolders.add(new StandardServiceHolder(quasiLiveService, this.moduleContextAccessor));
        }
        return serviceHolders;
    }

    @Override
    public BundleHolder getBundle(String source, long bundleId) {
        QuasiBundle bundle;
        File dumpDirectory = null;
        if (source != null && !LIVE.equals(source)) {
            dumpDirectory = this.getDumpDirectory(source);
        }
        if ((bundle = this.stateService.getBundle(dumpDirectory, bundleId)) != null) {
            return new StandardBundleHolder(bundle, this.moduleContextAccessor);
        }
        return null;
    }

    @Override
    public BundleHolder getBundle(String source, String name, String version) {
        File dumpDirectory = null;
        if (source != null && !LIVE.equals(source)) {
            dumpDirectory = this.getDumpDirectory(source);
        }
        QuasiBundle result = null;
        if (name != null && version != null) {
            List allBundles = this.stateService.getAllBundles(dumpDirectory);
            for (QuasiBundle quasiBundle : allBundles) {
                if (!quasiBundle.getSymbolicName().equals(name) || !quasiBundle.getVersion().toString().equals(version)) continue;
                result = quasiBundle;
            }
        }
        if (result != null) {
            return new StandardBundleHolder(result, this.moduleContextAccessor);
        }
        return null;
    }

    @Override
    public ServiceHolder getService(String source, long serviceId) {
        QuasiLiveService service;
        File dumpDirectory = null;
        if (source != null && !LIVE.equals(source)) {
            dumpDirectory = this.getDumpDirectory(source);
        }
        if ((service = this.stateService.getService(dumpDirectory, serviceId)) != null) {
            return new StandardServiceHolder(service, this.moduleContextAccessor);
        }
        return null;
    }

    @Override
    public PackagesCollection getPackages(String source, String packageName) {
        QuasiFramework quasiFramework = this.getQuasiFramework(source);
        List bundles = quasiFramework.getBundles();
        ArrayList<ImportedPackageHolder> importedPackageHolders = new ArrayList<ImportedPackageHolder>();
        ArrayList<ExportedPackageHolder> exportedPackageHolders = new ArrayList<ExportedPackageHolder>();
        for (QuasiBundle qBundle : bundles) {
            ExportedPackageHolder exportPackage;
            ImportedPackageHolder importPackage = this.processImporters(qBundle, packageName);
            if (importPackage != null) {
                importedPackageHolders.add(importPackage);
            }
            if ((exportPackage = this.processExporters(qBundle, packageName)) == null) continue;
            exportedPackageHolders.add(exportPackage);
        }
        return new StandardPackagesCollection(packageName, importedPackageHolders, exportedPackageHolders);
    }

    @Override
    public List<FailedResolutionHolder> getResolverReport(String source, long bundleId) {
        File dumpDirectory = null;
        if (source != null && !LIVE.equals(source)) {
            dumpDirectory = this.getDumpDirectory(source);
        }
        List resolverReport = this.stateService.getResolverReport(dumpDirectory, bundleId);
        ArrayList<FailedResolutionHolder> failedResolutionHolders = new ArrayList<FailedResolutionHolder>();
        if (resolverReport != null) {
            for (QuasiResolutionFailure quasiResolutionFailure : resolverReport) {
                failedResolutionHolders.add(new StandardFailedResolutionHolder(quasiResolutionFailure, this.moduleContextAccessor));
            }
        }
        return failedResolutionHolders;
    }

    @Override
    public List<BundleHolder> search(String source, String term) {
        File dumpDirectory = null;
        if (source != null && !LIVE.equals(source)) {
            dumpDirectory = this.getDumpDirectory(source);
        }
        List matchingBundles = this.stateService.search(dumpDirectory, term);
        ArrayList<BundleHolder> heldMatchingBundles = new ArrayList<BundleHolder>();
        for (QuasiBundle quasiBundle : matchingBundles) {
            if (quasiBundle == null) continue;
            heldMatchingBundles.add(new StandardBundleHolder(quasiBundle, this.moduleContextAccessor));
        }
        return heldMatchingBundles;
    }

    private File getDumpDirectory(String source) {
        File dumpDirectory = null;
        try {
            dumpDirectory = this.stateDumpExtractor.getStateDump(source);
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Unable to obtain the dump directory '%s'", source), (Throwable)e);
        }
        return dumpDirectory;
    }

    private QuasiFramework getQuasiFramework(String source) {
        File dumpDirectory = null;
        try {
            dumpDirectory = this.stateDumpExtractor.getStateDump(source);
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Unable to obtain the dump directory '%s'", source), (Throwable)e);
        }
        if (dumpDirectory != null) {
            return this.quasiFrameworkFactory.create(dumpDirectory);
        }
        return this.quasiFrameworkFactory.create();
    }

    private ImportedPackageHolder processImporters(QuasiBundle qBundle, String packageName) {
        for (QuasiImportPackage qImportPackage : qBundle.getImportPackages()) {
            if (!qImportPackage.getPackageName().equals(packageName)) continue;
            return new StandardImportedPackageHolder(qImportPackage, this.moduleContextAccessor);
        }
        return null;
    }

    private ExportedPackageHolder processExporters(QuasiBundle qBundle, String packageName) {
        for (QuasiExportPackage qExportPackage : qBundle.getExportPackages()) {
            if (!qExportPackage.getPackageName().equals(packageName)) continue;
            return new StandardExportedPackageHolder(qExportPackage, this.moduleContextAccessor);
        }
        return null;
    }
}

