/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.cm;

import java.io.IOException;
import org.eclipse.equinox.internal.cm.ConfigurationAdminFactory;
import org.eclipse.equinox.internal.cm.ConfigurationImpl;
import org.eclipse.equinox.internal.cm.ConfigurationStore;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

class ConfigurationAdminImpl
implements ConfigurationAdmin {
    private final ConfigurationAdminFactory configurationAdminFactory;
    private final Bundle bundle;
    private final ConfigurationStore configurationStore;

    public ConfigurationAdminImpl(ConfigurationAdminFactory configurationAdminFactory, ConfigurationStore configurationStore, Bundle bundle) {
        this.configurationAdminFactory = configurationAdminFactory;
        this.configurationStore = configurationStore;
        this.bundle = bundle;
    }

    public Configuration createFactoryConfiguration(String factoryPid) throws IOException {
        this.checkPID(factoryPid);
        return this.configurationStore.createFactoryConfiguration(factoryPid, this.bundle.getLocation());
    }

    public Configuration createFactoryConfiguration(String factoryPid, String location) throws IOException {
        this.checkPID(factoryPid);
        this.configurationAdminFactory.checkConfigurationPermission();
        return this.configurationStore.createFactoryConfiguration(factoryPid, location);
    }

    public Configuration getConfiguration(String pid) throws IOException {
        this.checkPID(pid);
        ConfigurationImpl config = this.configurationStore.getConfiguration(pid, this.bundle.getLocation());
        if (config.getBundleLocation(false) != null && !config.getBundleLocation(false).equals(this.bundle.getLocation())) {
            this.configurationAdminFactory.checkConfigurationPermission();
        }
        config.bind(this.bundle);
        return config;
    }

    public Configuration getConfiguration(String pid, String location) throws IOException {
        this.checkPID(pid);
        this.configurationAdminFactory.checkConfigurationPermission();
        return this.configurationStore.getConfiguration(pid, location);
    }

    public Configuration[] listConfigurations(String filterString) throws IOException, InvalidSyntaxException {
        if (filterString == null) {
            filterString = "(service.pid=*)";
        }
        try {
            this.configurationAdminFactory.checkConfigurationPermission();
        }
        catch (SecurityException securityException) {
            filterString = "(&(service.bundleLocation=" + this.bundle.getLocation() + ")" + filterString + ")";
        }
        return this.configurationStore.listConfigurations(FrameworkUtil.createFilter((String)filterString));
    }

    private void checkPID(String pid) {
        if (pid == null) {
            throw new IllegalArgumentException("PID cannot be null");
        }
    }
}

