/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.shell.internal.util;

import java.lang.management.ManagementFactory;
import javax.management.InstanceNotFoundException;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.eclipse.virgo.kernel.model.management.ManageableArtifact;
import org.eclipse.virgo.kernel.model.management.RuntimeArtifactModelObjectNameCreator;
import org.eclipse.virgo.kernel.osgi.region.Region;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.osgi.framework.Version;

public final class ArtifactRetriever<T extends ManageableArtifact> {
    private final MBeanServer server = ManagementFactory.getPlatformMBeanServer();
    private final String type;
    private final RuntimeArtifactModelObjectNameCreator objectNameCreator;
    private final Class<T> artifactType;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

    public ArtifactRetriever(String type, RuntimeArtifactModelObjectNameCreator objectNameCreator, Class<T> artifactType) {
        this.type = type;
        this.objectNameCreator = objectNameCreator;
        this.artifactType = artifactType;
    }

    public T getArtifact(String name, Version version) throws InstanceNotFoundException {
        return this.getArtifact(this.objectNameCreator.create(this.type, name, version));
    }

    public T getArtifact(String name, Version version, Region region) throws InstanceNotFoundException {
        return this.getArtifact(this.objectNameCreator.create(this.type, name, version, region));
    }

    public T getArtifact(ObjectName objectName) throws InstanceNotFoundException {
        if (this.server.isRegistered(objectName)) {
            return (T)((ManageableArtifact)JMX.newMXBeanProxy(this.server, objectName, this.artifactType));
        }
        throw new InstanceNotFoundException(String.format("Instance '%s' not found", objectName.getCanonicalName()));
    }

    public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
        return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    }

    static {
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.shell.internal.util.ArtifactRetriever");
    }
}

