/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.shell.model.helper;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.JMX;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.model.management.ManageableArtifact;
import org.eclipse.virgo.kernel.model.management.ManageableCompositeArtifact;
import org.eclipse.virgo.kernel.shell.model.helper.ArtifactAccessor;
import org.eclipse.virgo.kernel.shell.model.helper.ArtifactAccessorPointer;
import org.eclipse.virgo.kernel.shell.model.helper.RamAccessorHelper;
import org.eclipse.virgo.kernel.shell.model.helper.StandardArtifactAccessor;
import org.eclipse.virgo.kernel.shell.model.helper.StandardArtifactAccessorPointer;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StandardRamAccessorHelper
implements RamAccessorHelper {
    private static final Logger LOGGER;
    private static final String TYPE_ATTRIBUTE = "Type";
    private static final String NAME_ATTRIBUTE = "Name";
    private static final String VERSION_ATTRIBUTE = "Version";
    private static final String STATE_ATTRIBUTE = "state";
    private static final String REGION_ATTRIBUTE = "Region";
    private static final String USER_INSTALLED = "user.installed";
    private static final String OPERATION_SUCSESS = "%s operation returned successful";
    private static final String OPERATION_FAIL = "An error occurred during the %s operation";
    private static final String ARTIFACT_MBEAN_QUERY = "org.eclipse.virgo.kernel:type=Model,artifact-type=%s,name=%s,version=%s";
    private static final String REGION_ARTIFACT_MBEAN_QUERY = "org.eclipse.virgo.kernel:type=KernelModel,artifact-type=%s,name=%s,version=%s,region=%s";
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    static {
        Factory factory = new Factory("StandardRamAccessorHelper.java", Class.forName("org.eclipse.virgo.kernel.shell.model.helper.StandardRamAccessorHelper"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "start", "org.eclipse.virgo.kernel.shell.model.helper.StandardRamAccessorHelper", "java.lang.String:java.lang.String:java.lang.String:", "type:name:version:", "", "java.lang.String"), 78);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "stop", "org.eclipse.virgo.kernel.shell.model.helper.StandardRamAccessorHelper", "java.lang.String:java.lang.String:java.lang.String:", "type:name:version:", "", "java.lang.String"), 85);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "uninstall", "org.eclipse.virgo.kernel.shell.model.helper.StandardRamAccessorHelper", "java.lang.String:java.lang.String:java.lang.String:", "type:name:version:", "", "java.lang.String"), 92);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "refresh", "org.eclipse.virgo.kernel.shell.model.helper.StandardRamAccessorHelper", "java.lang.String:java.lang.String:java.lang.String:", "type:name:version:", "", "java.lang.String"), 99);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "performOperation", "org.eclipse.virgo.kernel.shell.model.helper.StandardRamAccessorHelper", "java.lang.String:java.lang.String:java.lang.String:java.lang.String:", "type:name:version:operationName:", "", "java.lang.String"), 103);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "buildArtifactAccessorPointer", "org.eclipse.virgo.kernel.shell.model.helper.StandardRamAccessorHelper", "javax.management.ObjectName:", "objectName:", "", "org.eclipse.virgo.kernel.shell.model.helper.ArtifactAccessorPointer"), 279);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.shell.model.helper.StandardRamAccessorHelper");
        LOGGER = LoggerFactory.getLogger(StandardRamAccessorHelper.class);
    }

    @Override
    public String start(String type, String name, String version) {
        try {
            StandardRamAccessorHelper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
            String string = this.performOperation(type, name, version, "start");
            StandardRamAccessorHelper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return string;
        }
        catch (Throwable throwable) {
            StandardRamAccessorHelper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    @Override
    public String stop(String type, String name, String version) {
        try {
            StandardRamAccessorHelper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
            String string = this.performOperation(type, name, version, "stop");
            StandardRamAccessorHelper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
            return string;
        }
        catch (Throwable throwable) {
            StandardRamAccessorHelper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    @Override
    public String uninstall(String type, String name, String version) {
        try {
            StandardRamAccessorHelper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_2);
            String string = this.performOperation(type, name, version, "uninstall");
            StandardRamAccessorHelper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_2);
            return string;
        }
        catch (Throwable throwable) {
            StandardRamAccessorHelper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    @Override
    public String refresh(String type, String name, String version) {
        try {
            StandardRamAccessorHelper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_3);
            String string = this.performOperation(type, name, version, "refresh");
            StandardRamAccessorHelper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_3);
            return string;
        }
        catch (Throwable throwable) {
            StandardRamAccessorHelper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    private String performOperation(String type, String name, String version, String operationName) {
        try {
            String string;
            StandardRamAccessorHelper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            try {
                ObjectName objectName = new ObjectName(String.format(ARTIFACT_MBEAN_QUERY, type, name, version));
                mBeanServer.invoke(objectName, operationName, new Object[0], new String[0]);
                string = String.format(OPERATION_SUCSESS, operationName);
            }
            catch (Exception exception) {
                LOGGER.warn(String.format("Unexpected error while trying to read the Runtime Artifact Model MBeans. type: '%s' name: '%s' version: '%s'", type, name, version));
                string = String.format(OPERATION_FAIL, operationName);
            }
            StandardRamAccessorHelper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
            return string;
        }
        catch (Throwable throwable) {
            StandardRamAccessorHelper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
            throw throwable;
        }
    }

    @Override
    public List<String> getTypes() {
        ArrayList<String> types = new ArrayList<String>();
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            Set<ObjectName> objectNames = mBeanServer.queryNames(new ObjectName("org.eclipse.virgo.kernel:type=Model,*"), null);
            for (ObjectName objectName : objectNames) {
                ManageableArtifact artifact;
                String type = objectName.getKeyProperty("artifact-type");
                if (type == null || types.contains(type) || !Boolean.valueOf((String)(artifact = JMX.newMXBeanProxy(mBeanServer, objectName, ManageableArtifact.class)).getProperties().get(USER_INSTALLED)).booleanValue()) continue;
                types.add(type);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Unexpected error while trying to read the Runtime Artifact Model MBeans", (Throwable)e);
        }
        return types;
    }

    @Override
    public List<ArtifactAccessorPointer> getArtifactsOfType(String type) {
        return this.getArtifactsOfType(type, true);
    }

    @Override
    public List<ArtifactAccessorPointer> getAllArtifactsOfType(String type) {
        return this.getArtifactsOfType(type, false);
    }

    private List<ArtifactAccessorPointer> getArtifactsOfType(String type, boolean onlyUserInstalled) {
        ArrayList<ArtifactAccessorPointer> artifacts = new ArrayList<ArtifactAccessorPointer>();
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            Set<ObjectName> objectNames = mBeanServer.queryNames(new ObjectName(String.format("org.eclipse.virgo.kernel:type=Model,artifact-type=%s,*", type)), null);
            for (ObjectName objectName : objectNames) {
                ArtifactAccessorPointer pointer = this.buildArtifactAccessorPointer(objectName);
                if (pointer == null) continue;
                ManageableArtifact artifact = JMX.newMXBeanProxy(mBeanServer, objectName, ManageableArtifact.class);
                if (onlyUserInstalled && !Boolean.valueOf((String)artifact.getProperties().get(USER_INSTALLED)).booleanValue()) continue;
                artifacts.add(pointer);
            }
        }
        catch (MalformedObjectNameException e) {
            LOGGER.warn("Unexpected error while trying to read the Runtime Artifact Model MBeans", (Throwable)e);
        }
        return artifacts;
    }

    @Override
    public ArtifactAccessor getArtifact(String type, String name, String version) {
        String kernelRegion = "org.eclipse.virgo.region.kernel";
        ArtifactAccessorPointer pointer = null;
        ObjectName objectName = null;
        try {
            objectName = new ObjectName(String.format(ARTIFACT_MBEAN_QUERY, type, name, version));
            pointer = this.buildArtifactAccessorPointer(objectName);
            if (pointer == null) {
                objectName = new ObjectName(String.format(REGION_ARTIFACT_MBEAN_QUERY, type, name, version, kernelRegion));
                pointer = this.buildArtifactAccessorPointer(objectName);
            }
        }
        catch (MalformedObjectNameException e) {
            LOGGER.warn("Unexpected error while trying to read the Runtime Artifact Model MBeans", (Throwable)e);
        }
        catch (NullPointerException e) {
            LOGGER.warn("Unexpected error while trying to read the Runtime Artifact Model MBeans", (Throwable)e);
        }
        return this.getArtifact(pointer, objectName);
    }

    @Override
    public ArtifactAccessor getArtifact(String type, String name, String version, String region) {
        String kernelRegion = "org.eclipse.virgo.region.kernel";
        ArtifactAccessorPointer pointer = null;
        ObjectName objectName = null;
        try {
            objectName = kernelRegion.equals(region) ? new ObjectName(String.format(REGION_ARTIFACT_MBEAN_QUERY, type, name, version, region)) : new ObjectName(String.format(ARTIFACT_MBEAN_QUERY, type, name, version));
            pointer = this.buildArtifactAccessorPointer(objectName);
        }
        catch (MalformedObjectNameException e) {
            LOGGER.warn("Unexpected error while trying to read the Runtime Artifact Model MBeans", (Throwable)e);
        }
        catch (NullPointerException e) {
            LOGGER.warn("Unexpected error while trying to read the Runtime Artifact Model MBeans", (Throwable)e);
        }
        return this.getArtifact(pointer, objectName);
    }

    private ArtifactAccessor getArtifact(ArtifactAccessorPointer pointer, ObjectName objectName) {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            if (pointer != null) {
                TreeMap<String, Object> attributes = new TreeMap<String, Object>();
                attributes.put(TYPE_ATTRIBUTE, pointer.getType());
                attributes.put(NAME_ATTRIBUTE, pointer.getName());
                attributes.put(VERSION_ATTRIBUTE, pointer.getVersion());
                attributes.put(STATE_ATTRIBUTE, pointer.getState());
                attributes.put(REGION_ATTRIBUTE, pointer.getRegion());
                boolean scoped = false;
                boolean atomic = false;
                MBeanInfo info = mBeanServer.getMBeanInfo(objectName);
                if (info.getDescriptor().getFieldValue("interfaceClassName").equals(ManageableCompositeArtifact.class.getName())) {
                    ManageableCompositeArtifact compositeArtifact = JMX.newMXBeanProxy(mBeanServer, objectName, ManageableCompositeArtifact.class);
                    scoped = compositeArtifact.isScoped();
                    atomic = compositeArtifact.isAtomic();
                }
                attributes.put("atomic", atomic);
                attributes.put("scoped", scoped);
                ManageableArtifact artifact = JMX.newMXBeanProxy(mBeanServer, objectName, ManageableArtifact.class);
                HashSet<ArtifactAccessorPointer> dependents = new HashSet<ArtifactAccessorPointer>();
                ObjectName[] objectNameArray = artifact.getDependents();
                int n = objectNameArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ObjectName dependentObjectName = objectNameArray[n2];
                    ArtifactAccessorPointer dependentPointer = this.buildArtifactAccessorPointer(dependentObjectName);
                    if (dependentPointer != null) {
                        dependents.add(dependentPointer);
                    }
                    ++n2;
                }
                return new StandardArtifactAccessor(attributes, artifact.getProperties(), dependents);
            }
        }
        catch (IntrospectionException e) {
            LOGGER.warn("Unexpected error while trying to read the Runtime Artifact Model MBeans", (Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            LOGGER.warn("Unexpected error while trying to read the Runtime Artifact Model MBeans", (Throwable)e);
        }
        catch (ReflectionException e) {
            LOGGER.warn("Unexpected error while trying to read the Runtime Artifact Model MBeans", (Throwable)e);
        }
        return null;
    }

    private ArtifactAccessorPointer buildArtifactAccessorPointer(ObjectName objectName) {
        try {
            StandardRamAccessorHelper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_5);
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            StandardArtifactAccessorPointer result = null;
            try {
                String dependentRegion;
                String dependantState;
                String dependentType = objectName.getKeyProperty("artifact-type");
                String dependentName = objectName.getKeyProperty("name");
                String dependentVersion = objectName.getKeyProperty("version");
                ManageableArtifact dependantArtifact = JMX.newMXBeanProxy(mBeanServer, objectName, ManageableArtifact.class);
                if (dependantArtifact != null) {
                    dependantState = dependantArtifact.getState();
                    dependentRegion = dependantArtifact.getRegion();
                } else {
                    dependantState = "-";
                    dependentRegion = "";
                }
                if (dependentType != null && dependentName != null && dependentVersion != null) {
                    result = new StandardArtifactAccessorPointer(dependentType, dependentName, dependentVersion, dependentRegion, dependantState);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Unexpected error while trying to read the Runtime Artifact Model MBeans", (Throwable)e);
            }
            StandardArtifactAccessorPointer standardArtifactAccessorPointer = result;
            StandardRamAccessorHelper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_5);
            return standardArtifactAccessorPointer;
        }
        catch (Throwable throwable) {
            StandardRamAccessorHelper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_5);
            throw throwable;
        }
    }
}

