/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.model.internal;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.model.Artifact;
import org.eclipse.virgo.kernel.model.RuntimeArtifactRepository;
import org.eclipse.virgo.kernel.model.internal.ArtifactRepositoryListener;
import org.eclipse.virgo.kernel.osgi.region.Region;
import org.eclipse.virgo.kernel.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NotifyingRuntimeArtifactRepository
implements RuntimeArtifactRepository {
    private final Logger logger;
    private final Object monitor;
    private final Set<Artifact> artifacts;
    private final List<ArtifactRepositoryListener> listeners;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public NotifyingRuntimeArtifactRepository(ArtifactRepositoryListener ... listeners) {
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.logger = LoggerFactory.getLogger(this.getClass());
            this.monitor = new Object();
            this.artifacts = new HashSet<Artifact>();
            this.listeners = Arrays.asList(listeners);
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Artifact artifact) {
        try {
            boolean bl;
            NotifyingRuntimeArtifactRepository.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
            try {
                Object object = this.monitor;
                synchronized (object) {
                    boolean result = this.artifacts.add(artifact);
                    if (result) {
                        for (ArtifactRepositoryListener listener : this.listeners) {
                            try {
                                listener.added(artifact);
                            }
                            catch (Exception e) {
                                this.logger.error(String.format("Exception calling added() on listener '%s'", listener.toString()), (Throwable)e);
                            }
                        }
                    }
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 4] lbl18 : MonitorExitStatement: MONITOREXIT : var2_2
                    bl = result;
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            NotifyingRuntimeArtifactRepository.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return bl;
        }
        catch (Throwable throwable) {
            NotifyingRuntimeArtifactRepository.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(String type, String name, Version version) {
        try {
            boolean bl;
            NotifyingRuntimeArtifactRepository.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
            try {
                Object object = this.monitor;
                synchronized (object) {
                    Artifact artifact = this.getArtifact(type, name, version);
                    boolean result = this.artifacts.remove(artifact);
                    if (result) {
                        for (ArtifactRepositoryListener listener : this.listeners) {
                            try {
                                listener.removed(artifact);
                            }
                            catch (Exception e) {
                                this.logger.error(String.format("Exception calling removed() on listener '%s'", listener.toString()), (Throwable)e);
                            }
                        }
                    }
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 4] lbl19 : MonitorExitStatement: MONITOREXIT : var4_4
                    bl = result;
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            NotifyingRuntimeArtifactRepository.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
            return bl;
        }
        catch (Throwable throwable) {
            NotifyingRuntimeArtifactRepository.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Artifact> getArtifacts() {
        try {
            Object object = this.monitor;
            synchronized (object) {
                return new HashSet<Artifact>(this.artifacts);
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Artifact getArtifact(String type, String name, Version version) {
        try {
            Object object = this.monitor;
            synchronized (object) {
                for (Artifact artifact : this.artifacts) {
                    Region region = artifact.getRegion();
                    if (region != null && region.contains(0L) || !artifact.getType().equals(type) || !artifact.getName().equals(name) || !artifact.getVersion().equals((Object)version)) continue;
                    return artifact;
                }
                return null;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static {
        Factory factory = new Factory("NotifyingRuntimeArtifactRepository.java", Class.forName("org.eclipse.virgo.kernel.model.internal.NotifyingRuntimeArtifactRepository"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "add", "org.eclipse.virgo.kernel.model.internal.NotifyingRuntimeArtifactRepository", "org.eclipse.virgo.kernel.model.Artifact:", "artifact:", "", "boolean"), 55);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "remove", "org.eclipse.virgo.kernel.model.internal.NotifyingRuntimeArtifactRepository", "java.lang.String:java.lang.String:org.osgi.framework.Version:", "type:name:version:", "", "boolean"), 74);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.model.internal.NotifyingRuntimeArtifactRepository");
    }
}

