/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.model.internal.deployer;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.deployer.core.DeploymentException;
import org.eclipse.virgo.kernel.install.artifact.BundleInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifactLifecycleListenerSupport;
import org.eclipse.virgo.kernel.install.artifact.PlanInstallArtifact;
import org.eclipse.virgo.kernel.model.Artifact;
import org.eclipse.virgo.kernel.model.RuntimeArtifactRepository;
import org.eclipse.virgo.kernel.model.internal.deployer.DeployerArtifact;
import org.eclipse.virgo.kernel.model.internal.deployer.DeployerBundleArtifact;
import org.eclipse.virgo.kernel.model.internal.deployer.DeployerCompositeArtifact;
import org.eclipse.virgo.kernel.osgi.region.RegionDigraph;
import org.eclipse.virgo.kernel.serviceability.NonNull;
import org.eclipse.virgo.kernel.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.kernel.serviceability.enforcement.NonNullAssertionEnforcer;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ModelInstallArtifactLifecycleListener
extends InstallArtifactLifecycleListenerSupport {
    private static final String USER_REGION_NAME = "org.eclipse.virgo.region.user";
    private final Logger logger;
    private final RuntimeArtifactRepository artifactRepository;
    private final BundleContext bundleContext;
    private final RegionDigraph regionDigraph;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;

    public ModelInstallArtifactLifecycleListener(@NonNull BundleContext bundleContext, @NonNull RuntimeArtifactRepository artifactRepository, @NonNull RegionDigraph regionDigraph) {
        RegionDigraph regionDigraph2 = regionDigraph;
        RuntimeArtifactRepository runtimeArtifactRepository = artifactRepository;
        BundleContext bundleContext2 = bundleContext;
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$1$7118cd8((Object)bundleContext2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$2$ea5bfc82((Object)runtimeArtifactRepository);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$3$438bd8c1((Object)regionDigraph2);
        try {
            this.logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            this.bundleContext = bundleContext;
            this.artifactRepository = artifactRepository;
            this.regionDigraph = regionDigraph;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void onInstalling(InstallArtifact installArtifact) throws DeploymentException {
        try {
            ModelInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
            try {
                this.logEvent("installing", installArtifact);
                if (installArtifact instanceof PlanInstallArtifact) {
                    this.addPlan((PlanInstallArtifact)installArtifact);
                } else if (installArtifact instanceof BundleInstallArtifact) {
                    this.addOrReplaceBundle((BundleInstallArtifact)installArtifact);
                } else {
                    this.addArtifact(installArtifact);
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ModelInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return;
        }
        catch (Throwable throwable) {
            ModelInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    private void addPlan(PlanInstallArtifact planInstallArtifact) {
        try {
            ModelInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
            try {
                this.artifactRepository.add(new DeployerCompositeArtifact(this.bundleContext, planInstallArtifact));
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ModelInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
            return;
        }
        catch (Throwable throwable) {
            ModelInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    private void addOrReplaceBundle(BundleInstallArtifact bundleInstallArtifact) {
        try {
            ModelInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
            try {
                Artifact existingBundleArtifact = this.artifactRepository.getArtifact(bundleInstallArtifact.getType(), bundleInstallArtifact.getName(), bundleInstallArtifact.getVersion());
                if (!(existingBundleArtifact instanceof DeployerBundleArtifact)) {
                    this.remove((InstallArtifact)bundleInstallArtifact);
                    this.artifactRepository.add(new DeployerBundleArtifact(this.bundleContext, bundleInstallArtifact, this.regionDigraph.getRegion(USER_REGION_NAME)));
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ModelInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
            return;
        }
        catch (Throwable throwable) {
            ModelInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    private void addArtifact(InstallArtifact installArtifact) {
        try {
            ModelInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
            try {
                this.artifactRepository.add(new DeployerArtifact(this.bundleContext, installArtifact));
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ModelInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
            return;
        }
        catch (Throwable throwable) {
            ModelInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    public void onInstallFailed(InstallArtifact installArtifact) throws DeploymentException {
        try {
            ModelInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_4);
            try {
                this.logEvent("install failed", installArtifact);
                this.remove(installArtifact);
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ModelInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_4);
            return;
        }
        catch (Throwable throwable) {
            ModelInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_4);
            throw throwable;
        }
    }

    public void onUninstalled(InstallArtifact installArtifact) throws DeploymentException {
        try {
            ModelInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_5);
            try {
                this.logEvent("uninstalled", installArtifact);
                this.remove(installArtifact);
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ModelInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_5);
            return;
        }
        catch (Throwable throwable) {
            ModelInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_5);
            throw throwable;
        }
    }

    private void logEvent(String event, InstallArtifact installArtifact) {
        try {
            ModelInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_6);
            try {
                this.logger.info("Processing " + event + " event for {} '{}' version '{}'", (Object[])new String[]{installArtifact.getType(), installArtifact.getName(), installArtifact.getVersion().toString()});
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ModelInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_6);
            return;
        }
        catch (Throwable throwable) {
            ModelInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_6);
            throw throwable;
        }
    }

    private void remove(InstallArtifact installArtifact) {
        try {
            ModelInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_7);
            try {
                this.artifactRepository.remove(installArtifact.getType(), installArtifact.getName(), installArtifact.getVersion());
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ModelInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_7);
            return;
        }
        catch (Throwable throwable) {
            ModelInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_7);
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("ModelInstallArtifactLifecycleListener.java", Class.forName("org.eclipse.virgo.kernel.model.internal.deployer.ModelInstallArtifactLifecycleListener"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onInstalling", "org.eclipse.virgo.kernel.model.internal.deployer.ModelInstallArtifactLifecycleListener", "org.eclipse.virgo.kernel.install.artifact.InstallArtifact:", "installArtifact:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 70);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "addPlan", "org.eclipse.virgo.kernel.model.internal.deployer.ModelInstallArtifactLifecycleListener", "org.eclipse.virgo.kernel.install.artifact.PlanInstallArtifact:", "planInstallArtifact:", "", "void"), 81);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "addOrReplaceBundle", "org.eclipse.virgo.kernel.model.internal.deployer.ModelInstallArtifactLifecycleListener", "org.eclipse.virgo.kernel.install.artifact.BundleInstallArtifact:", "bundleInstallArtifact:", "", "void"), 85);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "addArtifact", "org.eclipse.virgo.kernel.model.internal.deployer.ModelInstallArtifactLifecycleListener", "org.eclipse.virgo.kernel.install.artifact.InstallArtifact:", "installArtifact:", "", "void"), 95);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onInstallFailed", "org.eclipse.virgo.kernel.model.internal.deployer.ModelInstallArtifactLifecycleListener", "org.eclipse.virgo.kernel.install.artifact.InstallArtifact:", "installArtifact:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 103);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onUninstalled", "org.eclipse.virgo.kernel.model.internal.deployer.ModelInstallArtifactLifecycleListener", "org.eclipse.virgo.kernel.install.artifact.InstallArtifact:", "installArtifact:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 112);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "logEvent", "org.eclipse.virgo.kernel.model.internal.deployer.ModelInstallArtifactLifecycleListener", "java.lang.String:org.eclipse.virgo.kernel.install.artifact.InstallArtifact:", "event:installArtifact:", "", "void"), 117);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "remove", "org.eclipse.virgo.kernel.model.internal.deployer.ModelInstallArtifactLifecycleListener", "org.eclipse.virgo.kernel.install.artifact.InstallArtifact:", "installArtifact:", "", "void"), 122);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.model.internal.deployer.ModelInstallArtifactLifecycleListener");
    }
}

