/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.model.internal.deployer;

import javax.annotation.PostConstruct;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.deployer.core.DeploymentIdentity;
import org.eclipse.virgo.kernel.deployer.model.RuntimeArtifactModel;
import org.eclipse.virgo.kernel.install.artifact.BundleInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifactLifecycleListener;
import org.eclipse.virgo.kernel.install.artifact.PlanInstallArtifact;
import org.eclipse.virgo.kernel.model.RuntimeArtifactRepository;
import org.eclipse.virgo.kernel.model.internal.deployer.DeployerArtifact;
import org.eclipse.virgo.kernel.model.internal.deployer.DeployerBundleArtifact;
import org.eclipse.virgo.kernel.model.internal.deployer.DeployerCompositeArtifact;
import org.eclipse.virgo.kernel.model.internal.deployer.ModelInstallArtifactLifecycleListener;
import org.eclipse.virgo.kernel.osgi.region.RegionDigraph;
import org.eclipse.virgo.kernel.serviceability.NonNull;
import org.eclipse.virgo.kernel.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.kernel.serviceability.enforcement.NonNullAssertionEnforcer;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.util.osgi.ServiceRegistrationTracker;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ModelInstallArtifactLifecycleListenerInitializer {
    private final Logger logger;
    private final RuntimeArtifactRepository artifactRepository;
    private final BundleContext bundleContext;
    private final RuntimeArtifactModel runtimeArtifactModel;
    private final ServiceRegistrationTracker registrationTracker;
    private final RegionDigraph regionDigraph;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public ModelInstallArtifactLifecycleListenerInitializer(@NonNull RuntimeArtifactRepository artifactRepository, @NonNull BundleContext bundleContext, @NonNull RuntimeArtifactModel runtimeArtifactModel, @NonNull RegionDigraph regionDigraph) {
        RegionDigraph regionDigraph2 = regionDigraph;
        RuntimeArtifactModel runtimeArtifactModel2 = runtimeArtifactModel;
        BundleContext bundleContext2 = bundleContext;
        RuntimeArtifactRepository runtimeArtifactRepository = artifactRepository;
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$1$7118cd8((Object)runtimeArtifactRepository);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$2$ea5bfc82((Object)bundleContext2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$3$438bd8c1((Object)runtimeArtifactModel2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$4$c122b91c((Object)regionDigraph2);
        try {
            this.logger = LoggerFactory.getLogger(this.getClass());
            this.registrationTracker = new ServiceRegistrationTracker();
            this.artifactRepository = artifactRepository;
            this.bundleContext = bundleContext;
            this.runtimeArtifactModel = runtimeArtifactModel;
            this.regionDigraph = regionDigraph;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @PostConstruct
    public void initialize() {
        try {
            ModelInstallArtifactLifecycleListenerInitializer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
            try {
                ModelInstallArtifactLifecycleListener listener = new ModelInstallArtifactLifecycleListener(this.bundleContext, this.artifactRepository, this.regionDigraph);
                this.registrationTracker.track(this.bundleContext.registerService(InstallArtifactLifecycleListener.class.getCanonicalName(), (Object)listener, null));
                DeploymentIdentity[] deploymentIdentityArray = this.runtimeArtifactModel.getDeploymentIdentities();
                int n = deploymentIdentityArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DeploymentIdentity deploymentIdentity = deploymentIdentityArray[n2];
                    InstallArtifact installArtifact = this.runtimeArtifactModel.get(deploymentIdentity);
                    try {
                        if (installArtifact instanceof PlanInstallArtifact) {
                            this.artifactRepository.add(new DeployerCompositeArtifact(this.bundleContext, (PlanInstallArtifact)installArtifact));
                        } else if (installArtifact instanceof BundleInstallArtifact) {
                            this.artifactRepository.remove(installArtifact.getType(), installArtifact.getName(), installArtifact.getVersion());
                            BundleInstallArtifact bundleInstallArtifact = (BundleInstallArtifact)installArtifact;
                            this.artifactRepository.add(new DeployerBundleArtifact(this.bundleContext, bundleInstallArtifact, this.regionDigraph.getRegion(bundleInstallArtifact.getBundle())));
                        } else {
                            this.artifactRepository.remove(installArtifact.getType(), installArtifact.getName(), installArtifact.getVersion());
                            this.artifactRepository.add(new DeployerArtifact(this.bundleContext, installArtifact));
                        }
                    }
                    catch (Exception e) {
                        this.logger.error(String.format("Exception adding deployer artifact '%s:%s' to the repository", installArtifact.getName(), installArtifact.getVersion().toString()), (Throwable)e);
                    }
                    ++n2;
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ModelInstallArtifactLifecycleListenerInitializer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return;
        }
        catch (Throwable throwable) {
            ModelInstallArtifactLifecycleListenerInitializer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    public void destroy() {
        try {
            ModelInstallArtifactLifecycleListenerInitializer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
            try {
                this.registrationTracker.unregisterAll();
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ModelInstallArtifactLifecycleListenerInitializer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
            return;
        }
        catch (Throwable throwable) {
            ModelInstallArtifactLifecycleListenerInitializer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("ModelInstallArtifactLifecycleListenerInitializer.java", Class.forName("org.eclipse.virgo.kernel.model.internal.deployer.ModelInstallArtifactLifecycleListenerInitializer"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "initialize", "org.eclipse.virgo.kernel.model.internal.deployer.ModelInstallArtifactLifecycleListenerInitializer", "", "", "", "void"), 71);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "destroy", "org.eclipse.virgo.kernel.model.internal.deployer.ModelInstallArtifactLifecycleListenerInitializer", "", "", "", "void"), 99);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.model.internal.deployer.ModelInstallArtifactLifecycleListenerInitializer");
    }
}

