/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.policy;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.security.AccessControlException;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jetty.policy.PolicyBlock;
import org.eclipse.jetty.policy.PolicyContext;
import org.eclipse.jetty.policy.loader.DefaultPolicyLoader;
import org.eclipse.jetty.util.Scanner;
import org.eclipse.jetty.util.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyPolicy
extends Policy {
    private static boolean __DEBUG = false;
    private static boolean __RELOAD = false;
    private final Set<String> _policies;
    private final Set<PolicyBlock> _grants = new HashSet<PolicyBlock>();
    private final Map<Object, PermissionCollection> _cache = new HashMap<Object, PermissionCollection>();
    private final PolicyContext _context = new PolicyContext();
    private Boolean _initialized = false;
    private Scanner _scanner;

    public JettyPolicy(Set<String> policies, Map<String, String> properties) {
        try {
            __RELOAD = Boolean.getBoolean("org.eclipse.jetty.policy.RELOAD");
            __DEBUG = Boolean.getBoolean("org.eclipse.jetty.policy.DEBUG");
        }
        catch (AccessControlException ace) {
            __RELOAD = false;
            __DEBUG = false;
        }
        this._policies = this.resolvePolicyFiles(policies);
        this._context.setProperties(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PermissionCollection getPermissions(ProtectionDomain domain) {
        Object object = this._initialized;
        synchronized (object) {
            if (!this._initialized.booleanValue()) {
                this.refresh();
            }
        }
        object = this._cache;
        synchronized (object) {
            if (this._cache.containsKey(domain)) {
                return this.copyOf(this._cache.get(domain));
            }
            Permissions perms = new Permissions();
            for (PolicyBlock policyBlock : this._grants) {
                ProtectionDomain grantPD = policyBlock.toProtectionDomain();
                if (__DEBUG) {
                    this.debug("----START----");
                    this.debug("PDCS: " + policyBlock.getCodeSource());
                    this.debug("CS: " + domain.getCodeSource());
                }
                if (grantPD.getCodeSource() == null || grantPD.getCodeSource().implies(domain.getCodeSource()) && grantPD.getPrincipals() == null || grantPD.getCodeSource().implies(domain.getCodeSource()) && JettyPolicy.validate(grantPD.getPrincipals(), domain.getPrincipals())) {
                    Enumeration<Permission> e = policyBlock.getPermissions().elements();
                    while (e.hasMoreElements()) {
                        Permission perm = e.nextElement();
                        if (__DEBUG) {
                            this.debug("D: " + perm);
                        }
                        ((PermissionCollection)perms).add(perm);
                    }
                }
                if (!__DEBUG) continue;
                this.debug("----STOP----");
            }
            this._cache.put(domain, perms);
            return this.copyOf(perms);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PermissionCollection getPermissions(CodeSource codesource) {
        Object object = this._initialized;
        synchronized (object) {
            if (!this._initialized.booleanValue()) {
                this.refresh();
            }
        }
        object = this._cache;
        synchronized (object) {
            if (this._cache.containsKey(codesource)) {
                return this.copyOf(this._cache.get(codesource));
            }
            Permissions perms = new Permissions();
            for (PolicyBlock policyBlock : this._grants) {
                ProtectionDomain grantPD = policyBlock.toProtectionDomain();
                if (grantPD.getCodeSource() != null && !grantPD.getCodeSource().implies(codesource)) continue;
                if (__DEBUG) {
                    this.debug("----START----");
                    this.debug("PDCS: " + grantPD.getCodeSource());
                    this.debug("CS: " + codesource);
                }
                Enumeration<Permission> e = policyBlock.getPermissions().elements();
                while (e.hasMoreElements()) {
                    Permission perm = e.nextElement();
                    if (__DEBUG) {
                        this.debug("D: " + perm);
                    }
                    ((PermissionCollection)perms).add(perm);
                }
                if (!__DEBUG) continue;
                this.debug("----STOP----");
            }
            this._cache.put(codesource, perms);
            return this.copyOf(perms);
        }
    }

    @Override
    public boolean implies(ProtectionDomain domain, Permission permission) {
        PermissionCollection pc = this.getPermissions(domain);
        return pc == null ? false : pc.implies(permission);
    }

    private static boolean validate(Principal[] permCerts, Principal[] classCerts) {
        if (classCerts == null) {
            return false;
        }
        for (int i = 0; i < permCerts.length; ++i) {
            boolean found = false;
            for (int j = 0; j < classCerts.length; ++j) {
                if (!((Object)permCerts[i]).equals(classCerts[j])) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void refresh() {
        try {
            Iterator<Object> i;
            if (__RELOAD && this._scanner == null) {
                this.initializeReloading();
            }
            if (__DEBUG) {
                Map<Object, PermissionCollection> map = this._cache;
                synchronized (map) {
                    i = this._cache.keySet().iterator();
                    while (i.hasNext()) {
                        this.log(i.next().toString());
                    }
                }
            }
            HashSet<PolicyBlock> clean = new HashSet<PolicyBlock>();
            i = this._policies.iterator();
            while (i.hasNext()) {
                File policyFile = new File((String)i.next());
                clean.addAll(DefaultPolicyLoader.load(new FileInputStream(policyFile), this._context));
            }
            Map<Object, PermissionCollection> map = this._cache;
            synchronized (map) {
                this._grants.clear();
                this._grants.addAll(clean);
                this._cache.clear();
            }
            this._initialized = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initializeReloading() throws Exception {
        this._scanner = new Scanner();
        ArrayList<File> scanDirs = new ArrayList<File>();
        Iterator<String> i = this._policies.iterator();
        while (i.hasNext()) {
            File policyFile = new File(i.next());
            scanDirs.add(policyFile.getParentFile());
        }
        this._scanner.addListener((Scanner.Listener)new Scanner.DiscreteListener(){

            public void fileRemoved(String filename) throws Exception {
            }

            public void fileChanged(String filename) throws Exception {
                if (filename.endsWith("policy")) {
                    JettyPolicy.this.log("JettyPolicy: refreshing policy files");
                    JettyPolicy.this.refresh();
                    JettyPolicy.this.log("JettyPolicy: finished refreshing policies");
                }
            }

            public void fileAdded(String filename) throws Exception {
            }
        });
        this._scanner.setScanDirs(scanDirs);
        this._scanner.start();
        this._scanner.setScanInterval(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintStream out) {
        PrintWriter write = new PrintWriter(out);
        write.println("JettyPolicy: policy settings dump");
        Map<Object, PermissionCollection> map = this._cache;
        synchronized (map) {
            for (Object o : this._cache.keySet()) {
                write.println(o.toString());
            }
        }
        write.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PermissionCollection copyOf(PermissionCollection in) {
        Permissions out = new Permissions();
        PermissionCollection permissionCollection = in;
        synchronized (permissionCollection) {
            Enumeration<Permission> el = in.elements();
            while (el.hasMoreElements()) {
                ((PermissionCollection)out).add(el.nextElement());
            }
        }
        return out;
    }

    public Set<String> getKnownPolicyFiles() {
        return this._policies;
    }

    private Set<String> resolvePolicyFiles(Set<String> policyInputs) {
        HashSet<String> policyFiles = new HashSet<String>();
        try {
            for (String policyInput : policyInputs) {
                File check = new File(policyInput);
                if (check.isDirectory()) {
                    File[] foundFiles;
                    for (File policyFile : foundFiles = check.listFiles(new FileFilter(){

                        public boolean accept(File pathname) {
                            return pathname.getName().toLowerCase().endsWith("policy");
                        }
                    })) {
                        policyFiles.add(policyFile.getCanonicalPath());
                    }
                    continue;
                }
                policyFiles.add(check.getCanonicalPath());
            }
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("JettyPolicy: unable to resolve policy files.", ioe);
        }
        return policyFiles;
    }

    private void debug(String message) {
        try {
            Log.debug((String)message);
        }
        catch (AccessControlException ace) {
            System.out.println("[DEBUG] " + message);
        }
    }

    private void log(String message) {
        this.log(message, null);
    }

    private void log(String message, Throwable t) {
        try {
            Log.info((String)message, (Object)t);
        }
        catch (AccessControlException ace) {
            System.out.println(message);
            t.printStackTrace();
        }
    }
}

