/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.osgi.region;

import java.util.Dictionary;
import java.util.Hashtable;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.osgi.region.Region;
import org.eclipse.virgo.kernel.osgi.region.RegionDigraph;
import org.eclipse.virgo.kernel.osgi.region.hook.RegionBundleEventHook;
import org.eclipse.virgo.kernel.osgi.region.hook.RegionBundleFindHook;
import org.eclipse.virgo.kernel.osgi.region.hook.RegionResolverHookFactory;
import org.eclipse.virgo.kernel.osgi.region.hook.RegionServiceEventHook;
import org.eclipse.virgo.kernel.osgi.region.hook.RegionServiceFindHook;
import org.eclipse.virgo.kernel.osgi.region.internal.StandardRegionDigraph;
import org.eclipse.virgo.kernel.osgi.region.management.internal.StandardManageableRegionDigraph;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.util.osgi.ServiceRegistrationTracker;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.hooks.service.EventHook;
import org.osgi.framework.hooks.service.FindHook;

final class RegionManager {
    private static final String REGION_KERNEL = "org.eclipse.virgo.region.kernel";
    private final ServiceRegistrationTracker tracker = new ServiceRegistrationTracker();
    private final BundleContext bundleContext;
    private final ThreadLocal<Region> threadLocal;
    private final String domain;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;

    public RegionManager(BundleContext bundleContext, String domain) {
        this.bundleContext = bundleContext;
        this.threadLocal = new ThreadLocal();
        this.domain = domain;
    }

    public void start() throws BundleException {
        try {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
            RegionDigraph regionDigraph = this.createRegionDigraph();
            this.registerRegionHooks(regionDigraph);
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return;
        }
        catch (Throwable throwable) {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    private RegionDigraph createRegionDigraph() throws BundleException {
        try {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
            StandardRegionDigraph regionDigraph = new StandardRegionDigraph(this.bundleContext, this.threadLocal);
            this.registerDigraphMbean(regionDigraph);
            this.createKernelRegion(regionDigraph);
            this.registerRegionDigraph(regionDigraph);
            StandardRegionDigraph standardRegionDigraph = regionDigraph;
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
            return standardRegionDigraph;
        }
        catch (Throwable throwable) {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    private void registerDigraphMbean(RegionDigraph regionDigraph) {
        try {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
            StandardManageableRegionDigraph standardManageableRegionDigraph = new StandardManageableRegionDigraph(regionDigraph, this.domain, this.bundleContext);
            standardManageableRegionDigraph.registerMBean();
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
            return;
        }
        catch (Throwable throwable) {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    private Region createKernelRegion(RegionDigraph regionDigraph) throws BundleException {
        try {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
            Region kernelRegion = regionDigraph.createRegion(REGION_KERNEL);
            Bundle[] bundleArray = this.bundleContext.getBundles();
            int n = bundleArray.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle bundle = bundleArray[n2];
                kernelRegion.addBundle(bundle);
                ++n2;
            }
            this.registerRegionService(kernelRegion);
            Region region = kernelRegion;
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
            return region;
        }
        catch (Throwable throwable) {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    private void registerRegionHooks(RegionDigraph regionDigraph) {
        try {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
            this.registerResolverHookFactory(new RegionResolverHookFactory(regionDigraph));
            RegionBundleFindHook bundleFindHook = new RegionBundleFindHook(regionDigraph, this.bundleContext.getBundle().getBundleId());
            this.registerBundleFindHook(bundleFindHook);
            this.registerBundleEventHook(new RegionBundleEventHook(regionDigraph, bundleFindHook, this.threadLocal));
            RegionServiceFindHook serviceFindHook = new RegionServiceFindHook(regionDigraph);
            this.registerServiceFindHook(serviceFindHook);
            this.registerServiceEventHook(new RegionServiceEventHook(serviceFindHook));
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
            return;
        }
        catch (Throwable throwable) {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
            throw throwable;
        }
    }

    private void registerRegionDigraph(RegionDigraph regionDigraph) {
        try {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_5);
            this.tracker.track(this.bundleContext.registerService(RegionDigraph.class, (Object)regionDigraph, null));
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_5);
            return;
        }
        catch (Throwable throwable) {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_5);
            throw throwable;
        }
    }

    private void registerServiceFindHook(FindHook serviceFindHook) {
        try {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_6);
            this.tracker.track(this.bundleContext.registerService(FindHook.class, (Object)serviceFindHook, null));
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_6);
            return;
        }
        catch (Throwable throwable) {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_6);
            throw throwable;
        }
    }

    private void registerServiceEventHook(EventHook serviceEventHook) {
        try {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_7);
            this.tracker.track(this.bundleContext.registerService(EventHook.class, (Object)serviceEventHook, null));
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_7);
            return;
        }
        catch (Throwable throwable) {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_7);
            throw throwable;
        }
    }

    private void registerBundleFindHook(org.osgi.framework.hooks.bundle.FindHook findHook) {
        try {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_8);
            this.tracker.track(this.bundleContext.registerService(org.osgi.framework.hooks.bundle.FindHook.class, (Object)findHook, null));
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_8);
            return;
        }
        catch (Throwable throwable) {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_8);
            throw throwable;
        }
    }

    private void registerBundleEventHook(org.osgi.framework.hooks.bundle.EventHook eventHook) {
        try {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_9);
            this.tracker.track(this.bundleContext.registerService(org.osgi.framework.hooks.bundle.EventHook.class, (Object)eventHook, null));
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_9);
            return;
        }
        catch (Throwable throwable) {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_9);
            throw throwable;
        }
    }

    private void registerResolverHookFactory(ResolverHookFactory resolverHookFactory) {
        try {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_10);
            this.tracker.track(this.bundleContext.registerService(ResolverHookFactory.class, (Object)resolverHookFactory, null));
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_10);
            return;
        }
        catch (Throwable throwable) {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_10);
            throw throwable;
        }
    }

    private void registerRegionService(Region region) {
        try {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_11);
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("org.eclipse.virgo.kernel.region.name", region.getName());
            this.tracker.track(this.bundleContext.registerService(Region.class, (Object)region, props));
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_11);
            return;
        }
        catch (Throwable throwable) {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_11);
            throw throwable;
        }
    }

    public void stop() {
        try {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_12);
            this.tracker.unregisterAll();
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_12);
            return;
        }
        catch (Throwable throwable) {
            RegionManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_12);
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("RegionManager.java", Class.forName("org.eclipse.virgo.kernel.osgi.region.RegionManager"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "start", "org.eclipse.virgo.kernel.osgi.region.RegionManager", "", "", "org.osgi.framework.BundleException:", "void"), 60);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createRegionDigraph", "org.eclipse.virgo.kernel.osgi.region.RegionManager", "", "", "org.osgi.framework.BundleException:", "org.eclipse.virgo.kernel.osgi.region.RegionDigraph"), 65);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "registerResolverHookFactory", "org.eclipse.virgo.kernel.osgi.region.RegionManager", "org.osgi.framework.hooks.resolver.ResolverHookFactory:", "resolverHookFactory:", "", "void"), 129);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "registerRegionService", "org.eclipse.virgo.kernel.osgi.region.RegionManager", "org.eclipse.virgo.kernel.osgi.region.Region:", "region:", "", "void"), 133);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "stop", "org.eclipse.virgo.kernel.osgi.region.RegionManager", "", "", "", "void"), 139);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "registerDigraphMbean", "org.eclipse.virgo.kernel.osgi.region.RegionManager", "org.eclipse.virgo.kernel.osgi.region.RegionDigraph:", "regionDigraph:", "", "void"), 73);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createKernelRegion", "org.eclipse.virgo.kernel.osgi.region.RegionManager", "org.eclipse.virgo.kernel.osgi.region.RegionDigraph:", "regionDigraph:", "org.osgi.framework.BundleException:", "org.eclipse.virgo.kernel.osgi.region.Region"), 79);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "registerRegionHooks", "org.eclipse.virgo.kernel.osgi.region.RegionManager", "org.eclipse.virgo.kernel.osgi.region.RegionDigraph:", "regionDigraph:", "", "void"), 91);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "registerRegionDigraph", "org.eclipse.virgo.kernel.osgi.region.RegionManager", "org.eclipse.virgo.kernel.osgi.region.RegionDigraph:", "regionDigraph:", "", "void"), 107);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "registerServiceFindHook", "org.eclipse.virgo.kernel.osgi.region.RegionManager", "org.osgi.framework.hooks.service.FindHook:", "serviceFindHook:", "", "void"), 111);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "registerServiceEventHook", "org.eclipse.virgo.kernel.osgi.region.RegionManager", "org.osgi.framework.hooks.service.EventHook:", "serviceEventHook:", "", "void"), 116);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "registerBundleFindHook", "org.eclipse.virgo.kernel.osgi.region.RegionManager", "org.osgi.framework.hooks.bundle.FindHook:", "findHook:", "", "void"), 120);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "registerBundleEventHook", "org.eclipse.virgo.kernel.osgi.region.RegionManager", "org.osgi.framework.hooks.bundle.EventHook:", "eventHook:", "", "void"), 124);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.osgi.region.RegionManager");
    }
}

