/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.osgi.region.hook;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.core.FatalKernelException;
import org.eclipse.virgo.kernel.osgi.region.Region;
import org.eclipse.virgo.kernel.osgi.region.RegionDigraph;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.hooks.bundle.EventHook;
import org.osgi.framework.hooks.bundle.FindHook;

public final class RegionBundleEventHook
implements EventHook {
    private final RegionDigraph regionDigraph;
    private final FindHook bundleFindHook;
    private final ThreadLocal<Region> threadLocal;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public RegionBundleEventHook(RegionDigraph regionDigraph, FindHook bundleFindBook, ThreadLocal<Region> threadLocal) {
        this.regionDigraph = regionDigraph;
        this.bundleFindHook = bundleFindBook;
        this.threadLocal = threadLocal;
    }

    public void event(BundleEvent event, Collection<BundleContext> contexts) {
        try {
            RegionBundleEventHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
            Bundle eventBundle = event.getBundle();
            if (event.getType() == 1) {
                this.bundleInstalled(eventBundle, event.getOrigin());
            }
            Iterator<BundleContext> i = contexts.iterator();
            while (i.hasNext()) {
                if (this.find(i.next(), eventBundle)) continue;
                i.remove();
            }
            if (event.getType() == 16) {
                this.bundleUninstalled(eventBundle);
            }
            RegionBundleEventHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return;
        }
        catch (Throwable throwable) {
            RegionBundleEventHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    private boolean find(BundleContext finderBundleContext, Bundle candidateBundle) {
        try {
            RegionBundleEventHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
            ArrayList<Bundle> candidates = new ArrayList<Bundle>(1);
            candidates.add(candidateBundle);
            this.bundleFindHook.find(finderBundleContext, candidates);
            boolean bl = !candidates.isEmpty();
            RegionBundleEventHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
            return bl;
        }
        catch (Throwable throwable) {
            RegionBundleEventHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    private void bundleInstalled(Bundle eventBundle, Bundle originBundle) {
        try {
            RegionBundleEventHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
            Region installRegion = this.threadLocal.get();
            if (installRegion != null) {
                try {
                    installRegion.addBundle(eventBundle);
                }
                catch (BundleException e) {
                    e.printStackTrace();
                    throw new FatalKernelException("Bundle could not be added to region", (Throwable)e);
                }
            }
            Region originRegion = this.regionDigraph.getRegion(originBundle);
            if (originRegion != null) {
                try {
                    originRegion.addBundle(eventBundle);
                }
                catch (BundleException e) {
                    e.printStackTrace();
                    throw new FatalKernelException("Bundle could not be added to region", (Throwable)e);
                }
            }
            RegionBundleEventHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
            return;
        }
        catch (Throwable throwable) {
            RegionBundleEventHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    private void bundleUninstalled(Bundle eventBundle) {
        try {
            RegionBundleEventHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
            Region region = this.regionDigraph.getRegion(eventBundle);
            if (region != null) {
                region.removeBundle(eventBundle);
            }
            RegionBundleEventHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
            return;
        }
        catch (Throwable throwable) {
            RegionBundleEventHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("RegionBundleEventHook.java", Class.forName("org.eclipse.virgo.kernel.osgi.region.hook.RegionBundleEventHook"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "event", "org.eclipse.virgo.kernel.osgi.region.hook.RegionBundleEventHook", "org.osgi.framework.BundleEvent:java.util.Collection:", "event:contexts:", "", "void"), 60);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "find", "org.eclipse.virgo.kernel.osgi.region.hook.RegionBundleEventHook", "org.osgi.framework.BundleContext:org.osgi.framework.Bundle:", "finderBundleContext:candidateBundle:", "", "boolean"), 76);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "bundleInstalled", "org.eclipse.virgo.kernel.osgi.region.hook.RegionBundleEventHook", "org.osgi.framework.Bundle:org.osgi.framework.Bundle:", "eventBundle:originBundle:", "", "void"), 87);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "bundleUninstalled", "org.eclipse.virgo.kernel.osgi.region.hook.RegionBundleEventHook", "org.osgi.framework.Bundle:", "eventBundle:", "", "void"), 109);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.osgi.region.hook.RegionBundleEventHook");
    }
}

