/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.osgi.region.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.osgi.region.Region;
import org.eclipse.virgo.kernel.osgi.region.RegionDigraph;
import org.eclipse.virgo.kernel.osgi.region.RegionDigraphPersistence;
import org.eclipse.virgo.kernel.osgi.region.RegionDigraphVisitor;
import org.eclipse.virgo.kernel.osgi.region.RegionFilter;
import org.eclipse.virgo.kernel.osgi.region.RegionFilterBuilder;
import org.eclipse.virgo.kernel.osgi.region.internal.BundleIdBasedRegion;
import org.eclipse.virgo.kernel.osgi.region.internal.RegionLifecycleListener;
import org.eclipse.virgo.kernel.osgi.region.internal.StandardRegionDigraphPersistence;
import org.eclipse.virgo.kernel.osgi.region.internal.StandardRegionFilterBuilder;
import org.eclipse.virgo.kernel.osgi.region.internal.SubgraphTraverser;
import org.eclipse.virgo.kernel.serviceability.NonNull;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.util.math.OrderedPair;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public final class StandardRegionDigraph
implements RegionDigraph {
    private final Object monitor = new Object();
    private final Set<Region> regions = new HashSet<Region>();
    private final Map<OrderedPair<Region, Region>, RegionFilter> filter = new HashMap<OrderedPair<Region, Region>, RegionFilter>();
    private final BundleContext bundleContext;
    private final ThreadLocal<Region> threadLocal;
    private final SubgraphTraverser subgraphTraverser = new SubgraphTraverser();
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

    StandardRegionDigraph() {
        this(null, null);
    }

    public StandardRegionDigraph(BundleContext bundleContext, ThreadLocal<Region> threadLocal) {
        this.bundleContext = bundleContext;
        this.threadLocal = threadLocal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Region createRegion(String regionName) throws BundleException {
        try {
            StandardRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
            BundleIdBasedRegion region = new BundleIdBasedRegion(regionName, this, this.bundleContext, this.threadLocal);
            Object object = this.monitor;
            synchronized (object) {
                if (this.getRegion(regionName) != null) {
                    throw new BundleException("Region '" + regionName + "' already exists", 1);
                }
                this.regions.add(region);
            }
            this.notifyAdded(region);
            BundleIdBasedRegion bundleIdBasedRegion = region;
            StandardRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return bundleIdBasedRegion;
        }
        catch (Throwable throwable) {
            StandardRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(@NonNull Region tailRegion, @NonNull RegionFilter filter, @NonNull Region headRegion) throws BundleException {
        try {
            StandardRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
            if (headRegion.equals(tailRegion)) {
                throw new BundleException("Cannot connect region '" + headRegion + "' to itself", 1);
            }
            OrderedPair nodePair = new OrderedPair((Object)tailRegion, (Object)headRegion);
            boolean tailAdded = false;
            boolean headAdded = false;
            Object object = this.monitor;
            synchronized (object) {
                if (this.filter.containsKey(nodePair)) {
                    throw new BundleException("Region '" + tailRegion + "' is already connected to region '" + headRegion, 1);
                }
                this.checkFilterDoesNotAllowExistingBundle(tailRegion, filter);
                tailAdded = this.regions.add(tailRegion);
                headAdded = this.regions.add(headRegion);
                this.filter.put((OrderedPair<Region, Region>)nodePair, filter);
            }
            if (tailAdded) {
                this.notifyAdded(tailRegion);
            }
            if (headAdded) {
                this.notifyAdded(headRegion);
            }
            StandardRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
            return;
        }
        catch (Throwable throwable) {
            StandardRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    private void checkFilterDoesNotAllowExistingBundle(Region tailRegion, RegionFilter filter) throws BundleException {
        try {
            StandardRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
            StandardRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
            return;
        }
        catch (Throwable throwable) {
            StandardRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Region> iterator() {
        try {
            Iterator<Region> iterator;
            StandardRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_3);
            Object object = this.monitor;
            synchronized (object) {
                HashSet<Region> snapshot = new HashSet<Region>(this.regions.size());
                snapshot.addAll(this.regions);
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var1_1
                iterator = snapshot.iterator();
            }
            StandardRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_3);
            return iterator;
        }
        catch (Throwable throwable) {
            StandardRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<RegionDigraph.FilteredRegion> getEdges(Region tailRegion) {
        HashSet<RegionDigraph.FilteredRegion> edges = new HashSet<RegionDigraph.FilteredRegion>();
        Object object = this.monitor;
        synchronized (object) {
            Set<OrderedPair<Region, Region>> regionPairs = this.filter.keySet();
            for (OrderedPair<Region, Region> regionPair : regionPairs) {
                if (!tailRegion.equals(regionPair.getFirst())) continue;
                edges.add(new StandardFilteredRegion((Region)regionPair.getSecond(), this.filter.get(regionPair)));
            }
        }
        return edges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Region getRegion(@NonNull String regionName) {
        Object object = this.monitor;
        synchronized (object) {
            for (Region region : this) {
                if (!regionName.equals(region.getName())) continue;
                return region;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Region getRegion(Bundle bundle) {
        Object object = this.monitor;
        synchronized (object) {
            for (Region region : this) {
                if (!region.contains(bundle)) continue;
                return region;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Region getRegion(long bundleId) {
        Object object = this.monitor;
        synchronized (object) {
            for (Region region : this) {
                if (!region.contains(bundleId)) continue;
                return region;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRegion(@NonNull Region region) {
        try {
            StandardRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_4);
            this.notifyRemoving(region);
            Object object = this.monitor;
            synchronized (object) {
                this.regions.remove(region);
                Iterator<OrderedPair<Region, Region>> i = this.filter.keySet().iterator();
                while (i.hasNext()) {
                    OrderedPair<Region, Region> regionPair = i.next();
                    if (!region.equals(regionPair.getFirst()) && !region.equals(regionPair.getSecond())) continue;
                    i.remove();
                }
            }
            StandardRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_4);
            return;
        }
        catch (Throwable throwable) {
            StandardRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_4);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        try {
            String string;
            StandardRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_5);
            Object object = this.monitor;
            synchronized (object) {
                StringBuffer s = new StringBuffer();
                boolean first = true;
                s.append("RegionDigraph{");
                for (Region region : this) {
                    if (!first) {
                        s.append(", ");
                    }
                    s.append(region);
                    first = false;
                }
                s.append("}");
                s.append("[");
                first = true;
                for (OrderedPair orderedPair : this.filter.keySet()) {
                    if (!first) {
                        s.append(", ");
                    }
                    s.append(orderedPair.getFirst() + "->" + orderedPair.getSecond());
                    first = false;
                }
                s.append("]");
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl37 : MonitorExitStatement: MONITOREXIT : object
                string = s.toString();
            }
            StandardRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_5);
            return string;
        }
        catch (Throwable throwable) {
            StandardRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_5);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Region> getRegions() {
        HashSet<Region> result = new HashSet<Region>();
        Object object = this.monitor;
        synchronized (object) {
            result.addAll(this.regions);
        }
        return result;
    }

    @Override
    public RegionFilterBuilder createRegionFilterBuilder() {
        try {
            StandardRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_6);
            StandardRegionFilterBuilder standardRegionFilterBuilder = new StandardRegionFilterBuilder();
            StandardRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_6);
            return standardRegionFilterBuilder;
        }
        catch (Throwable throwable) {
            StandardRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_6);
            throw throwable;
        }
    }

    private void notifyAdded(Region region) {
        try {
            StandardRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_7);
            Set<RegionLifecycleListener> listeners = this.getListeners();
            for (RegionLifecycleListener listener : listeners) {
                listener.regionAdded(region);
            }
            StandardRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_7);
            return;
        }
        catch (Throwable throwable) {
            StandardRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_7);
            throw throwable;
        }
    }

    private void notifyRemoving(Region region) {
        try {
            StandardRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_8);
            Set<RegionLifecycleListener> listeners = this.getListeners();
            for (RegionLifecycleListener listener : listeners) {
                listener.regionRemoving(region);
            }
            StandardRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_8);
            return;
        }
        catch (Throwable throwable) {
            StandardRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_8);
            throw throwable;
        }
    }

    private Set<RegionLifecycleListener> getListeners() {
        HashSet<RegionLifecycleListener> listeners = new HashSet<RegionLifecycleListener>();
        if (this.bundleContext == null) {
            return listeners;
        }
        try {
            Collection listenerServiceReferences = this.bundleContext.getServiceReferences(RegionLifecycleListener.class, null);
            for (ServiceReference listenerServiceReference : listenerServiceReferences) {
                RegionLifecycleListener regionLifecycleListener = (RegionLifecycleListener)this.bundleContext.getService(listenerServiceReference);
                if (regionLifecycleListener == null) continue;
                listeners.add(regionLifecycleListener);
            }
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
        return listeners;
    }

    @Override
    public void visitSubgraph(Region startingRegion, RegionDigraphVisitor visitor) {
        try {
            StandardRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_9);
            this.subgraphTraverser.visitSubgraph(startingRegion, visitor);
            StandardRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_9);
            return;
        }
        catch (Throwable throwable) {
            StandardRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_9);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<Region, Set<RegionDigraph.FilteredRegion>> getFilteredRegions() {
        HashMap<Region, Set<RegionDigraph.FilteredRegion>> result = new HashMap<Region, Set<RegionDigraph.FilteredRegion>>();
        Object object = this.monitor;
        synchronized (object) {
            for (Region region : this.regions) {
                result.put(region, this.getEdges(region));
            }
        }
        return result;
    }

    @Override
    public RegionDigraphPersistence getRegionDigraphPersistence() {
        return new StandardRegionDigraphPersistence();
    }

    static {
        Factory factory = new Factory("StandardRegionDigraph.java", Class.forName("org.eclipse.virgo.kernel.osgi.region.internal.StandardRegionDigraph"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createRegion", "org.eclipse.virgo.kernel.osgi.region.internal.StandardRegionDigraph", "java.lang.String:", "regionName:", "org.osgi.framework.BundleException:", "org.eclipse.virgo.kernel.osgi.region.Region"), 75);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "connect", "org.eclipse.virgo.kernel.osgi.region.internal.StandardRegionDigraph", "org.eclipse.virgo.kernel.osgi.region.Region:org.eclipse.virgo.kernel.osgi.region.RegionFilter:org.eclipse.virgo.kernel.osgi.region.Region:", "tailRegion:filter:headRegion:", "org.osgi.framework.BundleException:", "void"), 91);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkFilterDoesNotAllowExistingBundle", "org.eclipse.virgo.kernel.osgi.region.internal.StandardRegionDigraph", "org.eclipse.virgo.kernel.osgi.region.Region:org.eclipse.virgo.kernel.osgi.region.RegionFilter:", "tailRegion:filter:", "org.osgi.framework.BundleException:", "void"), 118);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "iterator", "org.eclipse.virgo.kernel.osgi.region.internal.StandardRegionDigraph", "", "", "", "java.util.Iterator"), 125);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removeRegion", "org.eclipse.virgo.kernel.osgi.region.internal.StandardRegionDigraph", "org.eclipse.virgo.kernel.osgi.region.Region:", "region:", "", "void"), 222);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toString", "org.eclipse.virgo.kernel.osgi.region.internal.StandardRegionDigraph", "", "", "", "java.lang.String"), 240);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createRegionFilterBuilder", "org.eclipse.virgo.kernel.osgi.region.internal.StandardRegionDigraph", "", "", "", "org.eclipse.virgo.kernel.osgi.region.RegionFilterBuilder"), 277);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "notifyAdded", "org.eclipse.virgo.kernel.osgi.region.internal.StandardRegionDigraph", "org.eclipse.virgo.kernel.osgi.region.Region:", "region:", "", "void"), 281);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "notifyRemoving", "org.eclipse.virgo.kernel.osgi.region.internal.StandardRegionDigraph", "org.eclipse.virgo.kernel.osgi.region.Region:", "region:", "", "void"), 288);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "visitSubgraph", "org.eclipse.virgo.kernel.osgi.region.internal.StandardRegionDigraph", "org.eclipse.virgo.kernel.osgi.region.Region:org.eclipse.virgo.kernel.osgi.region.RegionDigraphVisitor:", "startingRegion:visitor:", "", "void"), 318);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.osgi.region.internal.StandardRegionDigraph");
    }

    private static class StandardFilteredRegion
    implements RegionDigraph.FilteredRegion {
        private Region region;
        private RegionFilter regionFilter;
        private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

        private StandardFilteredRegion(Region region, RegionFilter regionFilter) {
            this.region = region;
            this.regionFilter = regionFilter;
        }

        @Override
        public Region getRegion() {
            return this.region;
        }

        @Override
        public RegionFilter getFilter() {
            return this.regionFilter;
        }

        public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
            return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
        }

        static {
            ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.osgi.region.internal.StandardRegionDigraph$StandardFilteredRegion");
        }
    }
}

