/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.osgi.region.internal;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.osgi.region.Region;
import org.eclipse.virgo.kernel.osgi.region.RegionDigraph;
import org.eclipse.virgo.kernel.osgi.region.RegionDigraphPersistence;
import org.eclipse.virgo.kernel.osgi.region.RegionFilter;
import org.eclipse.virgo.kernel.osgi.region.RegionFilterBuilder;
import org.eclipse.virgo.kernel.osgi.region.internal.StandardRegionDigraph;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;

final class StandardRegionDigraphPersistence
implements RegionDigraphPersistence {
    private static final String PERSISTENT_NAME = "virgo region digraph";
    private static final int PERSISTENT_VERSION = 1;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;

    StandardRegionDigraphPersistence() {
    }

    static void writeRegionDigraph(DataOutputStream out, RegionDigraph digraph) throws IOException {
        try {
            StandardRegionDigraphPersistence.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_0);
            if (!(digraph instanceof StandardRegionDigraph)) {
                throw new IllegalArgumentException("Only digraphs of type '" + StandardRegionDigraph.class.getName() + "' are allowed: " + digraph.getClass().getName());
            }
            Map<Region, Set<RegionDigraph.FilteredRegion>> filteredRegions = ((StandardRegionDigraph)digraph).getFilteredRegions();
            try {
                out.writeUTF(PERSISTENT_NAME);
                out.writeInt(1);
                out.writeInt(filteredRegions.size());
                for (Region region : filteredRegions.keySet()) {
                    StandardRegionDigraphPersistence.writeRegion(out, region);
                }
                out.writeInt(filteredRegions.size());
                for (Map.Entry entry : filteredRegions.entrySet()) {
                    out.writeInt(((Set)entry.getValue()).size());
                    for (RegionDigraph.FilteredRegion edge : (Set)entry.getValue()) {
                        StandardRegionDigraphPersistence.writeEdge(out, (Region)entry.getKey(), edge.getFilter(), edge.getRegion());
                    }
                }
            }
            finally {
                out.flush();
            }
            StandardRegionDigraphPersistence.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_0);
            return;
        }
        catch (Throwable throwable) {
            StandardRegionDigraphPersistence.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    private static void writeRegion(DataOutputStream out, Region region) throws IOException {
        try {
            StandardRegionDigraphPersistence.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
            out.writeUTF(region.getName());
            Set<Long> ids = region.getBundleIds();
            out.writeInt(ids.size());
            for (Long id : ids) {
                out.writeLong(id);
            }
            StandardRegionDigraphPersistence.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
            return;
        }
        catch (Throwable throwable) {
            StandardRegionDigraphPersistence.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    private static void writeEdge(DataOutputStream out, Region tail, RegionFilter filter, Region head) throws IOException {
        try {
            StandardRegionDigraphPersistence.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
            out.writeUTF(tail.getName());
            out.writeUTF(head.getName());
            Map<String, Collection<String>> policy = filter.getSharingPolicy();
            out.writeInt(policy.size());
            for (Map.Entry<String, Collection<String>> namespace : policy.entrySet()) {
                out.writeUTF(namespace.getKey());
                Collection<String> filters = namespace.getValue();
                out.writeInt(filters.size());
                for (String filterSpec : filters) {
                    out.writeUTF(filterSpec);
                }
            }
            StandardRegionDigraphPersistence.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
            return;
        }
        catch (Throwable throwable) {
            StandardRegionDigraphPersistence.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    static RegionDigraph readRegionDigraph(DataInputStream in) throws IOException, InvalidSyntaxException, BundleException {
        try {
            StandardRegionDigraphPersistence.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
            StandardRegionDigraph digraph = new StandardRegionDigraph();
            String persistentName = in.readUTF();
            if (!PERSISTENT_NAME.equals(persistentName)) {
                throw new IllegalArgumentException("Input stream does not represent a digraph");
            }
            int persistentVersion = in.readInt();
            if (1 != persistentVersion) {
                throw new IllegalArgumentException("Input stream contains a digraph with an incompatible version '" + persistentVersion + "'");
            }
            int numRegions = in.readInt();
            int i = 0;
            while (i < numRegions) {
                StandardRegionDigraphPersistence.readRegion(in, digraph);
                ++i;
            }
            int numTails = in.readInt();
            int i2 = 0;
            while (i2 < numTails) {
                int numEdges = in.readInt();
                int j = 0;
                while (j < numEdges) {
                    StandardRegionDigraphPersistence.readEdge(in, digraph);
                    ++j;
                }
                ++i2;
            }
            StandardRegionDigraph standardRegionDigraph = digraph;
            StandardRegionDigraphPersistence.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
            return standardRegionDigraph;
        }
        catch (Throwable throwable) {
            StandardRegionDigraphPersistence.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    private static Region readRegion(DataInputStream in, RegionDigraph digraph) throws IOException, BundleException {
        try {
            StandardRegionDigraphPersistence.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
            String name = in.readUTF();
            Region region = digraph.createRegion(name);
            int numIds = in.readInt();
            int i = 0;
            while (i < numIds) {
                region.addBundle(in.readLong());
                ++i;
            }
            Region region2 = region;
            StandardRegionDigraphPersistence.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
            return region2;
        }
        catch (Throwable throwable) {
            StandardRegionDigraphPersistence.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
            throw throwable;
        }
    }

    private static void readEdge(DataInputStream in, RegionDigraph digraph) throws IOException, InvalidSyntaxException, BundleException {
        try {
            StandardRegionDigraphPersistence.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_5);
            String tailName = in.readUTF();
            Region tail = digraph.getRegion(tailName);
            if (tail == null) {
                throw new IOException("Could not find tail region: " + tailName);
            }
            String headName = in.readUTF();
            Region head = digraph.getRegion(headName);
            if (head == null) {
                throw new IOException("Could not find head region: " + headName);
            }
            RegionFilterBuilder builder = digraph.createRegionFilterBuilder();
            int numSpaces = in.readInt();
            int i = 0;
            while (i < numSpaces) {
                String namespace = in.readUTF();
                int numFilters = in.readInt();
                int j = 0;
                while (j < numFilters) {
                    String filter = in.readUTF();
                    builder.allow(namespace, filter);
                    ++j;
                }
                ++i;
            }
            digraph.connect(tail, builder.build(), head);
            StandardRegionDigraphPersistence.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_5);
            return;
        }
        catch (Throwable throwable) {
            StandardRegionDigraphPersistence.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_5);
            throw throwable;
        }
    }

    @Override
    public RegionDigraph load(InputStream input) throws IOException {
        try {
            RegionDigraph regionDigraph;
            StandardRegionDigraphPersistence.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_6);
            try {
                regionDigraph = StandardRegionDigraphPersistence.readRegionDigraph(new DataInputStream(input));
            }
            catch (InvalidSyntaxException e) {
                throw new IllegalStateException("Internal error reading a filter", e);
            }
            catch (BundleException e) {
                throw new IllegalStateException("Internal error creating the digraph", e);
            }
            StandardRegionDigraphPersistence.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_6);
            return regionDigraph;
        }
        catch (Throwable throwable) {
            StandardRegionDigraphPersistence.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_6);
            throw throwable;
        }
    }

    @Override
    public void save(RegionDigraph digraph, OutputStream output) throws IOException {
        try {
            StandardRegionDigraphPersistence.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_7);
            StandardRegionDigraphPersistence.writeRegionDigraph(new DataOutputStream(output), digraph);
            StandardRegionDigraphPersistence.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_7);
            return;
        }
        catch (Throwable throwable) {
            StandardRegionDigraphPersistence.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_7);
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("StandardRegionDigraphPersistence.java", Class.forName("org.eclipse.virgo.kernel.osgi.region.internal.StandardRegionDigraphPersistence"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("8", "writeRegionDigraph", "org.eclipse.virgo.kernel.osgi.region.internal.StandardRegionDigraphPersistence", "java.io.DataOutputStream:org.eclipse.virgo.kernel.osgi.region.RegionDigraph:", "out:digraph:", "java.io.IOException:", "void"), 47);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "writeRegion", "org.eclipse.virgo.kernel.osgi.region.internal.StandardRegionDigraphPersistence", "java.io.DataOutputStream:org.eclipse.virgo.kernel.osgi.region.Region:", "out:region:", "java.io.IOException:", "void"), 80);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "writeEdge", "org.eclipse.virgo.kernel.osgi.region.internal.StandardRegionDigraphPersistence", "java.io.DataOutputStream:org.eclipse.virgo.kernel.osgi.region.Region:org.eclipse.virgo.kernel.osgi.region.RegionFilter:org.eclipse.virgo.kernel.osgi.region.Region:", "out:tail:filter:head:", "java.io.IOException:", "void"), 93);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("8", "readRegionDigraph", "org.eclipse.virgo.kernel.osgi.region.internal.StandardRegionDigraphPersistence", "java.io.DataInputStream:", "in:", "java.io.IOException:org.osgi.framework.InvalidSyntaxException:org.osgi.framework.BundleException:", "org.eclipse.virgo.kernel.osgi.region.RegionDigraph"), 115);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "readRegion", "org.eclipse.virgo.kernel.osgi.region.internal.StandardRegionDigraphPersistence", "java.io.DataInputStream:org.eclipse.virgo.kernel.osgi.region.RegionDigraph:", "in:digraph:", "java.io.IOException:org.osgi.framework.BundleException:", "org.eclipse.virgo.kernel.osgi.region.Region"), 147);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "readEdge", "org.eclipse.virgo.kernel.osgi.region.internal.StandardRegionDigraphPersistence", "java.io.DataInputStream:org.eclipse.virgo.kernel.osgi.region.RegionDigraph:", "in:digraph:", "java.io.IOException:org.osgi.framework.InvalidSyntaxException:org.osgi.framework.BundleException:", "void"), 160);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "load", "org.eclipse.virgo.kernel.osgi.region.internal.StandardRegionDigraphPersistence", "java.io.InputStream:", "input:", "java.io.IOException:", "org.eclipse.virgo.kernel.osgi.region.RegionDigraph"), 193);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "save", "org.eclipse.virgo.kernel.osgi.region.internal.StandardRegionDigraphPersistence", "org.eclipse.virgo.kernel.osgi.region.RegionDigraph:java.io.OutputStream:", "digraph:output:", "java.io.IOException:", "void"), 210);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.osgi.region.internal.StandardRegionDigraphPersistence");
    }
}

