/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.osgi.region.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.osgi.region.RegionFilter;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;

final class StandardRegionFilter
implements RegionFilter {
    private final Map<String, Collection<Filter>> filters;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;

    StandardRegionFilter(Map<String, Collection<Filter>> filters) {
        if (filters == null) {
            throw new IllegalArgumentException("filters must not be null.");
        }
        this.filters = new HashMap<String, Collection<Filter>>((int)((double)filters.size() / 0.75 + 1.0));
        for (Map.Entry<String, Collection<Filter>> namespace : filters.entrySet()) {
            ArrayList<Filter> namespaceFilters = new ArrayList<Filter>(namespace.getValue());
            this.filters.put(namespace.getKey(), namespaceFilters);
        }
    }

    @Override
    public boolean isAllowed(Bundle bundle) {
        try {
            StandardRegionFilter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
            HashMap<String, String> attrs = new HashMap<String, String>(3);
            String bsn = bundle.getSymbolicName();
            if (bsn != null) {
                attrs.put("org.eclipse.equinox.allow.bundle", bsn);
            }
            attrs.put("bundle-version", (String)bundle.getVersion());
            boolean bl = this.isBundleAllowed(attrs);
            StandardRegionFilter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return bl;
        }
        catch (Throwable throwable) {
            StandardRegionFilter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    @Override
    public boolean isAllowed(BundleRevision bundle) {
        try {
            StandardRegionFilter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
            HashMap<String, String> attrs = new HashMap<String, String>(3);
            String bsn = bundle.getSymbolicName();
            if (bsn != null) {
                attrs.put("org.eclipse.equinox.allow.bundle", bsn);
            }
            attrs.put("bundle-version", (String)bundle.getVersion());
            boolean bl = this.isBundleAllowed(attrs);
            StandardRegionFilter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
            return bl;
        }
        catch (Throwable throwable) {
            StandardRegionFilter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    private boolean isBundleAllowed(Map<String, ?> bundleAttributes) {
        try {
            StandardRegionFilter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
            boolean bl = this.match(this.filters.get("org.eclipse.equinox.allow.bundle"), bundleAttributes) ? true : this.match(this.filters.get("org.eclipse.equinox.allow.all"), bundleAttributes);
            StandardRegionFilter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
            return bl;
        }
        catch (Throwable throwable) {
            StandardRegionFilter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    private boolean match(Collection<Filter> filters, Map<String, ?> attrs) {
        try {
            boolean bl;
            block5: {
                StandardRegionFilter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
                if (filters == null) {
                    bl = false;
                } else {
                    for (Filter filter : filters) {
                        if (!filter.matches(attrs)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            StandardRegionFilter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
            return bl;
        }
        catch (Throwable throwable) {
            StandardRegionFilter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    private boolean match(Collection<Filter> filters, ServiceReference<?> service) {
        try {
            boolean bl;
            block5: {
                StandardRegionFilter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
                if (filters == null) {
                    bl = false;
                } else {
                    for (Filter filter : filters) {
                        if (!filter.match(service)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            StandardRegionFilter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
            return bl;
        }
        catch (Throwable throwable) {
            StandardRegionFilter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
            throw throwable;
        }
    }

    @Override
    public boolean isAllowed(ServiceReference<?> service) {
        try {
            StandardRegionFilter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_5);
            boolean bl = this.match(this.filters.get("org.eclipse.equinox.allow.service"), service) ? true : this.match(this.filters.get("org.eclipse.equinox.allow.all"), service);
            StandardRegionFilter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_5);
            return bl;
        }
        catch (Throwable throwable) {
            StandardRegionFilter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_5);
            throw throwable;
        }
    }

    @Override
    public boolean isAllowed(BundleCapability capability) {
        try {
            StandardRegionFilter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_6);
            String namespace = capability.getNamespace();
            Map attrs = capability.getAttributes();
            boolean bl = this.match(this.filters.get(namespace), attrs) ? true : this.match(this.filters.get("org.eclipse.equinox.allow.all"), attrs);
            StandardRegionFilter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_6);
            return bl;
        }
        catch (Throwable throwable) {
            StandardRegionFilter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_6);
            throw throwable;
        }
    }

    @Override
    public Map<String, Collection<String>> getSharingPolicy() {
        HashMap<String, Collection<String>> result = new HashMap<String, Collection<String>>((int)((double)this.filters.size() / 0.75 + 1.0));
        for (Map.Entry<String, Collection<Filter>> namespace : this.filters.entrySet()) {
            result.put(namespace.getKey(), StandardRegionFilter.getFilters(namespace.getValue()));
        }
        return result;
    }

    private static Collection<String> getFilters(Collection<Filter> filters) {
        ArrayList<String> result = new ArrayList<String>(filters.size());
        for (Filter filter : filters) {
            result.add(filter.toString());
        }
        return result;
    }

    public String toString() {
        try {
            StandardRegionFilter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_7);
            String string = this.getSharingPolicy().toString();
            StandardRegionFilter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_7);
            return string;
        }
        catch (Throwable throwable) {
            StandardRegionFilter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_7);
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("StandardRegionFilter.java", Class.forName("org.eclipse.virgo.kernel.osgi.region.internal.StandardRegionFilter"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isAllowed", "org.eclipse.virgo.kernel.osgi.region.internal.StandardRegionFilter", "org.osgi.framework.Bundle:", "bundle:", "", "boolean"), 49);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isAllowed", "org.eclipse.virgo.kernel.osgi.region.internal.StandardRegionFilter", "org.osgi.framework.wiring.BundleRevision:", "bundle:", "", "boolean"), 64);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "isBundleAllowed", "org.eclipse.virgo.kernel.osgi.region.internal.StandardRegionFilter", "java.util.Map:", "bundleAttributes:", "", "boolean"), 79);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "match", "org.eclipse.virgo.kernel.osgi.region.internal.StandardRegionFilter", "java.util.Collection:java.util.Map:", "filters:attrs:", "", "boolean"), 85);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "match", "org.eclipse.virgo.kernel.osgi.region.internal.StandardRegionFilter", "java.util.Collection:org.osgi.framework.ServiceReference:", "filters:service:", "", "boolean"), 95);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isAllowed", "org.eclipse.virgo.kernel.osgi.region.internal.StandardRegionFilter", "org.osgi.framework.ServiceReference:", "service:", "", "boolean"), 111);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isAllowed", "org.eclipse.virgo.kernel.osgi.region.internal.StandardRegionFilter", "org.osgi.framework.wiring.BundleCapability:", "capability:", "", "boolean"), 123);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toString", "org.eclipse.virgo.kernel.osgi.region.internal.StandardRegionFilter", "", "", "", "java.lang.String"), 147);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.osgi.region.internal.StandardRegionFilter");
    }
}

