/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.shell.internal.formatting;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.model.management.ManageableArtifact;
import org.eclipse.virgo.kernel.module.ModuleContext;
import org.eclipse.virgo.kernel.module.ModuleContextAccessor;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiBundle;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiExportPackage;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiImportPackage;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiResolutionFailure;
import org.eclipse.virgo.kernel.shell.internal.formatting.InstallArtifactCommandFormatter;
import org.eclipse.virgo.kernel.shell.state.QuasiLiveBundle;
import org.eclipse.virgo.kernel.shell.state.QuasiLiveService;
import org.eclipse.virgo.kernel.shell.state.StateService;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.util.common.StringUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public final class BundleInstallArtifactCommandFormatter
implements InstallArtifactCommandFormatter<ManageableArtifact> {
    private static final int MAX_LINE_LENGTH = 80;
    private static final String ID_COLUMN_NAME = "Id";
    private static final int ID_COLUMN_MIN_WIDTH;
    private static final String SPRING_POWERED_COLUMN_NAME = " ";
    private static final int SPRING_POWERED_COLUMN_WIDTH;
    private static final String NAME_COLUMN_NAME = "Name";
    private static final int NAME_COLUMN_MIN_WIDTH;
    private static final String VERSION_COLUMN_NAME = "Version";
    private static final int VERSION_COLUMN_MIN_WIDTH;
    private static final String STATE_COLUMN_NAME = "State";
    private static final int STATE_COLUMN_MIN_WIDTH = 11;
    private final StateService stateService;
    private final ModuleContextAccessor moduleContextAccessor;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;

    static {
        Factory factory = new Factory("BundleInstallArtifactCommandFormatter.java", Class.forName("org.eclipse.virgo.kernel.shell.internal.formatting.BundleInstallArtifactCommandFormatter"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "formatList", "org.eclipse.virgo.kernel.shell.internal.formatting.BundleInstallArtifactCommandFormatter", "java.util.List:", "artifacts:", "", "java.util.List"), 78);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "formatExamine", "org.eclipse.virgo.kernel.shell.internal.formatting.BundleInstallArtifactCommandFormatter", "org.eclipse.virgo.kernel.model.management.ManageableArtifact:", "artifact:", "", "java.util.List"), 112);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "formatDiag", "org.eclipse.virgo.kernel.shell.internal.formatting.BundleInstallArtifactCommandFormatter", "org.eclipse.virgo.kernel.osgi.quasi.QuasiBundle:java.util.List:", "bundle:resolverReport:", "", "java.util.List"), 275);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "formatHeaders", "org.eclipse.virgo.kernel.shell.internal.formatting.BundleInstallArtifactCommandFormatter", "org.eclipse.virgo.kernel.osgi.quasi.QuasiBundle:", "bundle:", "", "java.util.List"), 291);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "formatHeaderValue", "org.eclipse.virgo.kernel.shell.internal.formatting.BundleInstallArtifactCommandFormatter", "java.lang.String:", "value:", "", "java.util.List"), 334);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "formatConsumedServices", "org.eclipse.virgo.kernel.shell.internal.formatting.BundleInstallArtifactCommandFormatter", "org.eclipse.virgo.kernel.shell.internal.formatting.BundleInstallArtifactCommandFormatter$ArtifactHolder:", "artifactHolder:", "", "java.util.List"), 141);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "formatPublishedServices", "org.eclipse.virgo.kernel.shell.internal.formatting.BundleInstallArtifactCommandFormatter", "org.eclipse.virgo.kernel.shell.internal.formatting.BundleInstallArtifactCommandFormatter$ArtifactHolder:", "artifactHolder:", "", "java.util.List"), 159);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "extractFirstObjectClass", "org.eclipse.virgo.kernel.shell.internal.formatting.BundleInstallArtifactCommandFormatter", "java.lang.Object:", "objectClass:", "", "java.lang.String"), 182);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "formatHost", "org.eclipse.virgo.kernel.shell.internal.formatting.BundleInstallArtifactCommandFormatter", "org.eclipse.virgo.kernel.shell.internal.formatting.BundleInstallArtifactCommandFormatter$ArtifactHolder:", "artifactHolder:", "", "java.util.List"), 198);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "formatFragments", "org.eclipse.virgo.kernel.shell.internal.formatting.BundleInstallArtifactCommandFormatter", "org.eclipse.virgo.kernel.shell.internal.formatting.BundleInstallArtifactCommandFormatter$ArtifactHolder:", "artifactHolder:", "", "java.util.List"), 212);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "formatExportedPackages", "org.eclipse.virgo.kernel.shell.internal.formatting.BundleInstallArtifactCommandFormatter", "org.eclipse.virgo.kernel.shell.internal.formatting.BundleInstallArtifactCommandFormatter$ArtifactHolder:", "artifactHolder:", "", "java.util.List"), 229);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "formatImportedPackages", "org.eclipse.virgo.kernel.shell.internal.formatting.BundleInstallArtifactCommandFormatter", "org.eclipse.virgo.kernel.shell.internal.formatting.BundleInstallArtifactCommandFormatter$ArtifactHolder:", "artifactHolder:", "", "java.util.List"), 250);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "formatBundleSummary", "org.eclipse.virgo.kernel.shell.internal.formatting.BundleInstallArtifactCommandFormatter", "org.eclipse.virgo.kernel.osgi.quasi.QuasiBundle:", "bundle:", "", "java.lang.String"), 271);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.shell.internal.formatting.BundleInstallArtifactCommandFormatter");
        ID_COLUMN_MIN_WIDTH = ID_COLUMN_NAME.length();
        SPRING_POWERED_COLUMN_WIDTH = SPRING_POWERED_COLUMN_NAME.length();
        NAME_COLUMN_MIN_WIDTH = NAME_COLUMN_NAME.length();
        VERSION_COLUMN_MIN_WIDTH = VERSION_COLUMN_NAME.length();
    }

    public BundleInstallArtifactCommandFormatter(StateService stateService, ModuleContextAccessor moduleContextAccessor) {
        this.stateService = stateService;
        this.moduleContextAccessor = moduleContextAccessor;
    }

    @Override
    public List<String> formatList(List<ManageableArtifact> artifacts) {
        try {
            BundleInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
            List<ArtifactHolder> artifactHolders = this.getArtifactHolders(artifacts);
            Collections.sort(artifactHolders);
            int maxIdLength = ID_COLUMN_MIN_WIDTH;
            int maxNameLength = NAME_COLUMN_MIN_WIDTH;
            int maxVersionLength = VERSION_COLUMN_MIN_WIDTH;
            for (ArtifactHolder artifact : artifactHolders) {
                int idLength = artifact.getId().toString().length();
                maxIdLength = idLength > maxIdLength ? idLength : maxIdLength;
                int nameLength = artifact.getName().length();
                maxNameLength = nameLength > maxNameLength ? nameLength : maxNameLength;
                int versionLength = artifact.getVersion().length();
                int n = maxVersionLength = versionLength > maxVersionLength ? versionLength : maxVersionLength;
            }
            ArrayList<String> lines = new ArrayList<String>();
            int stateLength = 80 - (4 + maxIdLength + SPRING_POWERED_COLUMN_WIDTH + maxNameLength + maxVersionLength);
            if (stateLength < 11) {
                stateLength = 11;
            }
            String singleLineFormat = String.format("%%-%ds %%s %%-%ds %%-%ds %%%ds", maxIdLength, maxNameLength, maxVersionLength, stateLength);
            lines.add(String.format(singleLineFormat, ID_COLUMN_NAME, SPRING_POWERED_COLUMN_NAME, NAME_COLUMN_NAME, VERSION_COLUMN_NAME, STATE_COLUMN_NAME));
            for (ArtifactHolder artifact : artifactHolders) {
                lines.add(String.format(singleLineFormat, artifact.getId(), artifact.getSpringPowered() ? "S" : SPRING_POWERED_COLUMN_NAME, artifact.getName(), artifact.getVersion(), artifact.getState()));
            }
            ArrayList<String> arrayList = lines;
            BundleInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return arrayList;
        }
        catch (Throwable throwable) {
            BundleInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    @Override
    public List<String> formatExamine(ManageableArtifact artifact) {
        try {
            BundleInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
            ArrayList<String> lines = new ArrayList<String>();
            List<QuasiBundle> quasiBundles = this.stateService.getAllBundles(null);
            ArtifactHolder artifactHolder = this.getArtifactHolder(artifact, quasiBundles);
            if (artifactHolder == null) {
                lines.add("No artifact found of type '" + artifact.getType() + "' name '" + artifact.getName() + "' and version '" + artifact.getVersion() + "'");
            } else {
                lines.add(String.format("Id:              %s", artifactHolder.getId()));
                lines.add(String.format("Name:            %s", artifactHolder.getName()));
                lines.add(String.format("Version          %s", artifactHolder.getVersion()));
                lines.add(String.format("State:           %s", artifactHolder.getState()));
                lines.add(String.format("Spring Powered:  %s", artifactHolder.getSpringPowered()));
                String bundleLocation = artifactHolder.getBundleLocation();
                lines.add(String.format("Bundle Location: %s", bundleLocation == null ? "" : bundleLocation));
                lines.addAll(this.formatImportedPackages(artifactHolder));
                lines.addAll(this.formatExportedPackages(artifactHolder));
                lines.addAll(this.formatPublishedServices(artifactHolder));
                lines.addAll(this.formatConsumedServices(artifactHolder));
                lines.addAll(this.formatFragments(artifactHolder));
                lines.addAll(this.formatHost(artifactHolder));
            }
            ArrayList<String> arrayList = lines;
            BundleInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
            return arrayList;
        }
        catch (Throwable throwable) {
            BundleInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    private List<String> formatConsumedServices(ArtifactHolder artifactHolder) {
        try {
            BundleInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("");
            lines.add(String.format("Consumed services:", new Object[0]));
            List<QuasiLiveService> consumedServices = artifactHolder.getConsumedServices();
            if (consumedServices.isEmpty()) {
                lines.add(String.format("    None", new Object[0]));
            } else {
                for (QuasiLiveService consumedService : consumedServices) {
                    String objectClass = this.extractFirstObjectClass(consumedService.getProperties().get("objectClass"));
                    lines.add(String.format("    %3s %s", consumedService.getServiceId(), objectClass));
                    lines.add(String.format("        published by %s", this.formatBundleSummary(consumedService.getProvider())));
                }
            }
            ArrayList<String> arrayList = lines;
            BundleInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
            return arrayList;
        }
        catch (Throwable throwable) {
            BundleInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    private List<String> formatPublishedServices(ArtifactHolder artifactHolder) {
        try {
            BundleInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("");
            lines.add(String.format("Published services:", new Object[0]));
            List<QuasiLiveService> publishedServices = artifactHolder.getPublishedServices();
            if (publishedServices.isEmpty()) {
                lines.add(String.format("    None", new Object[0]));
            } else {
                for (QuasiLiveService publishedService : publishedServices) {
                    String objectClass = this.extractFirstObjectClass(publishedService.getProperties().get("objectClass"));
                    lines.add(String.format("    %3s %s", publishedService.getServiceId(), objectClass));
                    List<QuasiLiveBundle> consumers = publishedService.getConsumers();
                    for (QuasiLiveBundle consumer : consumers) {
                        lines.add(String.format("        consumed by %s", this.formatBundleSummary(consumer)));
                    }
                }
            }
            ArrayList<String> arrayList = lines;
            BundleInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
            return arrayList;
        }
        catch (Throwable throwable) {
            BundleInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    private String extractFirstObjectClass(Object objectClass) {
        try {
            BundleInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
            String[] objectClasses = objectClass instanceof String ? StringUtils.commaDelimitedListToStringArray((String)((String)objectClass)) : (objectClass instanceof Object[] ? (String[])objectClass : StringUtils.commaDelimitedListToStringArray((String)objectClass.toString()));
            String string = objectClasses.length > 0 ? objectClasses[0] : "<no object classes>";
            BundleInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
            return string;
        }
        catch (Throwable throwable) {
            BundleInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
            throw throwable;
        }
    }

    private List<String> formatHost(ArtifactHolder artifactHolder) {
        try {
            BundleInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_5);
            ArrayList<String> lines = new ArrayList<String>();
            List<QuasiBundle> hosts = artifactHolder.getHosts();
            if (hosts != null && !hosts.isEmpty()) {
                lines.add("");
                lines.add(String.format("Host:", new Object[0]));
                QuasiBundle host = hosts.get(0);
                lines.add(String.format("    %s", this.formatBundleSummary(host)));
            }
            ArrayList<String> arrayList = lines;
            BundleInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_5);
            return arrayList;
        }
        catch (Throwable throwable) {
            BundleInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_5);
            throw throwable;
        }
    }

    private List<String> formatFragments(ArtifactHolder artifactHolder) {
        try {
            BundleInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_6);
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("");
            lines.add(String.format("Fragments:", new Object[0]));
            List<QuasiBundle> fragments = artifactHolder.getFragments();
            if (fragments.isEmpty()) {
                lines.add(String.format("    None", new Object[0]));
            } else {
                for (QuasiBundle fragment : fragments) {
                    lines.add(String.format("    %s", this.formatBundleSummary(fragment)));
                }
            }
            ArrayList<String> arrayList = lines;
            BundleInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_6);
            return arrayList;
        }
        catch (Throwable throwable) {
            BundleInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_6);
            throw throwable;
        }
    }

    private List<String> formatExportedPackages(ArtifactHolder artifactHolder) {
        try {
            BundleInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_7);
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("");
            lines.add(String.format("Exported Packages:", new Object[0]));
            List<QuasiExportPackage> exportPackages = artifactHolder.getExportPackages();
            if (exportPackages.isEmpty()) {
                lines.add(String.format("    None", new Object[0]));
            } else {
                for (QuasiExportPackage exportPackage : exportPackages) {
                    lines.add(String.format("    %s %s", exportPackage.getPackageName(), exportPackage.getVersion().toString()));
                    for (QuasiImportPackage consumer : exportPackage.getConsumers()) {
                        QuasiBundle bundle = consumer.getImportingBundle();
                        lines.add(String.format("        imported by %s", this.formatBundleSummary(bundle)));
                    }
                }
            }
            ArrayList<String> arrayList = lines;
            BundleInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_7);
            return arrayList;
        }
        catch (Throwable throwable) {
            BundleInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_7);
            throw throwable;
        }
    }

    private List<String> formatImportedPackages(ArtifactHolder artifactHolder) {
        try {
            BundleInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_8);
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("");
            lines.add(String.format("Imported Packages:", new Object[0]));
            List<QuasiImportPackage> importPackages = artifactHolder.getImportPackages();
            if (importPackages.isEmpty()) {
                lines.add(String.format("    None", new Object[0]));
            } else {
                for (QuasiImportPackage importPackage : importPackages) {
                    if (!importPackage.isResolved()) continue;
                    lines.add(String.format("    %s %s", importPackage.getPackageName(), importPackage.getVersionConstraint().toString()));
                    QuasiBundle bundle = importPackage.getProvider().getExportingBundle();
                    lines.add(String.format("        exported by %s", this.formatBundleSummary(bundle)));
                }
            }
            ArrayList<String> arrayList = lines;
            BundleInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_8);
            return arrayList;
        }
        catch (Throwable throwable) {
            BundleInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_8);
            throw throwable;
        }
    }

    private String formatBundleSummary(QuasiBundle bundle) {
        try {
            BundleInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_9);
            String string = String.format("%s %s [%s]", bundle.getSymbolicName(), bundle.getVersion(), bundle.getBundleId());
            BundleInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_9);
            return string;
        }
        catch (Throwable throwable) {
            BundleInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_9);
            throw throwable;
        }
    }

    public List<String> formatDiag(QuasiBundle bundle, List<QuasiResolutionFailure> resolverReport) {
        try {
            List<String> list;
            BundleInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_10);
            if (bundle == null) {
                list = Arrays.asList("Unable to locate bundle");
            } else if (resolverReport.size() == 0) {
                list = Arrays.asList("No resolution errors found");
            } else {
                ArrayList<String> lines = new ArrayList<String>();
                for (QuasiResolutionFailure quasiResolutionFailure : resolverReport) {
                    lines.add(String.format("%s", quasiResolutionFailure.getDescription()));
                }
                list = lines;
            }
            BundleInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_10);
            return list;
        }
        catch (Throwable throwable) {
            BundleInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_10);
            throw throwable;
        }
    }

    public List<String> formatHeaders(QuasiBundle bundle) {
        try {
            List<String> list;
            BundleInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_11);
            if (bundle == null) {
                list = Arrays.asList("Unable to locate bundle");
            } else {
                ArrayList<String> lines = new ArrayList<String>();
                Dictionary headers = bundle.getBundle().getHeaders();
                Enumeration keys = headers.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    lines.add(String.format("%s: ", key));
                    lines.addAll(this.formatHeaderValue((String)headers.get(key)));
                }
                list = lines;
            }
            BundleInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_11);
            return list;
        }
        catch (Throwable throwable) {
            BundleInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_11);
            throw throwable;
        }
    }

    private List<ArtifactHolder> getArtifactHolders(List<ManageableArtifact> artifacts) {
        ArrayList<ArtifactHolder> artifactHolders = new ArrayList<ArtifactHolder>(artifacts.size());
        List<QuasiBundle> bundles = this.stateService.getAllBundles(null);
        for (ManageableArtifact artifact : artifacts) {
            ArtifactHolder artifactHolder = this.getArtifactHolder(artifact, bundles);
            if (artifactHolder == null) continue;
            artifactHolders.add(artifactHolder);
        }
        return artifactHolders;
    }

    private ArtifactHolder getArtifactHolder(ManageableArtifact artifact, List<QuasiBundle> bundles) {
        Version v = new Version(artifact.getVersion());
        for (QuasiBundle bundle : bundles) {
            if (!bundle.getSymbolicName().equals(artifact.getName()) || !bundle.getVersion().equals((Object)v)) continue;
            return new ArtifactHolder(artifact, bundle, this.moduleContextAccessor);
        }
        return null;
    }

    private List<String> formatHeaderValue(String value) {
        try {
            BundleInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_12);
            ArrayList<String> lines = new ArrayList<String>();
            StringReader reader = new StringReader(value);
            char[] buffer = new char[71];
            int length = 0;
            try {
                while ((length = reader.read(buffer)) != -1) {
                    lines.add(String.format(" %s", new String(buffer, 0, length)));
                }
            }
            catch (IOException iOException) {}
            ArrayList<String> arrayList = lines;
            BundleInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_12);
            return arrayList;
        }
        catch (Throwable throwable) {
            BundleInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_12);
            throw throwable;
        }
    }

    private static class ArtifactHolder
    implements Comparable<ArtifactHolder> {
        private final ModuleContextAccessor moduleContextAccessor;
        private final ManageableArtifact artifact;
        private final QuasiBundle bundle;
        private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

        public ArtifactHolder(ManageableArtifact artifact, QuasiBundle bundle, ModuleContextAccessor moduleContextAccessor) {
            this.artifact = artifact;
            this.bundle = bundle;
            this.moduleContextAccessor = moduleContextAccessor;
        }

        public Long getId() {
            return this.bundle.getBundleId();
        }

        public String getName() {
            return this.artifact.getName();
        }

        public String getState() {
            return this.artifact.getState();
        }

        public String getVersion() {
            return this.artifact.getVersion();
        }

        public String getBundleLocation() {
            return this.bundle.getBundle().getLocation();
        }

        public boolean getSpringPowered() {
            ModuleContext moduleContext;
            Bundle realBundle = this.bundle.getBundle();
            return realBundle != null && (moduleContext = this.moduleContextAccessor.getModuleContext(realBundle)) != null;
        }

        public List<QuasiExportPackage> getExportPackages() {
            return this.bundle.getExportPackages();
        }

        public List<QuasiImportPackage> getImportPackages() {
            return this.bundle.getImportPackages();
        }

        public List<QuasiBundle> getFragments() {
            return this.bundle.getFragments();
        }

        public List<QuasiBundle> getHosts() {
            return this.bundle.getHosts();
        }

        public List<QuasiLiveService> getPublishedServices() {
            QuasiLiveBundle liveBundle = (QuasiLiveBundle)this.bundle;
            return liveBundle.getExportedServices();
        }

        public List<QuasiLiveService> getConsumedServices() {
            QuasiLiveBundle liveBundle = (QuasiLiveBundle)this.bundle;
            return liveBundle.getImportedServices();
        }

        @Override
        public int compareTo(ArtifactHolder o) {
            try {
                ArtifactHolder.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                int n = this.getId().compareTo(o.getId());
                ArtifactHolder.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                return n;
            }
            catch (Throwable throwable) {
                ArtifactHolder.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                throw throwable;
            }
        }

        public int hashCode() {
            try {
                ArtifactHolder.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
                int n = this.getId().hashCode();
                ArtifactHolder.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
                return n;
            }
            catch (Throwable throwable) {
                ArtifactHolder.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
                throw throwable;
            }
        }

        public boolean equals(Object obj) {
            try {
                ArtifactHolder.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_2);
                boolean bl = this.getId().equals(((ArtifactHolder)obj).getId());
                ArtifactHolder.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_2);
                return bl;
            }
            catch (Throwable throwable) {
                ArtifactHolder.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_2);
                throw throwable;
            }
        }

        static {
            Factory factory = new Factory("BundleInstallArtifactCommandFormatter.java", Class.forName("org.eclipse.virgo.kernel.shell.internal.formatting.BundleInstallArtifactCommandFormatter$ArtifactHolder"));
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "compareTo", "org.eclipse.virgo.kernel.shell.internal.formatting.BundleInstallArtifactCommandFormatter$ArtifactHolder", "org.eclipse.virgo.kernel.shell.internal.formatting.BundleInstallArtifactCommandFormatter$ArtifactHolder:", "o:", "", "int"), 421);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "hashCode", "org.eclipse.virgo.kernel.shell.internal.formatting.BundleInstallArtifactCommandFormatter$ArtifactHolder", "", "", "", "int"), 426);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "equals", "org.eclipse.virgo.kernel.shell.internal.formatting.BundleInstallArtifactCommandFormatter$ArtifactHolder", "java.lang.Object:", "obj:", "", "boolean"), 431);
            ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.shell.internal.formatting.BundleInstallArtifactCommandFormatter$ArtifactHolder");
        }
    }
}

