/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.medic.log.osgi;

import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;
import org.slf4j.Logger;

public class OSGiLogServiceImpl
implements LogService {
    private final Logger logger;

    public OSGiLogServiceImpl(Logger logger) {
        this.logger = logger;
    }

    public void log(int level, String message) {
        switch (level) {
            case 4: {
                this.logger.debug(message);
                break;
            }
            case 3: {
                this.logger.info(message);
                break;
            }
            case 2: {
                this.logger.warn(message);
                break;
            }
            case 1: {
                this.logger.error(message);
                break;
            }
            default: {
                this.logger.error(String.format("Log Message of unknown severity %d: %s", level, message));
            }
        }
    }

    public void log(int level, String message, Throwable exception) {
        switch (level) {
            case 4: {
                this.logger.debug(message, exception);
                break;
            }
            case 3: {
                this.logger.info(message, exception);
                break;
            }
            case 2: {
                this.logger.warn(message, exception);
                break;
            }
            case 1: {
                this.logger.error(message, exception);
                break;
            }
            default: {
                this.logger.error(String.format("Log Message of unknown severity %d: %s", level, message), exception);
            }
        }
    }

    public void log(ServiceReference sr, int level, String message) {
        this.log(level, String.format("{Service %s}: %s", this.getServiceDescription(sr), message));
    }

    public void log(ServiceReference sr, int level, String message, Throwable exception) {
        this.log(level, String.format("{Service %s}: %s", this.getServiceDescription(sr), message), exception);
    }

    private String getServiceDescription(ServiceReference<?> sr) {
        return sr.getProperty("service.id").toString();
    }
}

