/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.deployer.core.internal;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.core.KernelException;
import org.eclipse.virgo.kernel.deployer.core.ApplicationDeployer;
import org.eclipse.virgo.kernel.deployer.core.DeployUriNormaliser;
import org.eclipse.virgo.kernel.deployer.core.DeployerConfiguration;
import org.eclipse.virgo.kernel.deployer.core.DeployerLogEvents;
import org.eclipse.virgo.kernel.deployer.core.DeploymentException;
import org.eclipse.virgo.kernel.deployer.core.DeploymentIdentity;
import org.eclipse.virgo.kernel.deployer.core.DeploymentOptions;
import org.eclipse.virgo.kernel.deployer.core.internal.ApplicationRecoverer;
import org.eclipse.virgo.kernel.deployer.core.internal.BlockingAbortableSignal;
import org.eclipse.virgo.kernel.deployer.core.internal.StandardDeploymentIdentity;
import org.eclipse.virgo.kernel.deployer.core.internal.event.DeploymentListener;
import org.eclipse.virgo.kernel.deployer.model.DuplicateDeploymentIdentityException;
import org.eclipse.virgo.kernel.deployer.model.DuplicateFileNameException;
import org.eclipse.virgo.kernel.deployer.model.DuplicateLocationException;
import org.eclipse.virgo.kernel.deployer.model.RuntimeArtifactModel;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifactTreeInclosure;
import org.eclipse.virgo.kernel.install.artifact.PlanInstallArtifact;
import org.eclipse.virgo.kernel.install.environment.InstallEnvironment;
import org.eclipse.virgo.kernel.install.environment.InstallEnvironmentFactory;
import org.eclipse.virgo.kernel.install.pipeline.Pipeline;
import org.eclipse.virgo.kernel.osgi.framework.UnableToSatisfyBundleDependenciesException;
import org.eclipse.virgo.kernel.osgi.framework.UnableToSatisfyDependenciesException;
import org.eclipse.virgo.kernel.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.repository.Repository;
import org.eclipse.virgo.repository.WatchableRepository;
import org.eclipse.virgo.util.common.Tree;
import org.eclipse.virgo.util.io.PathReference;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

final class PipelinedApplicationDeployer
implements ApplicationDeployer,
ApplicationRecoverer {
    private static final String BUNDLE_TYPE = "bundle";
    private final EventLogger eventLogger;
    private final Object monitor;
    private final InstallEnvironmentFactory installEnvironmentFactory;
    private final InstallArtifactTreeInclosure installArtifactTreeInclosure;
    private final RuntimeArtifactModel ram;
    private final DeploymentListener deploymentListener;
    private final Map<DeploymentIdentity, DeploymentOptions> deploymentOptionsMap;
    private final Pipeline pipeline;
    private final DeployUriNormaliser deployUriNormaliser;
    private final int deployerConfiguredTimeoutInSeconds;
    private final BundleContext bundleContext;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_26;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_27;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_28;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_29;

    public PipelinedApplicationDeployer(Pipeline pipeline, InstallArtifactTreeInclosure installArtifactTreeInclosure, InstallEnvironmentFactory installEnvironmentFactory, RuntimeArtifactModel ram, DeploymentListener deploymentListener, EventLogger eventLogger, DeployUriNormaliser normaliser, DeployerConfiguration deployerConfiguration, BundleContext bundleContext) {
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.monitor = new Object();
            this.deploymentOptionsMap = new HashMap<DeploymentIdentity, DeploymentOptions>();
            this.eventLogger = eventLogger;
            this.installArtifactTreeInclosure = installArtifactTreeInclosure;
            this.installEnvironmentFactory = installEnvironmentFactory;
            this.ram = ram;
            this.deploymentListener = deploymentListener;
            this.deployUriNormaliser = normaliser;
            this.bundleContext = bundleContext;
            this.pipeline = pipeline;
            this.deployerConfiguredTimeoutInSeconds = deployerConfiguration.getDeploymentTimeoutSeconds();
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeploymentIdentity deploy(URI location) throws DeploymentException {
        try {
            try {
                DeploymentIdentity deploymentIdentity;
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                Object object = this.monitor;
                synchronized (object) {
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
                    deploymentIdentity = this.deploy(location, new DeploymentOptions());
                }
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                return deploymentIdentity;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private URI normaliseDeploymentUri(URI uri) throws DeploymentException {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
                URI normalisedLocation = this.deployUriNormaliser.normalise(uri);
                if (normalisedLocation == null) {
                    this.eventLogger.log((LogEvent)DeployerLogEvents.UNSUPPORTED_URI_SCHEME, new Object[]{uri, uri.getScheme()});
                    throw new DeploymentException("PipelinedApplicationDeployer.deploy does not support '" + uri.getScheme() + "' scheme URIs");
                }
                URI uRI = normalisedLocation;
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
                return uRI;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public DeploymentIdentity install(URI location) throws DeploymentException {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_2);
                DeploymentIdentity deploymentIdentity = this.install(location, new DeploymentOptions());
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_2);
                return deploymentIdentity;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_2);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public DeploymentIdentity install(URI uri, DeploymentOptions deploymentOptions) throws DeploymentException {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_3);
                URI normalisedUri = this.normaliseDeploymentUri(uri);
                DeploymentIdentity deploymentIdentity = this.doInstall(normalisedUri, deploymentOptions);
                this.deploymentListener.deployed(normalisedUri, deploymentOptions);
                DeploymentIdentity deploymentIdentity2 = deploymentIdentity;
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_3);
                return deploymentIdentity2;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_3);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeploymentIdentity doInstall(URI normalisedUri, DeploymentOptions deploymentOptions) throws DeploymentException {
        try {
            try {
                DeploymentIdentity deploymentIdentity;
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
                Object object = this.monitor;
                synchronized (object) {
                    DeploymentIdentity deploymentIdentity2;
                    block13: {
                        DeploymentIdentity refreshedIdentity;
                        InstallArtifact existingArtifact = this.ram.get(normalisedUri);
                        if (existingArtifact == null || (refreshedIdentity = this.updateAndRefreshExistingArtifact(normalisedUri, existingArtifact)) == null) break block13;
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 6] lbl9 : MonitorExitStatement: MONITOREXIT : var3_3
                        deploymentIdentity = refreshedIdentity;
                    }
                    Tree<InstallArtifact> installTree = this.installArtifactTreeInclosure.createInstallTree(new File(normalisedUri));
                    try {
                        deploymentIdentity2 = this.addTreeToModel(normalisedUri, installTree);
                    }
                    catch (KernelException ke) {
                        throw new DeploymentException(ke.getMessage(), ke);
                    }
                    this.deploymentOptionsMap.put(deploymentIdentity2, deploymentOptions);
                    try {
                        this.driveInstallPipeline(normalisedUri, installTree);
                    }
                    catch (DeploymentException de) {
                        this.ram.delete(deploymentIdentity2);
                        throw de;
                    }
                    catch (RuntimeException re) {
                        this.ram.delete(deploymentIdentity2);
                        throw re;
                    }
                    deploymentIdentity = deploymentIdentity2;
                }
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
                return deploymentIdentity;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private DeploymentIdentity updateAndRefreshExistingArtifact(URI normalisedLocation, InstallArtifact existingArtifact) throws DeploymentException {
        try {
            try {
                DeploymentIdentity deploymentIdentity;
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_5);
                String oldType = existingArtifact.getType();
                String oldName = existingArtifact.getName();
                Version oldVersion = existingArtifact.getVersion();
                DeploymentIdentity deploymentIdentity2 = this.updateAndRefresh(normalisedLocation, existingArtifact);
                if (deploymentIdentity2 != null) {
                    deploymentIdentity = deploymentIdentity2;
                } else {
                    StandardDeploymentIdentity oldDeploymentIdentity = new StandardDeploymentIdentity(oldType, oldName, oldVersion.toString());
                    this.undeployInternal(oldDeploymentIdentity, true, false);
                    deploymentIdentity = null;
                }
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_5);
                return deploymentIdentity;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_5);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeploymentIdentity deploy(URI location, DeploymentOptions deploymentOptions) throws DeploymentException {
        try {
            try {
                InstallArtifact installedArtifact;
                DeploymentIdentity deploymentIdentity;
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_6);
                URI normalisedLocation = this.normaliseDeploymentUri(location);
                Object object = this.monitor;
                synchronized (object) {
                    deploymentIdentity = this.install(location, deploymentOptions);
                    installedArtifact = this.ram.get(normalisedLocation);
                }
                try {
                    this.start(installedArtifact, deploymentOptions.getSynchronous());
                }
                catch (DeploymentException de) {
                    Object object2 = this.monitor;
                    synchronized (object2) {
                        this.stopArtifact(installedArtifact);
                        this.uninstallArtifact(installedArtifact);
                    }
                    throw de;
                }
                this.deploymentListener.deployed(normalisedLocation, deploymentOptions);
                DeploymentIdentity deploymentIdentity2 = deploymentIdentity;
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_6);
                return deploymentIdentity2;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_6);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private DeploymentIdentity updateAndRefresh(URI location, InstallArtifact installArtifact) throws DeploymentException {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_7);
                StandardDeploymentIdentity deploymentIdentity = null;
                this.installArtifactTreeInclosure.updateStagingArea(new File(location), new ArtifactIdentity(installArtifact.getType(), installArtifact.getName(), installArtifact.getVersion(), installArtifact.getScopeName()));
                if (installArtifact.refresh()) {
                    this.deploymentListener.refreshed(location);
                    deploymentIdentity = new StandardDeploymentIdentity(installArtifact.getType(), installArtifact.getName(), installArtifact.getVersion().toString());
                }
                StandardDeploymentIdentity standardDeploymentIdentity = deploymentIdentity;
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_7);
                return standardDeploymentIdentity;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_7);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DeploymentIdentity deploy(String type, String name, Version version) throws DeploymentException {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_8);
                throw new UnsupportedOperationException("PipelinedApplicationDeployer ApplicationDeployer does not support deployment by type, name, and version");
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_8);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DeploymentIdentity deploy(String type, String name, Version version, DeploymentOptions options) throws DeploymentException {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_9);
                throw new UnsupportedOperationException("PipelinedApplicationDeployer ApplicationDeployer does not support deployment by type, name, and version");
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_9);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private DeploymentIdentity addTreeToModel(URI location, Tree<InstallArtifact> installTree) throws DuplicateFileNameException, DuplicateLocationException, DuplicateDeploymentIdentityException, DeploymentException {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_10);
                DeploymentIdentity deploymentIdentity = this.ram.add(location, (InstallArtifact)installTree.getValue());
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_10);
                return deploymentIdentity;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_10);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void recoverDeployment(URI uri, DeploymentOptions options) throws DeploymentException {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_11);
                Tree<InstallArtifact> installTree = this.installArtifactTreeInclosure.recoverInstallTree(new File(uri), options);
                if (installTree == null) {
                    this.deploymentListener.undeployed(uri);
                } else {
                    this.driveInstallPipeline(uri, installTree);
                    this.start((InstallArtifact)installTree.getValue(), options.getSynchronous());
                    try {
                        this.addTreeToModel(uri, installTree);
                    }
                    catch (KernelException e) {
                        throw new DeploymentException(e.getMessage(), e);
                    }
                }
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_11);
                return;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_11);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void driveInstallPipeline(URI uri, Tree<InstallArtifact> installTree) throws DeploymentException {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_12);
                this.refreshWatchedRepositories();
                InstallEnvironment installEnvironment = this.installEnvironmentFactory.createInstallEnvironment((InstallArtifact)installTree.getValue());
                try {
                    try {
                        this.pipeline.process(installTree, installEnvironment);
                    }
                    catch (UnableToSatisfyBundleDependenciesException utsbde) {
                        this.logDependencySatisfactionException(uri, (UnableToSatisfyDependenciesException)((Object)utsbde));
                        throw new DeploymentException("Dependency satisfaction failed", utsbde);
                    }
                }
                finally {
                    installEnvironment.destroy();
                }
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_12);
                return;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_12);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void logDependencySatisfactionException(URI uri, UnableToSatisfyDependenciesException ex) {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_13);
                this.eventLogger.log((LogEvent)DeployerLogEvents.UNABLE_TO_SATISFY_CONSTRAINTS, (Throwable)ex, new Object[]{uri, ex.getSymbolicName(), ex.getVersion(), ex.getFailureDescription()});
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_13);
                return;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_13);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void start(InstallArtifact installArtifact, boolean synchronous) throws DeploymentException {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_14);
                BlockingAbortableSignal blockingSignal = new BlockingAbortableSignal(synchronous);
                installArtifact.start(blockingSignal);
                if (synchronous && this.deployerConfiguredTimeoutInSeconds > 0) {
                    boolean complete = blockingSignal.awaitCompletion(this.deployerConfiguredTimeoutInSeconds);
                    if (blockingSignal.isAborted()) {
                        this.eventLogger.log((LogEvent)DeployerLogEvents.START_ABORTED, new Object[]{installArtifact.getType(), installArtifact.getName(), installArtifact.getVersion(), this.deployerConfiguredTimeoutInSeconds});
                    } else if (!complete) {
                        this.eventLogger.log((LogEvent)DeployerLogEvents.START_TIMED_OUT, new Object[]{installArtifact.getType(), installArtifact.getName(), installArtifact.getVersion()});
                    }
                } else {
                    blockingSignal.checkComplete();
                }
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_14);
                return;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_14);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeploymentIdentity[] getDeploymentIdentities() {
        try {
            Object object = this.monitor;
            synchronized (object) {
                return this.ram.getDeploymentIdentities();
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeploymentIdentity getDeploymentIdentity(URI location) {
        try {
            Object object = this.monitor;
            synchronized (object) {
                InstallArtifact installArtifact = this.ram.get(location);
                if (installArtifact != null) {
                    return this.getDeploymentIdentity(installArtifact);
                }
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private DeploymentIdentity getDeploymentIdentity(InstallArtifact installArtifact) {
        try {
            return new StandardDeploymentIdentity(installArtifact.getType(), installArtifact.getName(), installArtifact.getVersion().toString());
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isDeployed(URI location) {
        try {
            try {
                boolean bl;
                block11: {
                    URI normalisedLocation;
                    PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_15);
                    try {
                        normalisedLocation = this.deployUriNormaliser.normalise(location);
                    }
                    catch (DeploymentException deploymentException) {
                        bl = false;
                        break block11;
                    }
                    if (normalisedLocation == null) {
                        this.eventLogger.log((LogEvent)DeployerLogEvents.UNSUPPORTED_URI_SCHEME, new Object[]{location.toString(), location.getScheme()});
                        bl = false;
                    } else {
                        boolean bl2;
                        Object object = this.monitor;
                        synchronized (object) {
                            bl2 = this.ram.get(normalisedLocation) != null;
                        }
                        bl = bl2;
                    }
                }
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_15);
                return bl;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_15);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeploymentIdentity refresh(URI location, String symbolicName) throws DeploymentException {
        try {
            try {
                DeploymentIdentity deploymentIdentity;
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_16);
                URI normalisedLocation = this.deployUriNormaliser.normalise(location);
                if (normalisedLocation == null) {
                    this.eventLogger.log((LogEvent)DeployerLogEvents.UNSUPPORTED_URI_SCHEME, new Object[]{location.toString(), location.getScheme()});
                    throw new DeploymentException("PipelinedApplicationDeployer.refresh does not support '" + location.getScheme() + "' scheme URIs");
                }
                Object object = this.monitor;
                synchronized (object) {
                    DeploymentIdentity originalDeploymentIdentity;
                    InstallArtifact installArtifact = this.ram.get(normalisedLocation);
                    if (installArtifact == null) {
                        this.eventLogger.log((LogEvent)DeployerLogEvents.REFRESH_REQUEST_URI_NOT_FOUND, new Object[]{location.toString()});
                        throw new DeploymentException("Refresh not possible as no application is deployed from URI " + location);
                    }
                    deploymentIdentity = originalDeploymentIdentity = this.getDeploymentIdentity(installArtifact);
                    try {
                        this.installArtifactTreeInclosure.updateStagingArea(new File(normalisedLocation), new ArtifactIdentity(installArtifact.getType(), installArtifact.getName(), installArtifact.getVersion(), installArtifact.getScopeName()));
                        if (this.refreshInternal(symbolicName, installArtifact)) {
                            this.deploymentListener.refreshed(normalisedLocation);
                        } else {
                            DeploymentOptions deploymentOptions = this.deploymentOptionsMap.get(deploymentIdentity);
                            if (deploymentOptions == null) {
                                deploymentOptions = DeploymentOptions.DEFAULT_DEPLOYMENT_OPTIONS;
                            }
                            deploymentIdentity = this.redeploy(originalDeploymentIdentity, normalisedLocation, deploymentOptions);
                        }
                        this.eventLogger.log((LogEvent)DeployerLogEvents.REFRESH_REQUEST_COMPLETED, new Object[]{symbolicName, originalDeploymentIdentity.getType(), originalDeploymentIdentity.getSymbolicName(), originalDeploymentIdentity.getVersion()});
                    }
                    catch (RuntimeException e) {
                        this.eventLogger.log((LogEvent)DeployerLogEvents.REFRESH_REQUEST_FAILED, (Throwable)e, new Object[]{symbolicName, originalDeploymentIdentity.getType(), originalDeploymentIdentity.getSymbolicName(), originalDeploymentIdentity.getVersion()});
                        throw e;
                    }
                    catch (Exception e) {
                        this.eventLogger.log((LogEvent)DeployerLogEvents.REFRESH_REQUEST_FAILED, (Throwable)e, new Object[]{symbolicName, originalDeploymentIdentity.getType(), originalDeploymentIdentity.getSymbolicName(), originalDeploymentIdentity.getVersion()});
                        throw new DeploymentException("refresh failed", e);
                    }
                }
                DeploymentIdentity deploymentIdentity2 = deploymentIdentity;
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_16);
                return deploymentIdentity2;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_16);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private boolean refreshInternal(String symbolicName, InstallArtifact installArtifact) throws DeploymentException {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_17);
                boolean bl = installArtifact instanceof PlanInstallArtifact ? ((PlanInstallArtifact)installArtifact).refresh(symbolicName) : installArtifact.refresh();
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_17);
                return bl;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_17);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeploymentIdentity redeploy(DeploymentIdentity toUndeploy, URI toDeploy, DeploymentOptions deploymentOptions) throws DeploymentException {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_18);
                Object object = this.monitor;
                synchronized (object) {
                    this.undeployInternal(toUndeploy, true, false);
                }
                DeploymentIdentity deploymentIdentity = this.deploy(toDeploy, deploymentOptions);
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_18);
                return deploymentIdentity;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_18);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshBundle(String bundleSymbolicName, String bundleVersion) throws DeploymentException {
        try {
            try {
                InstallArtifact bundleInstallArtifact;
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_19);
                StandardDeploymentIdentity deploymentIdentity = new StandardDeploymentIdentity(BUNDLE_TYPE, bundleSymbolicName, bundleVersion);
                Object object = this.monitor;
                synchronized (object) {
                    bundleInstallArtifact = this.ram.get(deploymentIdentity);
                }
                if (bundleInstallArtifact == null) {
                    this.eventLogger.log((LogEvent)DeployerLogEvents.REFRESH_ARTEFACT_NOT_FOUND, new Object[]{BUNDLE_TYPE, bundleSymbolicName, bundleVersion});
                    throw new DeploymentException("Refresh not possible as no bundle with name " + bundleSymbolicName + " and version " + bundleVersion + " is deployed");
                }
                bundleInstallArtifact.refresh();
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_19);
                return;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_19);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void undeploy(String symbolicName, String version) throws DeploymentException {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_20);
                DeploymentException de = null;
                try {
                    this.undeploy(BUNDLE_TYPE, symbolicName, version);
                }
                catch (DeploymentException e) {
                    de = e;
                    try {
                        this.undeploy("par", symbolicName, version);
                    }
                    catch (DeploymentException e2) {
                        de = e2;
                        try {
                            this.undeploy("plan", symbolicName, version);
                        }
                        catch (DeploymentException e3) {
                            de = e3;
                            try {
                                this.undeploy("properties", symbolicName, version);
                            }
                            catch (DeploymentException e4) {
                                de = e4;
                                throw de;
                            }
                        }
                    }
                }
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_20);
                return;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_20);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undeploy(String type, String symbolicName, String version) throws DeploymentException {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_21);
                StandardDeploymentIdentity deploymentIdentity = new StandardDeploymentIdentity(type, symbolicName, version);
                Object object = this.monitor;
                synchronized (object) {
                    this.undeployInternal(deploymentIdentity, false, false);
                }
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_21);
                return;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_21);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undeploy(DeploymentIdentity deploymentIdentity) throws DeploymentException {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_22);
                Object object = this.monitor;
                synchronized (object) {
                    this.undeployInternal(deploymentIdentity, false, false);
                }
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_22);
                return;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_22);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undeploy(DeploymentIdentity deploymentIdentity, boolean deleted) throws DeploymentException {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_23);
                Object object = this.monitor;
                synchronized (object) {
                    this.undeployInternal(deploymentIdentity, false, true);
                }
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_23);
                return;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_23);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void undeployInternal(DeploymentIdentity deploymentIdentity, boolean redeploying, boolean deleted) throws DeploymentException {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_24);
                DeploymentOptions options = this.deploymentOptionsMap.remove(deploymentIdentity);
                URI location = this.doUndeploy(deploymentIdentity);
                if (!redeploying) {
                    this.deleteArtifactIfNecessary(location, options, deleted);
                }
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_24);
                return;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_24);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void deleteArtifactIfNecessary(URI location, DeploymentOptions options, boolean deleted) {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_25);
                if (options != null && options.getDeployerOwned() && !deleted) {
                    new PathReference(location).delete(true);
                }
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_25);
                return;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_25);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URI doUndeploy(DeploymentIdentity deploymentIdentity) throws DeploymentException {
        try {
            try {
                URI uRI;
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_26);
                Object object = this.monitor;
                synchronized (object) {
                    InstallArtifact installArtifact = this.ram.get(deploymentIdentity);
                    if (installArtifact == null) {
                        String type = deploymentIdentity.getType();
                        String symbolicName = deploymentIdentity.getSymbolicName();
                        String version = deploymentIdentity.getVersion();
                        this.eventLogger.log((LogEvent)DeployerLogEvents.UNDEPLOY_ARTEFACT_NOT_FOUND, new Object[]{type, symbolicName, version});
                        throw new DeploymentException("Undeploy not possible as no " + type + " with name " + symbolicName + " and version " + version + " is deployed");
                    }
                    URI location = this.ram.getLocation(deploymentIdentity);
                    this.stopArtifact(installArtifact);
                    this.uninstallArtifact(installArtifact);
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3] lbl17 : MonitorExitStatement: MONITOREXIT : var2_2
                    uRI = location;
                }
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_26);
                return uRI;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_26);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void stopArtifact(InstallArtifact installArtifact) throws DeploymentException {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_27);
                installArtifact.stop();
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_27);
                return;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_27);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void uninstallArtifact(InstallArtifact installArtifact) throws DeploymentException {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_28);
                installArtifact.uninstall();
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_28);
                return;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_28);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void refreshWatchedRepositories() {
        try {
            try {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_29);
                try {
                    Collection references = this.bundleContext.getServiceReferences(WatchableRepository.class, null);
                    for (ServiceReference reference : references) {
                        WatchableRepository watchableRepository = (WatchableRepository)this.bundleContext.getService(reference);
                        try {
                            watchableRepository.forceCheck();
                        }
                        catch (Exception exception) {
                            String name = watchableRepository instanceof Repository ? ((Repository)watchableRepository).getName() : "unknown repository type";
                            this.eventLogger.log((LogEvent)DeployerLogEvents.WATCHED_REPOSITORY_REFRESH_FAILED, new Object[]{name});
                        }
                        this.bundleContext.ungetService(reference);
                    }
                }
                catch (InvalidSyntaxException invalidSyntaxException) {
                    this.eventLogger.log((LogEvent)DeployerLogEvents.WATCHED_REPOSITORIES_REFRESH_FAILED, new Object[0]);
                }
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_29);
                return;
            }
            catch (Throwable throwable) {
                PipelinedApplicationDeployer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_29);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static {
        Factory factory = new Factory("PipelinedApplicationDeployer.java", Class.forName("org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deploy", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "java.net.URI:", "location:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "org.eclipse.virgo.kernel.deployer.core.DeploymentIdentity"), 113);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "normaliseDeploymentUri", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "java.net.URI:", "uri:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "java.net.URI"), 119);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "addTreeToModel", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "java.net.URI:org.eclipse.virgo.util.common.Tree:", "location:installTree:", "org.eclipse.virgo.kernel.deployer.model.DuplicateFileNameException:org.eclipse.virgo.kernel.deployer.model.DuplicateLocationException:org.eclipse.virgo.kernel.deployer.model.DuplicateDeploymentIdentityException:org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "org.eclipse.virgo.kernel.deployer.core.DeploymentIdentity"), 253);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "recoverDeployment", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "java.net.URI:org.eclipse.virgo.kernel.deployer.core.DeploymentOptions:", "uri:options:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 261);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "driveInstallPipeline", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "java.net.URI:org.eclipse.virgo.util.common.Tree:", "uri:installTree:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 281);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "logDependencySatisfactionException", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "java.net.URI:org.eclipse.virgo.kernel.osgi.framework.UnableToSatisfyDependenciesException:", "uri:ex:", "", "void"), 295);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "start", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "org.eclipse.virgo.kernel.install.artifact.InstallArtifact:boolean:", "installArtifact:synchronous:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 300);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isDeployed", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "java.net.URI:", "location:", "", "boolean"), 347);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "refresh", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "java.net.URI:java.lang.String:", "location:symbolicName:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "org.eclipse.virgo.kernel.deployer.core.DeploymentIdentity"), 365);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "refreshInternal", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "java.lang.String:org.eclipse.virgo.kernel.install.artifact.InstallArtifact:", "symbolicName:installArtifact:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "boolean"), 411);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "redeploy", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "org.eclipse.virgo.kernel.deployer.core.DeploymentIdentity:java.net.URI:org.eclipse.virgo.kernel.deployer.core.DeploymentOptions:", "toUndeploy:toDeploy:deploymentOptions:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "org.eclipse.virgo.kernel.deployer.core.DeploymentIdentity"), 419);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "refreshBundle", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "java.lang.String:java.lang.String:", "bundleSymbolicName:bundleVersion:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 429);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "install", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "java.net.URI:", "location:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "org.eclipse.virgo.kernel.deployer.core.DeploymentIdentity"), 130);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "undeploy", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "java.lang.String:java.lang.String:", "symbolicName:version:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 448);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "undeploy", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "java.lang.String:java.lang.String:java.lang.String:", "type:symbolicName:version:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 485);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "undeploy", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "org.eclipse.virgo.kernel.deployer.core.DeploymentIdentity:", "deploymentIdentity:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 495);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "undeploy", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "org.eclipse.virgo.kernel.deployer.core.DeploymentIdentity:boolean:", "deploymentIdentity:deleted:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 504);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "undeployInternal", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "org.eclipse.virgo.kernel.deployer.core.DeploymentIdentity:boolean:boolean:", "deploymentIdentity:redeploying:deleted:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 525);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "deleteArtifactIfNecessary", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "java.net.URI:org.eclipse.virgo.kernel.deployer.core.DeploymentOptions:boolean:", "location:options:deleted:", "", "void"), 533);
        ajc$tjp_26 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "doUndeploy", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "org.eclipse.virgo.kernel.deployer.core.DeploymentIdentity:", "deploymentIdentity:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "java.net.URI"), 539);
        ajc$tjp_27 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "stopArtifact", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "org.eclipse.virgo.kernel.install.artifact.InstallArtifact:", "installArtifact:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 560);
        ajc$tjp_28 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "uninstallArtifact", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "org.eclipse.virgo.kernel.install.artifact.InstallArtifact:", "installArtifact:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 565);
        ajc$tjp_29 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "refreshWatchedRepositories", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "", "", "", "void"), 570);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "install", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "java.net.URI:org.eclipse.virgo.kernel.deployer.core.DeploymentOptions:", "uri:deploymentOptions:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "org.eclipse.virgo.kernel.deployer.core.DeploymentIdentity"), 134);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "doInstall", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "java.net.URI:org.eclipse.virgo.kernel.deployer.core.DeploymentOptions:", "normalisedUri:deploymentOptions:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "org.eclipse.virgo.kernel.deployer.core.DeploymentIdentity"), 143);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "updateAndRefreshExistingArtifact", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "java.net.URI:org.eclipse.virgo.kernel.install.artifact.InstallArtifact:", "normalisedLocation:existingArtifact:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "org.eclipse.virgo.kernel.deployer.core.DeploymentIdentity"), 178);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deploy", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "java.net.URI:org.eclipse.virgo.kernel.deployer.core.DeploymentOptions:", "location:deploymentOptions:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "org.eclipse.virgo.kernel.deployer.core.DeploymentIdentity"), 197);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "updateAndRefresh", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "java.net.URI:org.eclipse.virgo.kernel.install.artifact.InstallArtifact:", "location:installArtifact:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "org.eclipse.virgo.kernel.deployer.core.DeploymentIdentity"), 223);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deploy", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "java.lang.String:java.lang.String:org.osgi.framework.Version:", "type:name:version:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "org.eclipse.virgo.kernel.deployer.core.DeploymentIdentity"), 239);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deploy", "org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer", "java.lang.String:java.lang.String:org.osgi.framework.Version:org.eclipse.virgo.kernel.deployer.core.DeploymentOptions:", "type:name:version:options:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "org.eclipse.virgo.kernel.deployer.core.DeploymentIdentity"), 247);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.deployer.core.internal.PipelinedApplicationDeployer");
    }
}

