/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.DefaultsDescriptor;
import org.eclipse.jetty.webapp.Descriptor;
import org.eclipse.jetty.webapp.DescriptorProcessor;
import org.eclipse.jetty.webapp.DiscoveredAnnotation;
import org.eclipse.jetty.webapp.FragmentDescriptor;
import org.eclipse.jetty.webapp.MetaDataComplete;
import org.eclipse.jetty.webapp.Ordering;
import org.eclipse.jetty.webapp.Origin;
import org.eclipse.jetty.webapp.OverrideDescriptor;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaData {
    public static final String ORDERED_LIBS = "javax.servlet.context.orderedLibs";
    protected Map<String, OriginInfo> _origins = new HashMap<String, OriginInfo>();
    protected WebDescriptor _webDefaultsRoot;
    protected WebDescriptor _webXmlRoot;
    protected final List<WebDescriptor> _webOverrideRoots = new ArrayList<WebDescriptor>();
    protected boolean _metaDataComplete;
    protected final List<DiscoveredAnnotation> _annotations = new ArrayList<DiscoveredAnnotation>();
    protected final List<DescriptorProcessor> _descriptorProcessors = new ArrayList<DescriptorProcessor>();
    protected final List<FragmentDescriptor> _webFragmentRoots = new ArrayList<FragmentDescriptor>();
    protected final Map<String, FragmentDescriptor> _webFragmentNameMap = new HashMap<String, FragmentDescriptor>();
    protected final Map<Resource, FragmentDescriptor> _webFragmentResourceMap = new HashMap<Resource, FragmentDescriptor>();
    protected final Map<Resource, List<DiscoveredAnnotation>> _webFragmentAnnotations = new HashMap<Resource, List<DiscoveredAnnotation>>();
    protected final List<Resource> _webInfJars = new ArrayList<Resource>();
    protected final List<Resource> _orderedWebInfJars = new ArrayList<Resource>();
    protected final List<Resource> _orderedContainerJars = new ArrayList<Resource>();
    protected Ordering _ordering;
    protected boolean allowDuplicateFragmentNames = false;

    public void clear() {
        this._webDefaultsRoot = null;
        this._origins.clear();
        this._webXmlRoot = null;
        this._webOverrideRoots.clear();
        this._metaDataComplete = false;
        this._annotations.clear();
        this._descriptorProcessors.clear();
        this._webFragmentRoots.clear();
        this._webFragmentNameMap.clear();
        this._webFragmentResourceMap.clear();
        this._webFragmentAnnotations.clear();
        this._webInfJars.clear();
        this._orderedWebInfJars.clear();
        this._orderedContainerJars.clear();
        this._ordering = null;
        this.allowDuplicateFragmentNames = false;
    }

    public void setDefaults(Resource webDefaults) throws Exception {
        this._webDefaultsRoot = new DefaultsDescriptor(webDefaults);
        this._webDefaultsRoot.parse();
        if (this._webDefaultsRoot.isOrdered()) {
            if (this._ordering == null) {
                this._ordering = new Ordering.AbsoluteOrdering(this);
            }
            List<String> order = this._webDefaultsRoot.getOrdering();
            for (String s : order) {
                if (s.equalsIgnoreCase("others")) {
                    ((Ordering.AbsoluteOrdering)this._ordering).addOthers();
                    continue;
                }
                ((Ordering.AbsoluteOrdering)this._ordering).add(s);
            }
        }
    }

    public void setWebXml(Resource webXml) throws Exception {
        this._webXmlRoot = new WebDescriptor(webXml);
        this._webXmlRoot.parse();
        boolean bl = this._metaDataComplete = this._webXmlRoot.getMetaDataComplete() == MetaDataComplete.True;
        if (this._webXmlRoot.isOrdered()) {
            if (this._ordering == null) {
                this._ordering = new Ordering.AbsoluteOrdering(this);
            }
            List<String> order = this._webXmlRoot.getOrdering();
            for (String s : order) {
                if (s.equalsIgnoreCase("others")) {
                    ((Ordering.AbsoluteOrdering)this._ordering).addOthers();
                    continue;
                }
                ((Ordering.AbsoluteOrdering)this._ordering).add(s);
            }
        }
    }

    public void addOverride(Resource override) throws Exception {
        OverrideDescriptor webOverrideRoot = new OverrideDescriptor(override);
        webOverrideRoot.setValidating(false);
        webOverrideRoot.parse();
        switch (webOverrideRoot.getMetaDataComplete()) {
            case True: {
                this._metaDataComplete = true;
                break;
            }
            case False: {
                this._metaDataComplete = true;
                break;
            }
        }
        if (webOverrideRoot.isOrdered()) {
            if (this._ordering == null) {
                this._ordering = new Ordering.AbsoluteOrdering(this);
            }
            List<String> order = webOverrideRoot.getOrdering();
            for (String s : order) {
                if (s.equalsIgnoreCase("others")) {
                    ((Ordering.AbsoluteOrdering)this._ordering).addOthers();
                    continue;
                }
                ((Ordering.AbsoluteOrdering)this._ordering).add(s);
            }
        }
        this._webOverrideRoots.add(webOverrideRoot);
    }

    public void addFragment(Resource jarResource, Resource xmlResource) throws Exception {
        if (this._metaDataComplete) {
            return;
        }
        FragmentDescriptor descriptor = new FragmentDescriptor(xmlResource);
        this._webFragmentResourceMap.put(jarResource, descriptor);
        this._webFragmentRoots.add(descriptor);
        descriptor.parse();
        if (descriptor.getName() != null) {
            Descriptor existing = this._webFragmentNameMap.get(descriptor.getName());
            if (existing != null && !this.isAllowDuplicateFragmentNames()) {
                throw new IllegalStateException("Duplicate fragment name: " + descriptor.getName() + " for " + existing.getResource() + " and " + descriptor.getResource());
            }
            this._webFragmentNameMap.put(descriptor.getName(), descriptor);
        }
        if (this._ordering != null && this._ordering.isAbsolute()) {
            return;
        }
        if (this._ordering == null && descriptor.isOrdered()) {
            this._ordering = new Ordering.RelativeOrdering(this);
        }
    }

    public void addDiscoveredAnnotations(List<DiscoveredAnnotation> annotations) {
        this._annotations.addAll(annotations);
    }

    public void addDiscoveredAnnotations(Resource resource, List<DiscoveredAnnotation> annotations) {
        this._webFragmentAnnotations.put(resource, new ArrayList<DiscoveredAnnotation>(annotations));
    }

    public void addDescriptorProcessor(DescriptorProcessor p) {
        this._descriptorProcessors.add(p);
    }

    public void orderFragments() {
        if (this._orderedWebInfJars.size() == this._webInfJars.size()) {
            return;
        }
        if (this._ordering != null) {
            this._orderedWebInfJars.addAll(this._ordering.order(this._webInfJars));
        } else {
            this._orderedWebInfJars.addAll(this._webInfJars);
        }
    }

    public void resolve(WebAppContext context) throws Exception {
        Log.debug((String)"metadata resolve {}", (Object)context);
        this._origins.clear();
        if (this._ordering != null) {
            ArrayList<String> orderedLibs = new ArrayList<String>();
            for (Resource webInfJar : this._orderedWebInfJars) {
                String fullname = webInfJar.getName();
                int i = fullname.indexOf(".jar");
                int j = fullname.lastIndexOf("/", i);
                orderedLibs.add(fullname.substring(j + 1, i + 4));
            }
            context.setAttribute(ORDERED_LIBS, orderedLibs);
        }
        for (DescriptorProcessor p : this._descriptorProcessors) {
            p.process(context, this.getWebDefault());
            p.process(context, this.getWebXml());
            for (WebDescriptor wd : this.getOverrideWebs()) {
                Log.debug((String)"process {} {}", (Object)context, (Object)wd);
                p.process(context, wd);
            }
        }
        for (DiscoveredAnnotation a : this._annotations) {
            Log.debug((String)"apply {}", (Object)a);
            a.apply();
        }
        List<Resource> resources = this.getOrderedWebInfJars();
        for (Resource r : resources) {
            List<DiscoveredAnnotation> fragAnnotations;
            FragmentDescriptor fd = this._webFragmentResourceMap.get(r);
            if (fd != null) {
                for (DescriptorProcessor p : this._descriptorProcessors) {
                    Log.debug((String)"process {} {}", (Object)context, (Object)fd);
                    p.process(context, fd);
                }
            }
            if ((fragAnnotations = this._webFragmentAnnotations.get(r)) == null) continue;
            for (DiscoveredAnnotation a : fragAnnotations) {
                Log.debug((String)"apply {}", (Object)a);
                a.apply();
            }
        }
    }

    public boolean isDistributable() {
        boolean distributable = this._webDefaultsRoot != null && this._webDefaultsRoot.isDistributable() || this._webXmlRoot != null && this._webXmlRoot.isDistributable();
        for (WebDescriptor d : this._webOverrideRoots) {
            distributable &= d.isDistributable();
        }
        List<Resource> orderedResources = this.getOrderedWebInfJars();
        for (Resource r : orderedResources) {
            FragmentDescriptor d = this._webFragmentResourceMap.get(r);
            if (d == null) continue;
            distributable = distributable && d.isDistributable();
        }
        return distributable;
    }

    public WebDescriptor getWebXml() {
        return this._webXmlRoot;
    }

    public List<WebDescriptor> getOverrideWebs() {
        return this._webOverrideRoots;
    }

    public WebDescriptor getWebDefault() {
        return this._webDefaultsRoot;
    }

    public List<FragmentDescriptor> getFragments() {
        return this._webFragmentRoots;
    }

    public List<Resource> getOrderedWebInfJars() {
        return this._orderedWebInfJars == null ? new ArrayList() : this._orderedWebInfJars;
    }

    public List<FragmentDescriptor> getOrderedFragments() {
        ArrayList<FragmentDescriptor> list = new ArrayList<FragmentDescriptor>();
        if (this._orderedWebInfJars == null) {
            return list;
        }
        for (Resource r : this._orderedWebInfJars) {
            FragmentDescriptor fd = this._webFragmentResourceMap.get(r);
            if (fd == null) continue;
            list.add(fd);
        }
        return list;
    }

    public Ordering getOrdering() {
        return this._ordering;
    }

    public void setOrdering(Ordering o) {
        this._ordering = o;
    }

    public FragmentDescriptor getFragment(Resource jar) {
        return this._webFragmentResourceMap.get(jar);
    }

    public FragmentDescriptor getFragment(String name) {
        return this._webFragmentNameMap.get(name);
    }

    public Resource getJarForFragment(String name) {
        FragmentDescriptor f = this.getFragment(name);
        if (f == null) {
            return null;
        }
        Resource jar = null;
        for (Resource r : this._webFragmentResourceMap.keySet()) {
            if (!this._webFragmentResourceMap.get(r).equals(f)) continue;
            jar = r;
        }
        return jar;
    }

    public Map<String, FragmentDescriptor> getNamedFragments() {
        return Collections.unmodifiableMap(this._webFragmentNameMap);
    }

    public Origin getOrigin(String name) {
        OriginInfo x = this._origins.get(name);
        if (x == null) {
            return Origin.NotSet;
        }
        return x.getOriginType();
    }

    public Descriptor getOriginDescriptor(String name) {
        OriginInfo o = this._origins.get(name);
        if (o == null) {
            return null;
        }
        return o.getDescriptor();
    }

    public void setOrigin(String name, Descriptor d) {
        OriginInfo x = new OriginInfo(name, d);
        this._origins.put(name, x);
    }

    public void setOrigin(String name) {
        if (name == null) {
            return;
        }
        OriginInfo x = new OriginInfo(name, Origin.Annotation);
        this._origins.put(name, x);
    }

    public boolean isMetaDataComplete() {
        return this._metaDataComplete;
    }

    public void addWebInfJar(Resource newResource) {
        this._webInfJars.add(newResource);
    }

    public List<Resource> getWebInfJars() {
        return Collections.unmodifiableList(this._webInfJars);
    }

    public List<Resource> getOrderedContainerJars() {
        return this._orderedContainerJars;
    }

    public void addContainerJar(Resource jar) {
        this._orderedContainerJars.add(jar);
    }

    public boolean isAllowDuplicateFragmentNames() {
        return this.allowDuplicateFragmentNames;
    }

    public void setAllowDuplicateFragmentNames(boolean allowDuplicateFragmentNames) {
        this.allowDuplicateFragmentNames = allowDuplicateFragmentNames;
    }

    public static class OriginInfo {
        protected String name;
        protected Origin origin;
        protected Descriptor descriptor;

        public OriginInfo(String n, Descriptor d) {
            this.name = n;
            this.descriptor = d;
            if (d == null) {
                throw new IllegalArgumentException("No descriptor");
            }
            this.origin = d instanceof FragmentDescriptor ? Origin.WebFragment : (d instanceof OverrideDescriptor ? Origin.WebOverride : (d instanceof DefaultsDescriptor ? Origin.WebDefaults : Origin.WebXml));
        }

        public OriginInfo(String n) {
            this.name = n;
            this.origin = Origin.Annotation;
        }

        public OriginInfo(String n, Origin o) {
            this.name = n;
            this.origin = o;
        }

        public String getName() {
            return this.name;
        }

        public Origin getOriginType() {
            return this.origin;
        }

        public Descriptor getDescriptor() {
            return this.descriptor;
        }
    }
}

