/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.telnet;

import java.net.BindException;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.Descriptor;
import org.eclipse.equinox.console.telnet.TelnetServer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public class TelnetCommand {
    private String defaultHost = null;
    private int defaultPort;
    private final CommandProcessor processor;
    private final BundleContext context;
    private String host = null;
    private int port;
    private TelnetServer telnetServer = null;
    private ServiceRegistration<?> configuratorRegistration;
    private static final String HOST = "host";
    private static final String PORT = "port";
    private static final String USE_CONFIG_ADMIN_PROP = "osgi.console.useConfigAdmin";
    private static final String TELNET_PID = "osgi.console.telnet";
    private static final String CONSOLE_PROP = "osgi.console";

    public TelnetCommand(CommandProcessor processor, BundleContext context) {
        this.processor = processor;
        this.context = context;
        if ("true".equals(context.getProperty(USE_CONFIG_ADMIN_PROP))) {
            Hashtable<String, String> telnetProperties = new Hashtable<String, String>();
            ((Dictionary)telnetProperties).put("service.pid", TELNET_PID);
            try {
                this.configuratorRegistration = context.registerService(ManagedService.class.getName(), (Object)new TelnetConfigurator(), telnetProperties);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                System.out.println("Configuration Admin not available!");
                return;
            }
        } else {
            this.parseHostAndPort();
        }
    }

    private void parseHostAndPort() {
        String telnetPort = null;
        String consolePropValue = this.context.getProperty(CONSOLE_PROP);
        if (consolePropValue != null) {
            int index = consolePropValue.lastIndexOf(":");
            if (index > -1) {
                this.defaultHost = consolePropValue.substring(0, index);
            }
            telnetPort = consolePropValue.substring(index + 1);
        }
        if (telnetPort != null && !"".equals(telnetPort)) {
            try {
                this.defaultPort = Integer.parseInt(telnetPort);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public synchronized void start() {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("osgi.command.scope", "equinox");
        ((Dictionary)properties).put("osgi.command.function", new String[]{"telnet"});
        if (this.port > 0 || this.defaultPort > 0) {
            try {
                this.telnet(new String[]{"start"});
            }
            catch (Exception e) {
                System.out.println("Cannot start telnet. Reason: " + e.getMessage());
                e.printStackTrace();
            }
        }
        this.context.registerService(TelnetCommand.class.getName(), (Object)this, properties);
    }

    @Descriptor(value="start/stop a telnet server")
    public synchronized void telnet(String[] arguments) throws Exception {
        String command = null;
        int newPort = 0;
        String newHost = null;
        int i = 0;
        while (i < arguments.length) {
            if ("-?".equals(arguments[i]) || "-help".equals(arguments[i])) {
                this.printHelp();
                return;
            }
            if ("start".equals(arguments[i])) {
                command = "start";
            } else if ("stop".equals(arguments[i])) {
                command = "stop";
            } else if ("-port".equals(arguments[i]) && arguments.length > i + 1) {
                newPort = Integer.parseInt(arguments[++i]);
            } else if ("-host".equals(arguments[i]) && arguments.length > i + 1) {
                newHost = arguments[++i];
            } else {
                throw new Exception("Unrecognized telnet command/option " + arguments[i]);
            }
            ++i;
        }
        if (command == null) {
            throw new Exception("No telnet command specified");
        }
        if (newPort != 0) {
            this.port = newPort;
        } else if (this.port == 0) {
            this.port = this.defaultPort;
        }
        if (this.port == 0) {
            throw new Exception("No telnet port specified");
        }
        this.host = newHost != null ? newHost : this.defaultHost;
        if ("start".equals(command)) {
            if (this.telnetServer != null) {
                throw new IllegalStateException("telnet is already running on port " + this.port);
            }
            try {
                this.telnetServer = new TelnetServer(this.context, this.processor, this.host, this.port);
            }
            catch (BindException bindException) {
                throw new Exception("Port " + this.port + " already in use");
            }
            this.telnetServer.setName("equinox telnet");
            this.telnetServer.start();
        } else if ("stop".equals(command)) {
            if (this.telnetServer == null) {
                throw new IllegalStateException("telnet is not running.");
            }
            this.telnetServer.stopTelnetServer();
            this.telnetServer = null;
        }
    }

    private void printHelp() {
        StringBuffer help = new StringBuffer();
        help.append("telnet - start simple telnet server");
        help.append("\n");
        help.append("Usage: telnet start | stop [-port port] [-host host]");
        help.append("\n");
        help.append("\t");
        help.append("-port");
        help.append("\t");
        help.append("listen port (default=");
        help.append(this.defaultPort);
        help.append(")");
        help.append("\n");
        help.append("\t");
        help.append("-host");
        help.append("\t");
        help.append("local host address to listen on (default is none - listen on all network interfaces)");
        help.append("\n");
        help.append("\t");
        help.append("-?, -help");
        help.append("\t");
        help.append("show help");
        System.out.println(help.toString());
    }

    class TelnetConfigurator
    implements ManagedService {
        private Dictionary properties;

        TelnetConfigurator() {
        }

        public synchronized void updated(Dictionary props) throws ConfigurationException {
            if (props == null) {
                return;
            }
            this.properties = props;
            this.properties.put("service.pid", TelnetCommand.TELNET_PID);
            TelnetCommand.this.defaultPort = Integer.parseInt((String)this.properties.get(TelnetCommand.PORT));
            TelnetCommand.this.defaultHost = (String)this.properties.get(TelnetCommand.HOST);
            TelnetCommand.this.configuratorRegistration.setProperties(this.properties);
            if (TelnetCommand.this.telnetServer == null) {
                try {
                    TelnetCommand.this.telnet(new String[]{"start"});
                }
                catch (Exception e) {
                    System.out.println("Cannot start telnet: " + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
    }
}

