/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.medic.dump.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.virgo.medic.dump.DumpContributor;
import org.eclipse.virgo.medic.dump.impl.heap.HeapDumpContributor;
import org.eclipse.virgo.medic.dump.impl.summary.SummaryDumpContributor;
import org.eclipse.virgo.medic.dump.impl.thread.ThreadDumpContributor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public final class DumpContributorPublisher {
    private static final String SUPPRESS_HEAP_DUMPS = "org.eclipse.virgo.suppress.heap.dumps";
    private final List<ServiceRegistration<DumpContributor>> contributorRegistrations = new ArrayList<ServiceRegistration<DumpContributor>>();
    private final BundleContext bundleContext;

    public DumpContributorPublisher(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void publishDumpContributors() {
        this.publishDumpContributor(new SummaryDumpContributor());
        if ("false".equalsIgnoreCase(this.bundleContext.getProperty(SUPPRESS_HEAP_DUMPS))) {
            this.publishDumpContributor(new HeapDumpContributor());
        }
        this.publishDumpContributor(new ThreadDumpContributor());
    }

    private void publishDumpContributor(DumpContributor dumpContributor) {
        ServiceRegistration registration = this.bundleContext.registerService(DumpContributor.class.getName(), (Object)dumpContributor, null);
        this.contributorRegistrations.add((ServiceRegistration<DumpContributor>)registration);
    }

    public void retractDumpContributors() {
        for (ServiceRegistration<DumpContributor> registration : this.contributorRegistrations) {
            registration.unregister();
        }
        this.contributorRegistrations.clear();
    }
}

