/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.commands;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.apache.felix.service.command.CommandSession;
import org.eclipse.equinox.console.command.adapter.CustomCommandInterpreter;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class HelpCommand {
    private BundleContext context;
    private Set<CommandProvider> legacyCommandProviders;
    private ServiceTracker<CommandProvider, Set<CommandProvider>> commandProvidersTracker;

    public HelpCommand(BundleContext context) {
        this.context = context;
        this.legacyCommandProviders = new HashSet<CommandProvider>();
        this.commandProvidersTracker = new ServiceTracker(context, CommandProvider.class.getName(), (ServiceTrackerCustomizer)new CommandProviderCustomizer(context));
        this.commandProvidersTracker.open();
    }

    public void start() {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("service.ranking", new Integer(Integer.MAX_VALUE));
        ((Dictionary)props).put("osgi.command.scope", "equinox");
        ((Dictionary)props).put("osgi.command.function", new String[]{"help"});
        this.context.registerService(HelpCommand.class.getName(), (Object)this, props);
    }

    public void help(CommandSession session, String ... args) throws Exception {
        boolean isLegacy = false;
        boolean isAll = false;
        String command = null;
        if (args.length > 0) {
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                if (arg.equals("-legacy")) {
                    isLegacy = true;
                } else if (arg.equals("-all")) {
                    isAll = true;
                } else {
                    command = arg;
                }
                ++n2;
            }
        }
        if (isLegacy && command != null) {
            block3: for (CommandProvider provider : this.legacyCommandProviders) {
                Method[] methods;
                Method[] methodArray = methods = provider.getClass().getMethods();
                int n = methods.length;
                int n3 = 0;
                while (n3 < n) {
                    Method method = methodArray[n3];
                    Object retval = null;
                    if (method.getName().equals("_" + command)) {
                        try {
                            Method helpMethod = provider.getClass().getMethod("_help", CommandInterpreter.class);
                            ArrayList<Object> argsList = new ArrayList<Object>();
                            argsList.add(command);
                            retval = helpMethod.invoke((Object)provider, new CustomCommandInterpreter(argsList));
                        }
                        catch (Exception e) {
                            System.out.println(provider.getHelp());
                            continue block3;
                        }
                        if (retval == null || !(retval instanceof String)) continue block3;
                        System.out.println(retval);
                        continue block3;
                    }
                    ++n3;
                }
            }
            return;
        }
        if (!isLegacy && command != null) {
            session.execute((CharSequence)("help " + command));
            return;
        }
        if (isLegacy) {
            this.printLegacyCommands();
            return;
        }
        if (isAll) {
            this.printLegacyCommands();
            session.execute((CharSequence)"help");
            return;
        }
        session.execute((CharSequence)"help");
    }

    private void printLegacyCommands() {
        for (CommandProvider provider : this.legacyCommandProviders) {
            Method[] methods;
            Method[] methodArray = methods = provider.getClass().getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.getName().startsWith("_")) {
                    System.out.println("equinox:" + method.getName().substring(1));
                }
                ++n2;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CommandProviderCustomizer
    implements ServiceTrackerCustomizer<CommandProvider, Set<CommandProvider>> {
        private BundleContext context;

        public CommandProviderCustomizer(BundleContext context) {
            this.context = context;
        }

        public Set<CommandProvider> addingService(ServiceReference<CommandProvider> reference) {
            if (reference.getProperty("osgi.command.function") != null) {
                return null;
            }
            CommandProvider command = (CommandProvider)this.context.getService(reference);
            HelpCommand.this.legacyCommandProviders.add(command);
            this.context.ungetService(reference);
            return HelpCommand.this.legacyCommandProviders;
        }

        public void modifiedService(ServiceReference<CommandProvider> reference, Set<CommandProvider> service) {
        }

        public void removedService(ServiceReference<CommandProvider> reference, Set<CommandProvider> providers) {
            CommandProvider provider = (CommandProvider)this.context.getService(reference);
            providers.remove(provider);
        }
    }
}

