/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.ssh;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Descriptor;
import org.eclipse.equinox.console.common.Scanner;
import org.eclipse.equinox.console.storage.DigestUtil;
import org.eclipse.equinox.console.storage.SecureUserStore;
import org.eclipse.equinox.console.supportability.ConsoleInputScanner;

public class UserAdminCommand {
    private static final String INPUT_SCANNER = "INPUT_SCANNER";
    private static final String SSH_INPUT_SCANNER = "SSH_INPUT_SCANNER";
    private static final String DEFAULT_USER = "equinox";
    private static final int MINIMAL_PASSWORD_LENGTH = 8;
    private static final int PASSWORD_INPUT_TRIALS_LIMIT = 3;

    @Descriptor(value="Add user with password and roles")
    public void addUser(@Descriptor(value="-username <username>\r\n-password <password>\r\n-roles <comma-separated list of user roles (optional)>") String[] args) throws Exception {
        String username = null;
        String password = null;
        String roles = "";
        int i = 0;
        while (i < args.length) {
            if ("-username".equals(args[i]) && i < args.length - 1) {
                username = args[i + 1];
                ++i;
            } else if ("-password".equals(args[i]) && i < args.length - 1) {
                password = args[i + 1];
                ++i;
            } else if ("-roles".equals(args[i]) && i < args.length - 1) {
                roles = args[i + 1];
                ++i;
            }
            ++i;
        }
        if (!UserAdminCommand.validateUsername(username)) {
            throw new Exception("Invalid username");
        }
        if (password == null) {
            throw new Exception("Password not specified");
        }
        if (password.length() < 8) {
            throw new Exception("Password should be at least 8 symblos");
        }
        SecureUserStore.putUser(username, DigestUtil.encrypt(password), roles);
        if (SecureUserStore.existsUser(DEFAULT_USER)) {
            SecureUserStore.deleteUser(DEFAULT_USER);
        }
    }

    @Descriptor(value="Set or change password")
    public void setPassword(@Descriptor(value="-username <username>\r\n-password <password>") String[] args) throws Exception {
        String username = null;
        String password = null;
        int i = 0;
        while (i < args.length) {
            if ("-username".equals(args[i]) && i < args.length - 1) {
                username = args[i + 1];
                ++i;
            } else if ("-password".equals(args[i]) && i < args.length - 1) {
                password = args[i + 1];
                ++i;
            }
            ++i;
        }
        if (!UserAdminCommand.validateUsername(username)) {
            throw new Exception("Invalid username");
        }
        if (password == null) {
            throw new Exception("Password not specified");
        }
        if (password.length() < 8) {
            throw new Exception("Password should be at least 8 symblos");
        }
        SecureUserStore.setPassword(username, DigestUtil.encrypt(password));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Descriptor(value="Add user with password and roles interactively")
    public boolean addUser(CommandSession session) throws Exception {
        ConsoleInputScanner inputScanner = (ConsoleInputScanner)session.get(INPUT_SCANNER);
        Scanner scanner = (Scanner)session.get(SSH_INPUT_SCANNER);
        try {
            String roles;
            String password;
            BufferedReader reader;
            String username;
            if (scanner != null) {
                inputScanner.toggleHistoryEnabled(false);
            }
            if (!UserAdminCommand.validateUsername(username = this.readUsername(reader = new BufferedReader(new InputStreamReader(System.in))))) {
                System.out.println("Invalid username");
                return false;
            }
            if (SecureUserStore.existsUser(username)) {
                System.out.println("Username already exists");
                return false;
            }
            if (scanner != null) {
                scanner.toggleEchoEnabled(false);
            }
            if ((password = this.readPassword(reader)) == null) {
                return false;
            }
            if (scanner != null) {
                scanner.toggleEchoEnabled(true);
            }
            if ((roles = this.readRoles(reader)) == null) {
                return false;
            }
            SecureUserStore.putUser(username, DigestUtil.encrypt(password), roles);
            if (!SecureUserStore.existsUser(DEFAULT_USER)) return true;
            SecureUserStore.deleteUser(DEFAULT_USER);
            return true;
        }
        finally {
            if (scanner != null) {
                inputScanner.toggleHistoryEnabled(true);
                scanner.toggleEchoEnabled(true);
            }
        }
    }

    @Descriptor(value="Delete user")
    public void deleteUser(@Descriptor(value="username of the user to be deleted") String username) throws Exception {
        if (SecureUserStore.existsUser(username)) {
            SecureUserStore.deleteUser(username);
        }
    }

    @Descriptor(value="Reset password")
    public void resetPassword(@Descriptor(value="username of the user whose password will be reset") String username) throws Exception {
        if (!SecureUserStore.existsUser(username)) {
            throw new Exception("Such user does not exist");
        }
        SecureUserStore.resetPassword(username);
    }

    @Descriptor(value="Set or change password")
    public void setPassword(CommandSession session, @Descriptor(value="Username of the user whose password will be changed") String username) throws Exception {
        if ("".equals(username)) {
            System.out.println("Username not specified");
            return;
        }
        if (!SecureUserStore.existsUser(username)) {
            throw new Exception("Such user does not exist");
        }
        ConsoleInputScanner inputScanner = (ConsoleInputScanner)session.get(INPUT_SCANNER);
        Scanner scanner = (Scanner)session.get(SSH_INPUT_SCANNER);
        try {
            BufferedReader reader;
            String password;
            if (scanner != null) {
                inputScanner.toggleHistoryEnabled(false);
                scanner.toggleEchoEnabled(false);
            }
            if ((password = this.readPassword(reader = new BufferedReader(new InputStreamReader(System.in)))) == null) {
                return;
            }
            SecureUserStore.setPassword(username, DigestUtil.encrypt(password));
        }
        finally {
            if (scanner != null) {
                inputScanner.toggleHistoryEnabled(true);
                scanner.toggleEchoEnabled(true);
            }
        }
    }

    @Descriptor(value="Add roles to user")
    public void addRoles(@Descriptor(value="-username <username>\r\n-roles <comma-separated list of roles to add>") String[] args) throws Exception {
        String username = null;
        String roles = "";
        int i = 0;
        while (i < args.length) {
            if ("-username".equals(args[i]) && i < args.length - 1) {
                username = args[i + 1];
                ++i;
            } else if ("-roles".equals(args[i]) && i < args.length - 1) {
                roles = args[i + 1];
                ++i;
            }
            ++i;
        }
        if (username == null) {
            throw new Exception("Username not specified");
        }
        if ("".equals(roles)) {
            return;
        }
        if (!SecureUserStore.existsUser(username)) {
            throw new Exception("Such user does not exist");
        }
        SecureUserStore.addRoles(username, roles);
    }

    @Descriptor(value="Remove user roles")
    public void removeRoles(@Descriptor(value="-username <username>\r\n-roles <comma-separated list of roles to remove>") String[] args) throws Exception {
        String username = null;
        String roles = "";
        int i = 0;
        while (i < args.length) {
            if ("-username".equals(args[i]) && i < args.length - 1) {
                username = args[i + 1];
                ++i;
            } else if ("-roles".equals(args[i]) && i < args.length - 1) {
                roles = args[i + 1];
                ++i;
            }
            ++i;
        }
        if (username == null) {
            throw new Exception("Username not specified");
        }
        if ("".equals(roles)) {
            return;
        }
        if (!SecureUserStore.existsUser(username)) {
            throw new Exception("Such user does not exist");
        }
        SecureUserStore.removeRoles(username, roles);
    }

    @Descriptor(value="Lists available users")
    public void listUsers() throws Exception {
        String[] users = SecureUserStore.getUserNames();
        if (users.length == 0) {
            System.out.println("No users available");
            return;
        }
        String[] stringArray = users;
        int n = users.length;
        int n2 = 0;
        while (n2 < n) {
            String user = stringArray[n2];
            System.out.println(user);
            ++n2;
        }
    }

    private String readPassword(BufferedReader reader) {
        String password = null;
        int count = 0;
        while (password == null && count < 3) {
            System.out.print("password: ");
            System.out.flush();
            try {
                password = reader.readLine();
            }
            catch (IOException e) {
                System.out.println("Error while reading password");
                return null;
            }
            if (password == null || "".equals(password)) {
                System.out.println("Password not specified");
                password = null;
            } else if (password.length() < 8) {
                System.out.println("Password should be at least 8 symblos");
                password = null;
            }
            ++count;
        }
        if (password == null) {
            return null;
        }
        String passwordConfirmation = null;
        count = 0;
        while (passwordConfirmation == null && count < 3) {
            System.out.print("Confirm password: ");
            System.out.flush();
            try {
                passwordConfirmation = reader.readLine();
                if (!password.equals(passwordConfirmation)) {
                    System.out.println("The passwords do not match!");
                    passwordConfirmation = null;
                }
            }
            catch (IOException e) {
                System.out.println("Error while reading password");
                return null;
            }
            ++count;
        }
        if (passwordConfirmation == null) {
            return null;
        }
        return password;
    }

    private String readUsername(BufferedReader reader) {
        System.out.print("username: ");
        System.out.flush();
        String username = null;
        try {
            username = reader.readLine();
        }
        catch (IOException e) {
            System.out.println("Error while reading username");
            return null;
        }
        if (username == null || "".equals(username)) {
            System.out.println("Username not specified");
            return null;
        }
        return username;
    }

    private String readRoles(BufferedReader reader) {
        System.out.print("roles: ");
        System.out.flush();
        String roles = null;
        try {
            roles = reader.readLine();
        }
        catch (IOException e) {
            System.out.println("Error while reading roles");
            return null;
        }
        if (roles == null) {
            roles = "";
        }
        return roles;
    }

    private static boolean validateUsername(String username) {
        if (username == null) {
            return false;
        }
        Pattern allowedChars = Pattern.compile("[A-Za-z0-9_.]+");
        Matcher matcher = allowedChars.matcher(username);
        return matcher.matches();
    }
}

