/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.telnet;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import org.apache.felix.service.command.CommandProcessor;
import org.eclipse.equinox.console.telnet.TelnetConnection;
import org.osgi.framework.BundleContext;

public class TelnetServer
extends Thread {
    private ServerSocket server;
    private boolean isRunning = true;
    private CommandProcessor processor;
    private BundleContext context;
    private List<TelnetConnection> telnetConnections = new ArrayList<TelnetConnection>();

    public TelnetServer(BundleContext context, CommandProcessor processor, String host, int port) throws IOException {
        this.context = context;
        this.processor = processor;
        this.server = host != null ? new ServerSocket(port, 0, InetAddress.getByName(host)) : new ServerSocket(port);
    }

    public void run() {
        try {
            try {
                while (this.isRunning) {
                    Socket socket = this.server.accept();
                    TelnetConnection telnetConnection = new TelnetConnection(socket, this.processor, this.context);
                    this.telnetConnections.add(telnetConnection);
                    telnetConnection.start();
                }
            }
            catch (IOException e) {
                if (this.isRunning) {
                    e.printStackTrace();
                }
                this.isRunning = false;
                try {
                    if (this.server != null) {
                        this.server.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            this.isRunning = false;
            try {
                if (this.server != null) {
                    this.server.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public synchronized void stopTelnetServer() {
        this.isRunning = false;
        try {
            if (this.server != null) {
                this.server.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (TelnetConnection telnetConnection : this.telnetConnections) {
            telnetConnection.close();
        }
        this.interrupt();
    }
}

