/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.medic.dump.impl;

import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.virgo.medic.dump.Dump;
import org.eclipse.virgo.medic.dump.DumpContributionFailedException;
import org.eclipse.virgo.medic.dump.DumpContributor;
import org.eclipse.virgo.medic.dump.DumpGenerationFailedException;
import org.eclipse.virgo.medic.dump.DumpGenerator;
import org.eclipse.virgo.medic.dump.impl.DumpContributorResolver;
import org.eclipse.virgo.medic.dump.impl.StandardDump;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.medic.impl.MedicLogEvents;
import org.eclipse.virgo.medic.impl.config.ConfigurationProvider;

public final class StandardDumpGenerator
implements DumpGenerator {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd-HH-mm-SSS");
    private static final Map<String, Object> NO_CONTEXT = new HashMap<String, Object>();
    private final DumpContributorResolver dumpContributorsAccessor;
    private final ConfigurationProvider configurationProvider;
    private final EventLogger eventLogger;
    private String latestDumpId = null;

    public StandardDumpGenerator(DumpContributorResolver accessor, ConfigurationProvider configurationProvider, EventLogger eventLogger) {
        this.dumpContributorsAccessor = accessor;
        this.configurationProvider = configurationProvider;
        this.eventLogger = eventLogger;
    }

    public void generateDump(String cause, Throwable ... throwables) {
        this.generateDump(cause, NO_CONTEXT, throwables);
    }

    public void generateDump(String cause, Map<String, Object> context, Throwable ... throwables) {
        StandardDump dump;
        try {
            dump = this.createDump(cause, context, throwables);
        }
        catch (DumpGenerationFailedException dumpGenerationFailedException) {
            return;
        }
        for (DumpContributor dumpContributor : this.getDumpContributors(cause)) {
            try {
                dumpContributor.contribute((Dump)dump);
            }
            catch (DumpContributionFailedException e) {
                this.eventLogger.log((LogEvent)MedicLogEvents.CONTRIBUTION_FAILED, (Throwable)e, new Object[]{dumpContributor.getName(), dump.getTimestamp()});
            }
        }
        this.eventLogger.log((LogEvent)MedicLogEvents.DUMP_GENERATED, new Object[]{dump.getDumpDirectory()});
    }

    private StandardDump createDump(String cause, Map<String, Object> context, Throwable ... throwables) throws DumpGenerationFailedException {
        File dumpDirectory = null;
        long timestamp = System.currentTimeMillis();
        while ((dumpDirectory = this.getDumpDirectory(timestamp)) == null) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
            timestamp = System.currentTimeMillis();
        }
        return new StandardDump(cause, timestamp, context, throwables, dumpDirectory);
    }

    private List<DumpContributor> getDumpContributors(String cause) {
        Dictionary<String, String> configuration = this.configurationProvider.getConfiguration();
        String excludedContributorsProperty = configuration.get("dump.exclusions." + cause);
        List<String> excludedContributors = this.toList(excludedContributorsProperty);
        excludedContributorsProperty = configuration.get("dump.exclusions.*");
        excludedContributors.addAll(this.toList(excludedContributorsProperty));
        List<DumpContributor> candidateContributors = this.dumpContributorsAccessor.getDumpContributors();
        ArrayList<DumpContributor> includedContributors = new ArrayList<DumpContributor>();
        for (DumpContributor candidate : candidateContributors) {
            if (excludedContributors.contains(candidate.getName())) continue;
            includedContributors.add(candidate);
        }
        return includedContributors;
    }

    private List<String> toList(String property) {
        ArrayList<String> list = new ArrayList<String>();
        if (property != null) {
            String[] components;
            String[] stringArray = components = property.split(",");
            int n = components.length;
            int n2 = 0;
            while (n2 < n) {
                String component = stringArray[n2];
                String trimmed = component.trim();
                list.add(trimmed);
                ++n2;
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDumpId(long timestamp) {
        Date date = new Date(timestamp);
        DateFormat dateFormat = DATE_FORMAT;
        synchronized (dateFormat) {
            String dumpId = DATE_FORMAT.format(date);
            if (dumpId.equals(this.latestDumpId)) {
                dumpId = null;
            } else {
                this.latestDumpId = dumpId;
            }
            return dumpId;
        }
    }

    private File getDumpDirectory(long timestamp) throws DumpGenerationFailedException {
        File dumpDirectory = null;
        String dumpId = this.getDumpId(timestamp);
        if (dumpId != null) {
            dumpDirectory = new File(this.getRootDumpDirectory(), dumpId);
            if (dumpDirectory.exists()) {
                dumpDirectory = null;
            } else {
                this.createDirectory(dumpDirectory);
            }
        }
        return dumpDirectory;
    }

    private String getRootDumpDirectory() {
        Dictionary<String, String> configuration = this.configurationProvider.getConfiguration();
        return configuration.get("dump.root.directory");
    }

    private void createDirectory(File file) throws DumpGenerationFailedException {
        if (!file.mkdirs()) {
            this.eventLogger.log((LogEvent)MedicLogEvents.DIRECTORY_CREATION_FAILED, new Object[]{file.getAbsolutePath()});
            throw new DumpGenerationFailedException("Directory creation failed");
        }
    }

    public void close() {
        this.dumpContributorsAccessor.close();
    }
}

