/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot.internal.serverfactory;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jetty.osgi.boot.internal.serverfactory.IManagedJettyServerRegistry;
import org.eclipse.jetty.osgi.boot.internal.serverfactory.ServerInstanceWrapper;
import org.eclipse.jetty.server.Server;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class JettyServerServiceTracker
implements ServiceListener,
IManagedJettyServerRegistry {
    private Map<String, ServerInstanceWrapper> _serversIndexedByName = new HashMap<String, ServerInstanceWrapper>();
    private Map<ServiceReference, ServerInstanceWrapper> _indexByServiceReference = new HashMap<ServiceReference, ServerInstanceWrapper>();

    public void stop() {
        for (ServerInstanceWrapper wrapper : this._serversIndexedByName.values()) {
            try {
                wrapper.stop();
            }
            catch (Throwable throwable) {}
        }
    }

    public void serviceChanged(ServiceEvent ev) {
        ServiceReference sr = ev.getServiceReference();
        switch (ev.getType()) {
            case 2: 
            case 4: {
                ServerInstanceWrapper instance = this.unregisterInIndex(ev.getServiceReference());
                if (instance != null) {
                    try {
                        instance.stop();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (ev.getType() == 4) break;
            }
            case 1: {
                Bundle contributor = sr.getBundle();
                Server server = (Server)contributor.getBundleContext().getService(sr);
                ServerInstanceWrapper wrapper = this.registerInIndex(server, sr);
                Properties props = new Properties();
                for (String key : sr.getPropertyKeys()) {
                    Object value = sr.getProperty(key);
                    props.put(key, value);
                }
                wrapper.start(server, props);
                break;
            }
        }
    }

    private ServerInstanceWrapper registerInIndex(Server server, ServiceReference sr) {
        String name = (String)sr.getProperty("managedServerName");
        if (name == null) {
            throw new IllegalArgumentException("The property managedServerName is mandatory");
        }
        ServerInstanceWrapper wrapper = new ServerInstanceWrapper(name);
        this._indexByServiceReference.put(sr, wrapper);
        this._serversIndexedByName.put(name, wrapper);
        return wrapper;
    }

    private ServerInstanceWrapper unregisterInIndex(ServiceReference sr) {
        ServerInstanceWrapper handler = this._indexByServiceReference.remove(sr);
        if (handler == null) {
            return null;
        }
        String name = handler.getManagedServerName();
        if (name != null) {
            this._serversIndexedByName.remove(name);
        }
        return handler;
    }

    public ServerInstanceWrapper getServerInstanceWrapper(String managedServerName) {
        return this._serversIndexedByName.get(managedServerName == null ? "defaultJettyServer" : managedServerName);
    }
}

