/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.snaps.core.internal.webapp;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import org.eclipse.virgo.snaps.core.internal.SnapException;
import org.eclipse.virgo.util.common.IterableEnumeration;
import org.osgi.framework.Bundle;

public class SnapServletContext
implements ServletContext {
    private final ServletContext delegate;
    private final Bundle snapBundle;
    private final String snapContextPath;
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();

    public SnapServletContext(ServletContext delegate, Bundle snapBundle, String snapContextPath) {
        this.delegate = delegate;
        this.snapBundle = snapBundle;
        this.snapContextPath = snapContextPath;
    }

    public Object getAttribute(String name) {
        Object attribute = this.attributes.get(name);
        if (attribute == null) {
            attribute = this.delegate.getAttribute(name);
        }
        return attribute;
    }

    public Enumeration<String> getAttributeNames() {
        HashSet<String> attributeNamesSet = new HashSet<String>(this.attributes.keySet());
        IterableEnumeration delegateAttributeNames = new IterableEnumeration(this.delegate.getAttributeNames());
        for (String delegateAttributeName : delegateAttributeNames) {
            attributeNamesSet.add(delegateAttributeName);
        }
        Vector<String> attributeNames = new Vector<String>();
        for (String attributeName : attributeNamesSet) {
            attributeNames.add(attributeName);
        }
        return attributeNames.elements();
    }

    public ServletContext getContext(String uripath) {
        return this.delegate.getContext(uripath);
    }

    public String getContextPath() {
        return this.delegate.getContextPath();
    }

    public String getInitParameter(String name) {
        return this.delegate.getInitParameter(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return this.delegate.getInitParameterNames();
    }

    public int getMajorVersion() {
        return this.delegate.getMajorVersion();
    }

    public String getMimeType(String file) {
        return this.delegate.getMimeType(file);
    }

    public int getMinorVersion() {
        return this.delegate.getMinorVersion();
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        return this.delegate.getNamedDispatcher(name);
    }

    public String getRealPath(String path) {
        return this.delegate.getRealPath(path);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.delegate.getRequestDispatcher(path);
    }

    public URL getResource(String path) throws MalformedURLException {
        if (path == null || !path.startsWith("/")) {
            throw new MalformedURLException(String.format("'%s' is not a valid resource path", path));
        }
        URL resource = this.getLocalResource(path);
        if (resource == null) {
            resource = this.delegate.getResource(path);
        }
        return resource;
    }

    private URL getLocalResource(String path) {
        URL entry = this.snapBundle.getEntry(path);
        if (entry == null && path.startsWith(this.snapContextPath)) {
            entry = this.snapBundle.getEntry(path.substring(this.snapContextPath.length()));
        }
        return entry;
    }

    public InputStream getResourceAsStream(String path) {
        URL resource = this.getLocalResource(path);
        if (resource != null) {
            try {
                return resource.openStream();
            }
            catch (IOException e) {
                throw new SnapException("Failed to open stream for resource " + resource + " in bundle " + this.snapBundle, e);
            }
        }
        return this.delegate.getResourceAsStream(path);
    }

    public Set<String> getResourcePaths(String path) {
        Enumeration entryPaths = this.snapBundle.getEntryPaths(path);
        if (entryPaths == null) {
            return null;
        }
        HashSet<String> resourcePaths = new HashSet<String>();
        while (entryPaths.hasMoreElements()) {
            String entryPath = (String)entryPaths.nextElement();
            if (path.startsWith("/") && !entryPath.startsWith("/")) {
                entryPath = "/" + entryPath;
            }
            resourcePaths.add(entryPath);
        }
        return resourcePaths;
    }

    public String getServerInfo() {
        return this.delegate.getServerInfo();
    }

    public Servlet getServlet(String name) throws ServletException {
        return this.delegate.getServlet(name);
    }

    public String getServletContextName() {
        return this.delegate.getServletContextName();
    }

    public Enumeration<String> getServletNames() {
        return this.delegate.getServletNames();
    }

    public Enumeration<Servlet> getServlets() {
        return this.delegate.getServlets();
    }

    public void log(Exception exception, String msg) {
        this.delegate.log(exception, msg);
    }

    public void log(String message, Throwable throwable) {
        this.delegate.log(message, throwable);
    }

    public void log(String msg) {
        this.delegate.log(msg);
    }

    public void removeAttribute(String name) {
        this.delegate.removeAttribute(name);
    }

    public void setAttribute(String name, Object object) {
        this.attributes.put(name, object);
    }

    public String getSnapContextPath() {
        return this.snapContextPath;
    }

    public int getEffectiveMajorVersion() {
        return this.delegate.getEffectiveMajorVersion();
    }

    public int getEffectiveMinorVersion() {
        return this.delegate.getEffectiveMinorVersion();
    }

    public boolean setInitParameter(String name, String value) {
        return this.delegate.setInitParameter(name, value);
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        return this.delegate.addServlet(servletName, className);
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        return this.delegate.addServlet(servletName, servlet);
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        return this.delegate.addServlet(servletName, servletClass);
    }

    public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
        return (T)this.delegate.createServlet(clazz);
    }

    public ServletRegistration getServletRegistration(String servletName) {
        return this.delegate.getServletRegistration(servletName);
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        return this.delegate.getServletRegistrations();
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        return this.delegate.addFilter(filterName, className);
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        return this.delegate.addFilter(filterName, filter);
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        return this.delegate.addFilter(filterName, filterClass);
    }

    public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
        return (T)this.delegate.createFilter(clazz);
    }

    public FilterRegistration getFilterRegistration(String filterName) {
        return this.delegate.getFilterRegistration(filterName);
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        return this.delegate.getFilterRegistrations();
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return this.delegate.getSessionCookieConfig();
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        this.delegate.setSessionTrackingModes(sessionTrackingModes);
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return this.delegate.getDefaultSessionTrackingModes();
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return this.delegate.getEffectiveSessionTrackingModes();
    }

    public void addListener(String className) {
        this.delegate.addListener(className);
    }

    public <T extends EventListener> void addListener(T t) {
        this.delegate.addListener(t);
    }

    public void addListener(Class<? extends EventListener> listenerClass) {
        this.delegate.addListener(listenerClass);
    }

    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        return (T)this.delegate.createListener(clazz);
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        return this.delegate.getJspConfigDescriptor();
    }

    public ClassLoader getClassLoader() {
        return this.delegate.getClassLoader();
    }

    public void declareRoles(String ... roleNames) {
        this.delegate.declareRoles(roleNames);
    }
}

