/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.snaps.core.internal.webapp.container;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.virgo.snaps.core.RequestRouter;
import org.eclipse.virgo.snaps.core.internal.webapp.container.HttpServletRequestWrapper;
import org.eclipse.virgo.snaps.core.internal.webapp.container.SnapHttpSession;
import org.eclipse.virgo.snaps.core.internal.webapp.container.VirtualContainer;

class SnapHttpServletRequest
extends HttpServletRequestWrapper {
    private static final String HOST_PATH_PREFIX = "host:";
    private final String servletPath;
    private final String pathInfo;
    private final VirtualContainer virtualContainer;
    private final RequestRouter requestRouter;

    public SnapHttpServletRequest(HttpServletRequest delegate, String servletPath, String pathInfo, VirtualContainer virtualContainer, RequestRouter requestRouter) {
        super(delegate);
        this.servletPath = servletPath;
        this.pathInfo = pathInfo;
        this.virtualContainer = virtualContainer;
        this.requestRouter = requestRouter;
    }

    @Override
    public String getPathInfo() {
        return this.pathInfo;
    }

    @Override
    public String getServletPath() {
        return this.servletPath;
    }

    @Override
    public HttpSession getSession(boolean create) {
        HttpSession session = super.getSession(create);
        if (session != null) {
            session = new SnapHttpSession(session, this.virtualContainer.getSnapServletContext());
        }
        return session;
    }

    @Override
    public RequestDispatcher getRequestDispatcher(final String path) {
        if (path.startsWith(HOST_PATH_PREFIX)) {
            String hostPath = path.substring(HOST_PATH_PREFIX.length());
            return super.getRequestDispatcher(hostPath);
        }
        return new RequestDispatcher(){

            public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
                SnapHttpServletRequest.this.requestRouter.forward(path, (HttpServletRequest)request, (HttpServletResponse)response);
            }

            public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
                SnapHttpServletRequest.this.requestRouter.include(path, (HttpServletRequest)request, (HttpServletResponse)response);
            }
        };
    }
}

