/*
 * Decompiled with CFR 0.152.
 */
package snap.simple;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RequestDispatcherTestServlet
extends HttpServlet {
    private static final long serialVersionUID = 4167184064530582217L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String test = request.getParameter("test");
        this.doTest(test, request, response);
    }

    private void doTest(String test, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if ("forward-jsp".equals(test)) {
            this.doJspForward(request, response);
        } else if ("forward-servlet".equals(test)) {
            this.doServletForward(request, response);
        } else if ("forward-host-jsp".equals(test)) {
            this.doHostJspForward(request, response);
        } else if ("forward".equals(test)) {
            this.doForward(request, response);
        } else if ("forward-path".equals(test)) {
            this.doPathMappingForward(request, response);
        } else if ("forward-filter-servlet".equals(test)) {
            this.doFilterServletForward(request, response);
        }
    }

    private void doJspForward(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestDispatcher requestDispatcher = request.getRequestDispatcher("/index.jsp");
        requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    private void doServletForward(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestDispatcher requestDispatcher = request.getRequestDispatcher("/test1");
        requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    private void doFilterServletForward(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestDispatcher requestDispatcher = request.getRequestDispatcher("/filterTest1");
        requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    private void doForward(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestDispatcher requestDispatcher = request.getRequestDispatcher("/forward");
        requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    private void doPathMappingForward(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestDispatcher requestDispatcher = request.getRequestDispatcher("/fa/test");
        requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    private void doHostJspForward(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestDispatcher requestDispatcher = request.getRequestDispatcher("/../index.jsp");
        requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }
}

