/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.shell.internal.formatting;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.model.management.ManageableArtifact;
import org.eclipse.virgo.kernel.shell.internal.formatting.AbstractInstallArtifactCommandFormatter;
import org.eclipse.virgo.kernel.shell.internal.formatting.PropertyFormatter;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public final class ConfigInstallArtifactCommandFormatter
extends AbstractInstallArtifactCommandFormatter<ManageableArtifact> {
    private final ConfigurationAdmin configurationAdmin;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public ConfigInstallArtifactCommandFormatter(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    @Override
    public List<String> formatExamine(ManageableArtifact artifact) {
        try {
            Configuration configuration;
            ConfigInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
            ArrayList<String> lines = new ArrayList<String>();
            try {
                configuration = this.configurationAdmin.getConfiguration(artifact.getName(), null);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            String factoryPid = configuration.getFactoryPid();
            String bundleLocation = configuration.getBundleLocation();
            lines.add(String.format("Factory pid:     %s", factoryPid == null ? "" : factoryPid));
            lines.add(String.format("Bundle Location: %s", bundleLocation == null ? "" : bundleLocation));
            lines.addAll(this.formatProperties(configuration));
            ArrayList<String> arrayList = lines;
            ConfigInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return arrayList;
        }
        catch (Throwable throwable) {
            ConfigInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    private List<String> formatProperties(Configuration configuration) {
        try {
            ConfigInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
            ArrayList<String> lines = new ArrayList<String>();
            ArrayList<String> propertyKeys = new ArrayList<String>();
            Dictionary properties = configuration.getProperties();
            if (properties != null) {
                Enumeration keys = properties.keys();
                while (keys.hasMoreElements()) {
                    propertyKeys.add((String)keys.nextElement());
                }
                Collections.sort(propertyKeys);
                lines.add("");
                lines.add(String.format("Properties:", new Object[0]));
                for (String propertyKey : propertyKeys) {
                    lines.add(String.format("    %s:", propertyKey));
                    List<String> values = PropertyFormatter.formatPropertyValue(properties.get(propertyKey), 80);
                    for (String value : values) {
                        lines.add(String.format("        %s", value));
                    }
                }
            }
            ArrayList<String> arrayList = lines;
            ConfigInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
            return arrayList;
        }
        catch (Throwable throwable) {
            ConfigInstallArtifactCommandFormatter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("ConfigInstallArtifactCommandFormatter.java", Class.forName("org.eclipse.virgo.kernel.shell.internal.formatting.ConfigInstallArtifactCommandFormatter"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "formatExamine", "org.eclipse.virgo.kernel.shell.internal.formatting.ConfigInstallArtifactCommandFormatter", "org.eclipse.virgo.kernel.model.management.ManageableArtifact:", "artifact:", "", "java.util.List"), 35);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "formatProperties", "org.eclipse.virgo.kernel.shell.internal.formatting.ConfigInstallArtifactCommandFormatter", "org.osgi.service.cm.Configuration:", "configuration:", "", "java.util.List"), 57);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.shell.internal.formatting.ConfigInstallArtifactCommandFormatter");
    }
}

