/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.storage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Properties;

public class SecureUserStore {
    private static final String USER_STORE_FILE_NAME = "org.eclipse.equinox.console.jaas.file";
    private static final String PASSWORD_KEY = "password";
    private static final String ROLES_KEY = "roles";
    private static final String SSH_PREFIX = "/ssh";
    private static final String DELIMITER = "/";
    private static final int USERNAME_INDEX = 2;
    private static final int KEY_ELEMENTS_COUNT = 4;

    public static String[] getUserNames() {
        String userFileLoc = null;
        FileInputStream in = null;
        try {
            userFileLoc = SecureUserStore.getFileLocation();
            in = new FileInputStream(userFileLoc);
            Properties users = null;
            try {
                users = SecureUserStore.populateUserStore(in);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot load properties from file " + userFileLoc);
            }
            HashSet<String> userNames = new HashSet<String>();
            for (Object key : users.keySet()) {
                String[] parts;
                if (!(key instanceof String) || (parts = ((String)key).split(DELIMITER)).length < 4) continue;
                userNames.add(parts[2]);
            }
            String[] stringArray = userNames.toArray(new String[0]);
            return stringArray;
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("File " + userFileLoc + " does not exist");
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String getPassword(String username) {
        return SecureUserStore.getProperty(username, PASSWORD_KEY);
    }

    public static String getRoles(String username) {
        return SecureUserStore.getProperty(username, ROLES_KEY);
    }

    public static void putUser(String username, String password, String roles) {
        String userFileLoc = null;
        InputStream in = null;
        OutputStream out = null;
        try {
            try {
                userFileLoc = SecureUserStore.getFileLocation();
                in = new FileInputStream(userFileLoc);
                Properties users = null;
                try {
                    users = SecureUserStore.populateUserStore(in);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Cannot load properties from file " + userFileLoc);
                }
                if (SecureUserStore.existsUser(username, users)) {
                    throw new IllegalArgumentException("The user already exists!");
                }
                if (roles == null) {
                    roles = "";
                }
                String userPassKey = SecureUserStore.constructPropertyName(username, PASSWORD_KEY);
                String userRolesKey = SecureUserStore.constructPropertyName(username, ROLES_KEY);
                users.put(userPassKey, password);
                users.put(userRolesKey, roles);
                out = new FileOutputStream(userFileLoc);
                try {
                    users.store(out, null);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Cannot store properties in file " + userFileLoc);
                }
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("File " + userFileLoc + " does not exist");
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void addRoles(String username, String roles) {
        String userFileLoc = null;
        InputStream in = null;
        OutputStream out = null;
        try {
            if (roles == null || roles.length() == 0) {
                return;
            }
            try {
                String role;
                int n;
                int n2;
                String[] stringArray;
                userFileLoc = SecureUserStore.getFileLocation();
                in = new FileInputStream(userFileLoc);
                Properties users = null;
                try {
                    users = SecureUserStore.populateUserStore(in);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Cannot load properties from file " + userFileLoc);
                }
                String userRolesKey = SecureUserStore.constructPropertyName(username, ROLES_KEY);
                String currentRoles = (String)users.remove(userRolesKey);
                HashSet<String> rolesSet = new HashSet<String>();
                if (currentRoles.length() > 0) {
                    stringArray = currentRoles.split(",");
                    n2 = stringArray.length;
                    n = 0;
                    while (n < n2) {
                        role = stringArray[n];
                        rolesSet.add(role);
                        ++n;
                    }
                }
                stringArray = roles.split(",");
                n2 = stringArray.length;
                n = 0;
                while (n < n2) {
                    role = stringArray[n];
                    rolesSet.add(role);
                    ++n;
                }
                StringBuilder builder = new StringBuilder();
                for (String role2 : rolesSet) {
                    builder.append(role2);
                    builder.append(",");
                }
                builder.deleteCharAt(builder.lastIndexOf(","));
                users.put(userRolesKey, builder.toString());
                out = new FileOutputStream(userFileLoc);
                try {
                    users.store(out, null);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Cannot store properties in file " + userFileLoc);
                }
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("File " + userFileLoc + " does not exist");
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void removeRoles(String username, String rolesToRemove) {
        String userFileLoc = null;
        InputStream in = null;
        OutputStream out = null;
        try {
            if (rolesToRemove == null || rolesToRemove.length() == 0) {
                return;
            }
            try {
                String role;
                userFileLoc = SecureUserStore.getFileLocation();
                in = new FileInputStream(userFileLoc);
                Properties users = null;
                try {
                    users = SecureUserStore.populateUserStore(in);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Cannot load properties from file " + userFileLoc);
                }
                String userRolesKey = SecureUserStore.constructPropertyName(username, ROLES_KEY);
                String currentRoles = (String)users.remove(userRolesKey);
                HashSet<String> rolesSet = new HashSet<String>();
                String[] stringArray = currentRoles.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    role = stringArray[n2];
                    rolesSet.add(role);
                    ++n2;
                }
                stringArray = rolesToRemove.split(",");
                n = stringArray.length;
                n2 = 0;
                while (n2 < n) {
                    role = stringArray[n2];
                    rolesSet.remove(role);
                    ++n2;
                }
                StringBuilder builder = new StringBuilder();
                for (String role2 : rolesSet) {
                    builder.append(role2);
                    builder.append(",");
                }
                builder.deleteCharAt(builder.lastIndexOf(","));
                users.put(userRolesKey, builder.toString());
                out = new FileOutputStream(userFileLoc);
                try {
                    users.store(out, null);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Cannot store properties in file " + userFileLoc);
                }
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("File " + userFileLoc + " does not exist");
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void deleteUser(String username) {
        String userFileLoc = null;
        InputStream in = null;
        OutputStream out = null;
        try {
            try {
                userFileLoc = SecureUserStore.getFileLocation();
                in = new FileInputStream(userFileLoc);
                Properties users = null;
                try {
                    users = SecureUserStore.populateUserStore(in);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Cannot load properties from file " + userFileLoc);
                }
                if (!SecureUserStore.existsUser(username, users)) {
                    throw new IllegalArgumentException("The user does not exist!");
                }
                String rolesProperty = SecureUserStore.constructPropertyName(username, ROLES_KEY);
                String passwordProperty = SecureUserStore.constructPropertyName(username, PASSWORD_KEY);
                users.remove(rolesProperty);
                users.remove(passwordProperty);
                out = new FileOutputStream(userFileLoc);
                try {
                    users.store(out, null);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Cannot store properties in file " + userFileLoc);
                }
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("File " + userFileLoc + " does not exist");
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void resetPassword(String username) {
        String userFileLoc = null;
        InputStream in = null;
        OutputStream out = null;
        try {
            try {
                userFileLoc = SecureUserStore.getFileLocation();
                in = new FileInputStream(userFileLoc);
                Properties users = null;
                try {
                    users = SecureUserStore.populateUserStore(in);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Cannot load properties from file " + userFileLoc);
                }
                if (!SecureUserStore.existsUser(username, users)) {
                    throw new IllegalArgumentException("The user does not exist!");
                }
                for (Object key : users.keySet()) {
                    if (!(key instanceof String) || !((String)key).contains(DELIMITER + username + DELIMITER + PASSWORD_KEY)) continue;
                    users.remove(key);
                    break;
                }
                out = new FileOutputStream(userFileLoc);
                try {
                    users.store(out, null);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Cannot store properties in file " + userFileLoc);
                }
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("File " + userFileLoc + " does not exist");
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void setPassword(String username, String password) {
        String userFileLoc = null;
        InputStream in = null;
        OutputStream out = null;
        try {
            try {
                userFileLoc = SecureUserStore.getFileLocation();
                in = new FileInputStream(userFileLoc);
                Properties users = null;
                try {
                    users = SecureUserStore.populateUserStore(in);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Cannot load properties from file " + userFileLoc);
                }
                if (!SecureUserStore.existsUser(username, users)) {
                    throw new IllegalArgumentException("The user does not exist!");
                }
                String passwordPropertyName = SecureUserStore.constructPropertyName(username, PASSWORD_KEY);
                for (Object key : users.keySet()) {
                    if (!(key instanceof String) || !((String)key).contains(passwordPropertyName)) continue;
                    users.remove(key);
                    break;
                }
                users.put(passwordPropertyName, password);
                out = new FileOutputStream(userFileLoc);
                try {
                    users.store(out, null);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Cannot store properties in file " + userFileLoc);
                }
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("File " + userFileLoc + " does not exist");
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean existsUser(String username) {
        String userFileLoc = null;
        FileInputStream in = null;
        try {
            userFileLoc = SecureUserStore.getFileLocation();
            in = new FileInputStream(userFileLoc);
            Properties users = null;
            try {
                users = SecureUserStore.populateUserStore(in);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot load properties from file " + userFileLoc);
            }
            boolean bl = SecureUserStore.existsUser(username, users);
            return bl;
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("File " + userFileLoc + " does not exist");
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void initStorage() throws IOException {
        String userFileLoc = SecureUserStore.getFileLocation();
        File file = new File(userFileLoc);
        if (!file.exists()) {
            OutputStream out = null;
            try {
                Properties props = new Properties();
                out = new FileOutputStream(file);
                props.store(out, null);
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    private static String getProperty(String username, String propertyName) {
        String userFileLoc = null;
        FileInputStream in = null;
        try {
            userFileLoc = SecureUserStore.getFileLocation();
            in = new FileInputStream(userFileLoc);
            Properties users = null;
            try {
                users = SecureUserStore.populateUserStore(in);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot load properties from file " + userFileLoc);
            }
            String string = users.getProperty(SecureUserStore.constructPropertyName(username, propertyName));
            return string;
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("File " + userFileLoc + " does not exist");
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static Properties populateUserStore(InputStream in) throws IOException {
        Properties userProperties = new Properties();
        userProperties.load(in);
        return userProperties;
    }

    private static String getFileLocation() {
        String userFileLoc = System.getProperty(USER_STORE_FILE_NAME);
        if (userFileLoc == null) {
            throw new IllegalArgumentException("Property org.eclipse.equinox.console.jaas.file is not set; cannot use JAAS authentication");
        }
        return userFileLoc;
    }

    private static String constructPropertyName(String user, String propertyName) {
        StringBuilder builder = new StringBuilder();
        builder.append(SSH_PREFIX);
        builder.append(DELIMITER);
        builder.append(user);
        builder.append(DELIMITER);
        builder.append(propertyName);
        return builder.toString();
    }

    private static boolean existsUser(String username, Properties users) {
        for (Object user : users.keySet()) {
            if (!(user instanceof String) || !((String)user).contains(DELIMITER + username + DELIMITER)) continue;
            return true;
        }
        return false;
    }
}

