/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.annotation;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.beans.factory.support.MergedBeanDefinitionPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.PriorityOrdered;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitDestroyAnnotationBeanPostProcessor
implements DestructionAwareBeanPostProcessor,
MergedBeanDefinitionPostProcessor,
PriorityOrdered,
Serializable {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private Class<? extends Annotation> initAnnotationType;
    private Class<? extends Annotation> destroyAnnotationType;
    private int order = Integer.MAX_VALUE;
    private final transient Map<Class<?>, LifecycleMetadata> lifecycleMetadataCache = new ConcurrentHashMap();

    public void setInitAnnotationType(Class<? extends Annotation> initAnnotationType) {
        this.initAnnotationType = initAnnotationType;
    }

    public void setDestroyAnnotationType(Class<? extends Annotation> destroyAnnotationType) {
        this.destroyAnnotationType = destroyAnnotationType;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    @Override
    public void postProcessMergedBeanDefinition(RootBeanDefinition beanDefinition, Class beanType, String beanName) {
        if (beanType != null) {
            LifecycleMetadata metadata = this.findLifecycleMetadata(beanType);
            metadata.checkConfigMembers(beanDefinition);
        }
    }

    @Override
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        LifecycleMetadata metadata = this.findLifecycleMetadata(bean.getClass());
        try {
            metadata.invokeInitMethods(bean, beanName);
        }
        catch (InvocationTargetException ex) {
            throw new BeanCreationException(beanName, "Invocation of init method failed", ex.getTargetException());
        }
        catch (Throwable ex) {
            throw new BeanCreationException(beanName, "Couldn't invoke init method", ex);
        }
        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    @Override
    public void postProcessBeforeDestruction(Object bean, String beanName) throws BeansException {
        LifecycleMetadata metadata = this.findLifecycleMetadata(bean.getClass());
        try {
            metadata.invokeDestroyMethods(bean, beanName);
        }
        catch (InvocationTargetException ex) {
            String msg = "Invocation of destroy method failed on bean with name '" + beanName + "'";
            if (this.logger.isDebugEnabled()) {
                this.logger.warn((Object)msg, ex.getTargetException());
            } else {
                this.logger.warn((Object)(String.valueOf(msg) + ": " + ex.getTargetException()));
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)("Couldn't invoke destroy method on bean with name '" + beanName + "'"), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LifecycleMetadata findLifecycleMetadata(Class clazz) {
        if (this.lifecycleMetadataCache == null) {
            return this.buildLifecycleMetadata(clazz);
        }
        LifecycleMetadata metadata = this.lifecycleMetadataCache.get(clazz);
        if (metadata == null) {
            Map<Class<?>, LifecycleMetadata> map = this.lifecycleMetadataCache;
            synchronized (map) {
                metadata = this.lifecycleMetadataCache.get(clazz);
                if (metadata == null) {
                    metadata = this.buildLifecycleMetadata(clazz);
                    this.lifecycleMetadataCache.put(clazz, metadata);
                }
                return metadata;
            }
        }
        return metadata;
    }

    private LifecycleMetadata buildLifecycleMetadata(Class clazz) {
        boolean debug = this.logger.isDebugEnabled();
        LinkedList<LifecycleElement> initMethods = new LinkedList<LifecycleElement>();
        LinkedList<LifecycleElement> destroyMethods = new LinkedList<LifecycleElement>();
        Class targetClass = clazz;
        do {
            LinkedList<LifecycleElement> currInitMethods = new LinkedList<LifecycleElement>();
            LinkedList<LifecycleElement> currDestroyMethods = new LinkedList<LifecycleElement>();
            Method[] methodArray = targetClass.getDeclaredMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (this.initAnnotationType != null && method.getAnnotation(this.initAnnotationType) != null) {
                    LifecycleElement element = new LifecycleElement(method);
                    currInitMethods.add(element);
                    if (debug) {
                        this.logger.debug((Object)("Found init method on class [" + clazz.getName() + "]: " + method));
                    }
                }
                if (this.destroyAnnotationType != null && method.getAnnotation(this.destroyAnnotationType) != null) {
                    currDestroyMethods.add(new LifecycleElement(method));
                    if (debug) {
                        this.logger.debug((Object)("Found destroy method on class [" + clazz.getName() + "]: " + method));
                    }
                }
                ++n2;
            }
            initMethods.addAll(0, currInitMethods);
            destroyMethods.addAll(currDestroyMethods);
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
        return new LifecycleMetadata(clazz, initMethods, destroyMethods);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.logger = LogFactory.getLog(this.getClass());
    }

    private static class LifecycleElement {
        private final Method method;
        private final String identifier;

        public LifecycleElement(Method method) {
            if (method.getParameterTypes().length != 0) {
                throw new IllegalStateException("Lifecycle method annotation requires a no-arg method: " + method);
            }
            this.method = method;
            this.identifier = Modifier.isPrivate(method.getModifiers()) ? method.getDeclaringClass() + "." + method.getName() : method.getName();
        }

        public Method getMethod() {
            return this.method;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public void invoke(Object target) throws Throwable {
            ReflectionUtils.makeAccessible((Method)this.method);
            this.method.invoke(target, null);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LifecycleElement)) {
                return false;
            }
            LifecycleElement otherElement = (LifecycleElement)other;
            return this.identifier.equals(otherElement.identifier);
        }

        public int hashCode() {
            return this.identifier.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LifecycleMetadata {
        private final Set<LifecycleElement> initMethods = new LinkedHashSet<LifecycleElement>();
        private final Set<LifecycleElement> destroyMethods;

        public LifecycleMetadata(Class targetClass, Collection<LifecycleElement> initMethods, Collection<LifecycleElement> destroyMethods) {
            for (LifecycleElement element : initMethods) {
                if (InitDestroyAnnotationBeanPostProcessor.this.logger.isDebugEnabled()) {
                    InitDestroyAnnotationBeanPostProcessor.this.logger.debug((Object)("Found init method on class [" + targetClass.getName() + "]: " + element));
                }
                this.initMethods.add(element);
            }
            this.destroyMethods = new LinkedHashSet<LifecycleElement>();
            for (LifecycleElement element : destroyMethods) {
                if (InitDestroyAnnotationBeanPostProcessor.this.logger.isDebugEnabled()) {
                    InitDestroyAnnotationBeanPostProcessor.this.logger.debug((Object)("Found destroy method on class [" + targetClass.getName() + "]: " + element));
                }
                this.destroyMethods.add(element);
            }
        }

        public void checkConfigMembers(RootBeanDefinition beanDefinition) {
            String methodIdentifier;
            Iterator<LifecycleElement> it = this.initMethods.iterator();
            while (it.hasNext()) {
                methodIdentifier = it.next().getIdentifier();
                if (!beanDefinition.isExternallyManagedInitMethod(methodIdentifier)) {
                    beanDefinition.registerExternallyManagedInitMethod(methodIdentifier);
                    continue;
                }
                it.remove();
            }
            it = this.destroyMethods.iterator();
            while (it.hasNext()) {
                methodIdentifier = it.next().getIdentifier();
                if (!beanDefinition.isExternallyManagedDestroyMethod(methodIdentifier)) {
                    beanDefinition.registerExternallyManagedDestroyMethod(methodIdentifier);
                    continue;
                }
                it.remove();
            }
        }

        public void invokeInitMethods(Object target, String beanName) throws Throwable {
            if (!this.initMethods.isEmpty()) {
                boolean debug = InitDestroyAnnotationBeanPostProcessor.this.logger.isDebugEnabled();
                for (LifecycleElement element : this.initMethods) {
                    if (debug) {
                        InitDestroyAnnotationBeanPostProcessor.this.logger.debug((Object)("Invoking init method on bean '" + beanName + "': " + element.getMethod()));
                    }
                    element.invoke(target);
                }
            }
        }

        public void invokeDestroyMethods(Object target, String beanName) throws Throwable {
            if (!this.destroyMethods.isEmpty()) {
                boolean debug = InitDestroyAnnotationBeanPostProcessor.this.logger.isDebugEnabled();
                for (LifecycleElement element : this.destroyMethods) {
                    if (debug) {
                        InitDestroyAnnotationBeanPostProcessor.this.logger.debug((Object)("Invoking destroy method on bean '" + beanName + "': " + element.getMethod()));
                    }
                    element.invoke(target);
                }
            }
        }
    }
}

