/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal.bundle;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.artifact.fs.ArtifactFS;
import org.eclipse.virgo.kernel.artifact.fs.ArtifactFSEntry;
import org.eclipse.virgo.kernel.deployer.core.DeploymentException;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentityDeterminer;
import org.eclipse.virgo.kernel.install.artifact.ArtifactStorage;
import org.eclipse.virgo.kernel.install.artifact.BundleInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.internal.InstallArtifactRefreshHandler;
import org.eclipse.virgo.kernel.install.artifact.internal.StandardArtifactStateMonitor;
import org.eclipse.virgo.kernel.install.artifact.internal.bundle.BundleDriverFactory;
import org.eclipse.virgo.kernel.install.artifact.internal.bundle.StandardBundleDriver;
import org.eclipse.virgo.kernel.install.artifact.internal.bundle.StandardBundleInstallArtifact;
import org.eclipse.virgo.kernel.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.util.io.IOUtils;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.util.osgi.manifest.BundleManifestFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

final class BundleInstallArtifactFactory {
    private static final Version DEFAULT_BUNDLE_VERSION;
    private final BundleContext kernelBundleContext;
    private final InstallArtifactRefreshHandler refreshHandler;
    private final BundleDriverFactory bundleDriverFactory;
    private final EventLogger eventLogger;
    private final ArtifactIdentityDeterminer identityDeterminer;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    static {
        Factory factory = new Factory("BundleInstallArtifactFactory.java", Class.forName("org.eclipse.virgo.kernel.install.artifact.internal.bundle.BundleInstallArtifactFactory"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "createBundleInstallArtifact", "org.eclipse.virgo.kernel.install.artifact.internal.bundle.BundleInstallArtifactFactory", "org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity:org.eclipse.virgo.kernel.install.artifact.ArtifactStorage:java.lang.String:", "identity:artifactStorage:repositoryName:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "org.eclipse.virgo.kernel.install.artifact.BundleInstallArtifact"), 73);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "retrieveArtifactFSManifest", "org.eclipse.virgo.kernel.install.artifact.internal.bundle.BundleInstallArtifactFactory", "org.eclipse.virgo.kernel.artifact.fs.ArtifactFS:", "artifactFS:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "org.eclipse.virgo.util.osgi.manifest.BundleManifest"), 87);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("8", "determineName", "org.eclipse.virgo.kernel.install.artifact.internal.bundle.BundleInstallArtifactFactory", "org.eclipse.virgo.util.osgi.manifest.BundleManifest:org.eclipse.virgo.kernel.artifact.fs.ArtifactFS:", "bundleManifest:artifactFS:", "", "java.lang.String"), 114);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.install.artifact.internal.bundle.BundleInstallArtifactFactory");
        DEFAULT_BUNDLE_VERSION = Version.emptyVersion;
    }

    BundleInstallArtifactFactory(BundleContext kernelBundleContext, InstallArtifactRefreshHandler refreshHandler, BundleDriverFactory bundleDriverFactory, EventLogger eventLogger, ArtifactIdentityDeterminer identityDeterminer) {
        try {
            this.kernelBundleContext = kernelBundleContext;
            this.refreshHandler = refreshHandler;
            this.bundleDriverFactory = bundleDriverFactory;
            this.eventLogger = eventLogger;
            this.identityDeterminer = identityDeterminer;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    BundleInstallArtifact createBundleInstallArtifact(ArtifactIdentity identity, ArtifactStorage artifactStorage, String repositoryName) throws DeploymentException {
        try {
            try {
                BundleInstallArtifactFactory.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_0);
                StandardArtifactStateMonitor artifactStateMonitor = new StandardArtifactStateMonitor(this.kernelBundleContext);
                StandardBundleDriver bundleDriver = this.bundleDriverFactory.createBundleDriver(identity, artifactStateMonitor);
                BundleManifest bundleManifest = this.retrieveArtifactFSManifest(artifactStorage.getArtifactFS());
                StandardBundleInstallArtifact bundleInstallArtifact = new StandardBundleInstallArtifact(identity, bundleManifest, artifactStorage, bundleDriver, artifactStateMonitor, this.refreshHandler, repositoryName, this.eventLogger, this.identityDeterminer);
                bundleDriver.setInstallArtifact(bundleInstallArtifact);
                StandardBundleInstallArtifact standardBundleInstallArtifact = bundleInstallArtifact;
                BundleInstallArtifactFactory.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_0);
                return standardBundleInstallArtifact;
            }
            catch (Throwable throwable) {
                BundleInstallArtifactFactory.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_0);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private BundleManifest retrieveArtifactFSManifest(ArtifactFS artifactFS) throws DeploymentException {
        try {
            try {
                BundleManifest bundleManifest;
                block10: {
                    BundleInstallArtifactFactory.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
                    ArtifactFSEntry manifestEntry = artifactFS.getEntry("META-INF/MANIFEST.MF");
                    if (manifestEntry != null && manifestEntry.exists()) {
                        BundleManifest bundleManifest2;
                        InputStreamReader manifestReader = new InputStreamReader(manifestEntry.getInputStream());
                        try {
                            bundleManifest2 = BundleManifestFactory.createBundleManifest((Reader)manifestReader);
                        }
                        catch (Throwable throwable) {
                            try {
                                IOUtils.closeQuietly((Closeable)manifestReader);
                                throw throwable;
                            }
                            catch (IOException ioe) {
                                throw new DeploymentException("Failed to read manifest for bundle from " + artifactFS, ioe);
                            }
                        }
                        IOUtils.closeQuietly((Closeable)manifestReader);
                        bundleManifest = bundleManifest2;
                        break block10;
                    }
                    bundleManifest = BundleManifestFactory.createBundleManifest();
                }
                BundleInstallArtifactFactory.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
                return bundleManifest;
            }
            catch (Throwable throwable) {
                BundleInstallArtifactFactory.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static Version getVersionFromManifest(BundleManifest bundleManifest) {
        try {
            Version version = bundleManifest.getBundleVersion();
            return version == null ? DEFAULT_BUNDLE_VERSION : version;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static String getNameFromManifest(BundleManifest bundleManifest) {
        try {
            return bundleManifest.getBundleSymbolicName().getSymbolicName();
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static String determineName(BundleManifest bundleManifest, ArtifactFS artifactFS) {
        try {
            try {
                BundleInstallArtifactFactory.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
                String name = BundleInstallArtifactFactory.getNameFromManifest(bundleManifest);
                if (name == null) {
                    name = artifactFS.getFile().getName();
                }
                String string = name;
                BundleInstallArtifactFactory.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
                return string;
            }
            catch (Throwable throwable) {
                BundleInstallArtifactFactory.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }
}

