/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.session;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import org.apache.catalina.Realm;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class SerializablePrincipal
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(SerializablePrincipal.class);
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.ha.session");
    protected String name = null;
    protected String password = null;
    protected transient Realm realm = null;
    protected String[] roles = new String[0];
    protected Principal userPrincipal = null;

    public SerializablePrincipal() {
    }

    public SerializablePrincipal(String name, String password) {
        this(name, password, null);
    }

    public SerializablePrincipal(String name, String password, List<String> roles) {
        this(name, password, roles, null);
    }

    public SerializablePrincipal(String name, String password, List<String> roles, Principal userPrincipal) {
        this.name = name;
        this.password = password;
        if (roles != null) {
            this.roles = new String[roles.size()];
            this.roles = roles.toArray(this.roles);
            if (this.roles.length > 0) {
                Arrays.sort(this.roles);
            }
        }
        if (userPrincipal instanceof Serializable) {
            this.userPrincipal = userPrincipal;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getPassword() {
        return this.password;
    }

    public Realm getRealm() {
        return this.realm;
    }

    public void setRealm(Realm realm) {
        this.realm = realm;
    }

    public String[] getRoles() {
        return this.roles;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SerializablePrincipal[");
        sb.append(this.name);
        sb.append("]");
        return sb.toString();
    }

    public static SerializablePrincipal createPrincipal(GenericPrincipal principal) {
        if (principal == null) {
            return null;
        }
        return new SerializablePrincipal(principal.getName(), principal.getPassword(), principal.getRoles() != null ? Arrays.asList(principal.getRoles()) : null, principal.getUserPrincipal() != principal ? principal.getUserPrincipal() : null);
    }

    public GenericPrincipal getPrincipal() {
        return new GenericPrincipal(this.name, this.password, this.getRoles() != null ? Arrays.asList(this.getRoles()) : null, this.userPrincipal);
    }

    public static GenericPrincipal readPrincipal(ObjectInput in) throws IOException, ClassNotFoundException {
        String name = in.readUTF();
        boolean hasPwd = in.readBoolean();
        String pwd = null;
        if (hasPwd) {
            pwd = in.readUTF();
        }
        int size = in.readInt();
        String[] roles = new String[size];
        for (int i = 0; i < size; ++i) {
            roles[i] = in.readUTF();
        }
        Principal userPrincipal = null;
        boolean hasUserPrincipal = in.readBoolean();
        if (hasUserPrincipal) {
            try {
                userPrincipal = (Principal)in.readObject();
            }
            catch (ClassNotFoundException e) {
                log.error((Object)sm.getString("serializablePrincipal.readPrincipal.cnfe"), (Throwable)e);
                throw e;
            }
        }
        return new GenericPrincipal(name, pwd, Arrays.asList(roles), userPrincipal);
    }

    public static void writePrincipal(GenericPrincipal p, ObjectOutput out) throws IOException {
        String[] roles;
        out.writeUTF(p.getName());
        out.writeBoolean(p.getPassword() != null);
        if (p.getPassword() != null) {
            out.writeUTF(p.getPassword());
        }
        if ((roles = p.getRoles()) == null) {
            roles = new String[]{};
        }
        out.writeInt(roles.length);
        for (int i = 0; i < roles.length; ++i) {
            out.writeUTF(roles[i]);
        }
        boolean hasUserPrincipal = p != p.getUserPrincipal() && p.getUserPrincipal() instanceof Serializable;
        out.writeBoolean(hasUserPrincipal);
        if (hasUserPrincipal) {
            out.writeObject(p.getUserPrincipal());
        }
    }
}

