/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal;

import java.util.concurrent.ConcurrentHashMap;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.deployer.core.DeployerLogEvents;
import org.eclipse.virgo.kernel.deployer.core.DeploymentException;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifactLifecycleListenerSupport;
import org.eclipse.virgo.kernel.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.util.common.Tree;

final class TreeRestrictingInstallArtifactLifecycleListener
extends InstallArtifactLifecycleListenerSupport {
    private final ConcurrentHashMap<ArtifactIdentity, InstallArtifact> artifactMap;
    private final EventLogger eventLogger;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public TreeRestrictingInstallArtifactLifecycleListener(EventLogger eventLogger) {
        try {
            this.artifactMap = new ConcurrentHashMap();
            this.eventLogger = eventLogger;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void onInstalling(InstallArtifact installArtifact) throws DeploymentException {
        try {
            try {
                TreeRestrictingInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                ArtifactIdentity artifactIdentity = this.getArtifactIdentity(installArtifact);
                InstallArtifact oldInstallArtifact = this.artifactMap.putIfAbsent(artifactIdentity, installArtifact);
                if (oldInstallArtifact != null) {
                    InstallArtifact oldRootInstallArtifact = this.getRoot(oldInstallArtifact);
                    this.eventLogger.log((LogEvent)DeployerLogEvents.INSTALL_ARTIFACT_DAG_NOT_SUPPORTED, new Object[]{artifactIdentity.getType(), artifactIdentity.getName(), artifactIdentity.getVersion(), oldRootInstallArtifact.getType(), oldRootInstallArtifact.getName(), oldRootInstallArtifact.getVersion()});
                    throw new DeploymentException("InstallArtifact " + artifactIdentity + " was installed when " + this.getArtifactIdentity(oldRootInstallArtifact) + " was installed", true);
                }
                TreeRestrictingInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                return;
            }
            catch (Throwable throwable) {
                TreeRestrictingInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private ArtifactIdentity getArtifactIdentity(InstallArtifact installArtifact) {
        try {
            return new ArtifactIdentity(installArtifact.getType(), installArtifact.getName(), installArtifact.getVersion(), installArtifact.getScopeName());
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private InstallArtifact getRoot(InstallArtifact installArtifact) {
        try {
            InstallArtifact root = installArtifact;
            Tree rootParent = root.getTree();
            while (rootParent != null) {
                root = (InstallArtifact)rootParent.getValue();
                rootParent = rootParent.getParent();
            }
            return root;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void onInstallFailed(InstallArtifact installArtifact) throws DeploymentException {
        try {
            try {
                TreeRestrictingInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
                this.remove(installArtifact);
                TreeRestrictingInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
                return;
            }
            catch (Throwable throwable) {
                TreeRestrictingInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void onUninstalled(InstallArtifact installArtifact) throws DeploymentException {
        try {
            try {
                TreeRestrictingInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_2);
                this.remove(installArtifact);
                TreeRestrictingInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_2);
                return;
            }
            catch (Throwable throwable) {
                TreeRestrictingInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_2);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void remove(InstallArtifact installArtifact) {
        try {
            try {
                TreeRestrictingInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
                ArtifactIdentity artifactIdentity = this.getArtifactIdentity(installArtifact);
                this.artifactMap.remove(artifactIdentity);
                TreeRestrictingInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
                return;
            }
            catch (Throwable throwable) {
                TreeRestrictingInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static {
        Factory factory = new Factory("TreeRestrictingInstallArtifactLifecycleListener.java", Class.forName("org.eclipse.virgo.kernel.install.artifact.internal.TreeRestrictingInstallArtifactLifecycleListener"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onInstalling", "org.eclipse.virgo.kernel.install.artifact.internal.TreeRestrictingInstallArtifactLifecycleListener", "org.eclipse.virgo.kernel.install.artifact.InstallArtifact:", "installArtifact:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 57);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onInstallFailed", "org.eclipse.virgo.kernel.install.artifact.internal.TreeRestrictingInstallArtifactLifecycleListener", "org.eclipse.virgo.kernel.install.artifact.InstallArtifact:", "installArtifact:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 91);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onUninstalled", "org.eclipse.virgo.kernel.install.artifact.internal.TreeRestrictingInstallArtifactLifecycleListener", "org.eclipse.virgo.kernel.install.artifact.InstallArtifact:", "installArtifact:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 99);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "remove", "org.eclipse.virgo.kernel.install.artifact.internal.TreeRestrictingInstallArtifactLifecycleListener", "org.eclipse.virgo.kernel.install.artifact.InstallArtifact:", "installArtifact:", "", "void"), 103);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.install.artifact.internal.TreeRestrictingInstallArtifactLifecycleListener");
    }
}

