/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.tomcat.internal;

import java.lang.instrument.ClassFileTransformer;
import org.eclipse.gemini.web.tomcat.spi.ClassLoaderCustomizer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

final class DelegatingClassLoaderCustomizer
implements ClassLoaderCustomizer {
    private final BundleContext context;
    private final ServiceTracker tracker;
    private volatile ClassLoaderCustomizer delegate;

    public DelegatingClassLoaderCustomizer(BundleContext context) {
        this.context = context;
        this.tracker = new ServiceTracker(context, ClassLoaderCustomizer.class.getName(), (ServiceTrackerCustomizer)new Customizer());
    }

    public void open() {
        this.tracker.open();
    }

    public void close() {
        this.tracker.close();
    }

    public void addClassFileTransformer(ClassFileTransformer transformer, Bundle bundle) {
        if (this.delegate != null) {
            this.delegate.addClassFileTransformer(transformer, bundle);
        }
    }

    public ClassLoader createThrowawayClassLoader(Bundle bundle) {
        if (this.delegate != null) {
            return this.delegate.createThrowawayClassLoader(bundle);
        }
        return null;
    }

    public ClassLoader[] extendClassLoaderChain(Bundle bundle) {
        if (this.delegate != null) {
            return this.delegate.extendClassLoaderChain(bundle);
        }
        return new ClassLoader[0];
    }

    private class Customizer
    implements ServiceTrackerCustomizer {
        private Customizer() {
        }

        public Object addingService(ServiceReference reference) {
            ClassLoaderCustomizer newDelegate = (ClassLoaderCustomizer)DelegatingClassLoaderCustomizer.this.context.getService(reference);
            if (DelegatingClassLoaderCustomizer.this.delegate == null) {
                DelegatingClassLoaderCustomizer.this.delegate = newDelegate;
            }
            return newDelegate;
        }

        public void modifiedService(ServiceReference reference, Object service) {
        }

        public void removedService(ServiceReference reference, Object service) {
            DelegatingClassLoaderCustomizer.this.context.ungetService(reference);
            DelegatingClassLoaderCustomizer.this.delegate = null;
        }
    }
}

