/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.eventadmin.impl.adapter;

import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class BundleEventAdapter
implements BundleListener {
    private final EventAdmin m_admin;
    static /* synthetic */ Class class$org$osgi$framework$BundleEvent;

    public BundleEventAdapter(BundleContext context, EventAdmin admin) {
        if (null == admin) {
            throw new NullPointerException("EventAdmin must not be null");
        }
        this.m_admin = admin;
        context.addBundleListener((BundleListener)this);
    }

    public void bundleChanged(BundleEvent event) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("event", event);
        ((Dictionary)properties).put("bundle.id", new Long(event.getBundle().getBundleId()));
        String symbolicName = event.getBundle().getSymbolicName();
        if (null != symbolicName) {
            ((Dictionary)properties).put("bundle.symbolicName", symbolicName);
        }
        ((Dictionary)properties).put("bundle", event.getBundle());
        StringBuffer topic = new StringBuffer((class$org$osgi$framework$BundleEvent == null ? (class$org$osgi$framework$BundleEvent = BundleEventAdapter.class$("org.osgi.framework.BundleEvent")) : class$org$osgi$framework$BundleEvent).getName().replace('.', '/')).append('/');
        switch (event.getType()) {
            case 1: {
                topic.append("INSTALLED");
                break;
            }
            case 2: {
                topic.append("STARTED");
                break;
            }
            case 4: {
                topic.append("STOPPED");
                break;
            }
            case 8: {
                topic.append("UPDATED");
                break;
            }
            case 16: {
                topic.append("UNINSTALLED");
                break;
            }
            case 32: {
                topic.append("RESOLVED");
                break;
            }
            case 64: {
                topic.append("UNRESOLVED");
                break;
            }
            default: {
                return;
            }
        }
        try {
            this.m_admin.postEvent(new Event(topic.toString(), properties));
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

