/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.converter;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileCacheImageInputStream;
import javax.imageio.stream.FileCacheImageOutputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferedImageHttpMessageConverter
implements HttpMessageConverter<BufferedImage> {
    private List<MediaType> readableMediaTypes = new ArrayList<MediaType>();
    private MediaType defaultContentType;
    private File cacheDir;

    public BufferedImageHttpMessageConverter() {
        String[] readerMediaTypes;
        String[] stringArray = readerMediaTypes = ImageIO.getReaderMIMETypes();
        int n = readerMediaTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String mediaType = stringArray[n2];
            this.readableMediaTypes.add(MediaType.parseMediaType(mediaType));
            ++n2;
        }
        String[] writerMediaTypes = ImageIO.getWriterMIMETypes();
        if (writerMediaTypes.length > 0) {
            this.defaultContentType = MediaType.parseMediaType(writerMediaTypes[0]);
        }
    }

    public MediaType getDefaultContentType() {
        return this.defaultContentType;
    }

    public void setDefaultContentType(MediaType defaultContentType) {
        Assert.notNull((Object)defaultContentType, (String)"'contentType' must not be null");
        Iterator<ImageWriter> imageWriters = ImageIO.getImageWritersByMIMEType(defaultContentType.toString());
        if (!imageWriters.hasNext()) {
            throw new IllegalArgumentException("ContentType [" + defaultContentType + "] is not supported by the Java Image I/O API");
        }
        this.defaultContentType = defaultContentType;
    }

    public void setCacheDir(File cacheDir) {
        Assert.notNull((Object)cacheDir, (String)"'cacheDir' must not be null");
        Assert.isTrue((boolean)cacheDir.isDirectory(), (String)"'cacheDir' is not a directory");
        this.cacheDir = cacheDir;
    }

    @Override
    public boolean canRead(Class<? extends BufferedImage> clazz, MediaType mediaType) {
        if (BufferedImage.class.equals(clazz)) {
            return this.isReadable(mediaType);
        }
        return false;
    }

    private boolean isReadable(MediaType mediaType) {
        if (mediaType == null) {
            return true;
        }
        Iterator<ImageReader> imageReaders = ImageIO.getImageReadersByMIMEType(mediaType.toString());
        return imageReaders.hasNext();
    }

    @Override
    public boolean canWrite(Class<? extends BufferedImage> clazz, MediaType mediaType) {
        if (BufferedImage.class.equals(clazz)) {
            return this.isWritable(mediaType);
        }
        return false;
    }

    private boolean isWritable(MediaType mediaType) {
        if (mediaType == null) {
            return true;
        }
        Iterator<ImageWriter> imageWriters = ImageIO.getImageWritersByMIMEType(mediaType.toString());
        return imageWriters.hasNext();
    }

    @Override
    public List<MediaType> getSupportedMediaTypes() {
        return Collections.unmodifiableList(this.readableMediaTypes);
    }

    @Override
    public BufferedImage read(Class<BufferedImage> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        MediaType contentType;
        block10: {
            BufferedImage bufferedImage;
            block11: {
                ImageInputStream imageInputStream = null;
                ImageReader imageReader = null;
                try {
                    imageInputStream = this.createImageInputStream(inputMessage.getBody());
                    contentType = inputMessage.getHeaders().getContentType();
                    Iterator<ImageReader> imageReaders = ImageIO.getImageReadersByMIMEType(contentType.toString());
                    if (!imageReaders.hasNext()) break block10;
                    imageReader = imageReaders.next();
                    ImageReadParam irp = imageReader.getDefaultReadParam();
                    this.process(irp);
                    imageReader.setInput(imageInputStream, true);
                    bufferedImage = imageReader.read(0, irp);
                    if (imageReader != null) {
                        imageReader.dispose();
                    }
                    if (imageInputStream == null) break block11;
                }
                catch (Throwable throwable) {
                    if (imageReader != null) {
                        imageReader.dispose();
                    }
                    if (imageInputStream != null) {
                        try {
                            imageInputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    imageInputStream.close();
                }
                catch (IOException iOException) {}
            }
            return bufferedImage;
        }
        throw new HttpMessageNotReadableException("Could not find javax.imageio.ImageReader for Content-Type [" + contentType + "]");
    }

    private ImageInputStream createImageInputStream(InputStream is) throws IOException {
        if (this.cacheDir != null) {
            return new FileCacheImageInputStream(is, this.cacheDir);
        }
        return new MemoryCacheImageInputStream(is);
    }

    @Override
    public void write(BufferedImage image, MediaType contentType, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        if (contentType == null) {
            contentType = this.getDefaultContentType();
        }
        Assert.notNull((Object)contentType, (String)"Count not determine Content-Type, set one using the 'defaultContentType' property");
        outputMessage.getHeaders().setContentType(contentType);
        ImageOutputStream imageOutputStream = null;
        ImageWriter imageWriter = null;
        try {
            imageOutputStream = this.createImageOutputStream(outputMessage.getBody());
            Iterator<ImageWriter> imageWriters = ImageIO.getImageWritersByMIMEType(contentType.toString());
            if (!imageWriters.hasNext()) {
                throw new HttpMessageNotWritableException("Could not find javax.imageio.ImageWriter for Content-Type [" + contentType + "]");
            }
            imageWriter = imageWriters.next();
            ImageWriteParam iwp = imageWriter.getDefaultWriteParam();
            this.process(iwp);
            imageWriter.setOutput(imageOutputStream);
            imageWriter.write(null, new IIOImage(image, null, null), iwp);
        }
        catch (Throwable throwable) {
            if (imageWriter != null) {
                imageWriter.dispose();
            }
            if (imageOutputStream != null) {
                try {
                    imageOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (imageWriter != null) {
            imageWriter.dispose();
        }
        if (imageOutputStream != null) {
            try {
                imageOutputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private ImageOutputStream createImageOutputStream(OutputStream os) throws IOException {
        if (this.cacheDir != null) {
            return new FileCacheImageOutputStream(os, this.cacheDir);
        }
        return new MemoryCacheImageOutputStream(os);
    }

    protected void process(ImageReadParam irp) {
    }

    protected void process(ImageWriteParam iwp) {
    }
}

