/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.repository.internal.remote;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.repository.internal.remote.DescriptorStore;
import org.eclipse.virgo.util.io.FileCopyUtils;
import org.eclipse.virgo.util.io.FileSystemUtils;

public class DescriptorStoreFactory {
    private static final long EPOCH = 0L;
    private static final String REPOSITORY_NAME_ETAG_SEPARATOR = "-";
    private static final String DESCRIPTOR_STORE_FILE_SUFFIX = ".descriptors";
    private final Object monitor = new Object();
    private final String repositoryName;
    private final File descriptorStoreDirectory;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

    public DescriptorStoreFactory(String repositoryName, File descriptorStoreDirectory) {
        this.repositoryName = repositoryName;
        this.descriptorStoreDirectory = descriptorStoreDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DescriptorStore createDescriptorStore(InputStream storeStream, String etag) throws IOException, FileNotFoundException {
        Object object = this.monitor;
        synchronized (object) {
            File newStoreLocation = this.createStoreFile(etag);
            FileCopyUtils.copy((InputStream)storeStream, (OutputStream)new FileOutputStream(newStoreLocation));
            return new DescriptorStore(etag, newStoreLocation);
        }
    }

    private File createStoreFile(String etag) {
        return new File(this.descriptorStoreDirectory, String.valueOf(this.repositoryName) + REPOSITORY_NAME_ETAG_SEPARATOR + etag + DESCRIPTOR_STORE_FILE_SUFFIX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DescriptorStore recoverDescriptorStore() {
        Object object = this.monitor;
        synchronized (object) {
            String eTag;
            File descriptorStoreFile = this.recoverDescriptorStoreFile();
            if (descriptorStoreFile != null && (eTag = this.parseETagFromDescriptorStoreFileName(descriptorStoreFile.getName())) != null) {
                return new DescriptorStore(eTag, descriptorStoreFile);
            }
            return null;
        }
    }

    private File recoverDescriptorStoreFile() {
        return DescriptorStoreFactory.getMostRecentFile(this.getDescriptorStoreFiles());
    }

    private String parseETagFromDescriptorStoreFileName(String name) {
        String eTag = null;
        if (this.isValidDescriptorStoreFileName(name)) {
            eTag = name.substring(this.descriptorStoreFileNamePrefix().length(), name.length() - DESCRIPTOR_STORE_FILE_SUFFIX.length());
        }
        return eTag;
    }

    private boolean isValidDescriptorStoreFileName(String name) {
        return name.startsWith(this.descriptorStoreFileNamePrefix()) && name.endsWith(DESCRIPTOR_STORE_FILE_SUFFIX);
    }

    private String descriptorStoreFileNamePrefix() {
        return String.valueOf(this.repositoryName) + REPOSITORY_NAME_ETAG_SEPARATOR;
    }

    private File[] getDescriptorStoreFiles() {
        FilenameFilter filter = new FilenameFilter(){
            private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

            public boolean accept(File dir, String name) {
                return DescriptorStoreFactory.this.isValidDescriptorStoreFileName(name);
            }

            public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
                return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
            }

            static {
                ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.repository.internal.remote.DescriptorStoreFactory$1");
            }
        };
        return FileSystemUtils.listFiles((File)this.descriptorStoreDirectory, (FilenameFilter)filter);
    }

    private static File getMostRecentFile(File[] files) {
        File mostRecentFileile = null;
        if (files != null) {
            Long mostRecentLastModified = 0L;
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                long lastModified = file.lastModified();
                if (lastModified >= mostRecentLastModified) {
                    mostRecentLastModified = lastModified;
                    mostRecentFileile = file;
                }
                ++n2;
            }
        }
        return mostRecentFileile;
    }

    public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
        return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    }

    static {
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.repository.internal.remote.DescriptorStoreFactory");
    }
}

