/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.io.IOException;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;

public final class UTF8Decoder
extends B2CConverter {
    private static Log log = LogFactory.getLog(UTF8Decoder.class);
    private static int debug = 1;

    public void recycle() {
    }

    public void convert(ByteChunk mb, CharChunk cb) throws IOException {
        int bytesOff = mb.getOffset();
        int bytesLen = mb.getLength();
        byte[] bytes = mb.getBytes();
        int j = bytesOff;
        int end = j + bytesLen;
        while (j < end) {
            int b0 = 0xFF & bytes[j];
            if ((b0 & 0x80) == 0) {
                cb.append((char)b0);
                ++j;
                continue;
            }
            if (j++ >= end) {
                throw new IOException("Conversion error - EOF ");
            }
            int b1 = 0xFF & bytes[j];
            if ((0xE0 & b0) == 192) {
                int ch = ((0x1F & b0) << 6) + (0x3F & b1);
                if (debug > 0) {
                    this.log("Convert " + b0 + " " + b1 + " " + ch + (char)ch);
                }
                cb.append((char)ch);
                ++j;
                continue;
            }
            if (j++ >= end) {
                return;
            }
            int b2 = 0xFF & bytes[j];
            if ((b0 & 0xF0) == 224) {
                if (b0 == 237 && b1 >= 160 || b0 == 239 && b1 == 191 && b2 >= 190) {
                    if (debug > 0) {
                        this.log("Error " + b0 + " " + b1 + " " + b2);
                    }
                    throw new IOException("Conversion error 2");
                }
                int ch = ((0xF & b0) << 12) + ((0x3F & b1) << 6) + (0x3F & b2);
                cb.append((char)ch);
                if (debug > 0) {
                    this.log("Convert " + b0 + " " + b1 + " " + b2 + " " + ch + (char)ch);
                }
                ++j;
                continue;
            }
            if (j++ >= end) {
                return;
            }
            int b3 = 0xFF & bytes[j];
            if ((0xF8 & b0) == 240) {
                if (b0 > 244 || b0 == 244 && b1 >= 144) {
                    if (debug > 0) {
                        this.log("Convert " + b0 + " " + b1 + " " + b2 + " " + b3);
                    }
                    throw new IOException("Conversion error ");
                }
                int ch = ((0xF & b0) << 18) + ((0x3F & b1) << 12) + ((0x3F & b2) << 6) + (0x3F & b3);
                if (debug > 0) {
                    this.log("Convert " + b0 + " " + b1 + " " + b2 + " " + b3 + " " + ch + (char)ch);
                }
                if (ch < 65536) {
                    cb.append((char)ch);
                } else {
                    cb.append((char)((ch - 65536 >> 10) + 55296));
                    cb.append((char)((ch - 65536 & 0x3FF) + 56320));
                }
                ++j;
                continue;
            }
            if (debug > 0) {
                this.log("Convert " + b0 + " " + b1 + " " + b2 + " " + b3);
            }
            throw new IOException("Conversion error 4");
        }
    }

    void log(String s) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("UTF8Decoder: " + s));
        }
    }
}

