/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.userregionfactory;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.virgo.kernel.osgi.region.RegionPackageImportPolicy;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.util.osgi.manifest.BundleManifestFactory;
import org.eclipse.virgo.util.osgi.manifest.ImportedPackage;
import org.osgi.framework.Version;

class UserRegionPackageImportPolicy
implements RegionPackageImportPolicy {
    private static final String MANDATORY_ATTRIBUTE_NAME_SEPARATOR = ",";
    private static final String MANDATORY_DIRECTIVE_NAME = "mandatory";
    private static final String VERSION_ATTRIBUTE_NAME = "version";
    private static final String WILDCARD = "*";
    private final Map<String, ImportedPackage> importedPackages = new HashMap<String, ImportedPackage>();

    UserRegionPackageImportPolicy(String regionImports) {
        if (regionImports != null && !regionImports.isEmpty()) {
            if (regionImports.contains(WILDCARD)) {
                throw new IllegalArgumentException("Wildcards not supported in region imports: '" + regionImports + "'");
            }
            BundleManifest manifest = BundleManifestFactory.createBundleManifest();
            manifest.setHeader("Import-Package", regionImports);
            List list = manifest.getImportPackage().getImportedPackages();
            for (ImportedPackage importedPackage : list) {
                String packageName = importedPackage.getPackageName();
                this.importedPackages.put(packageName, importedPackage);
            }
        }
    }

    public boolean isImported(String packageName, Map<String, Object> exportAttributes, Map<String, String> exportDirectives) {
        ImportedPackage importedPackage = this.importedPackages.get(packageName);
        if (importedPackage != null) {
            String mandatoryDirectiveValue;
            Map importAttributes = importedPackage.getAttributes();
            Set importAttributeNames = importAttributes.keySet();
            for (String importAttributeName : importAttributeNames) {
                String importAttributeValue;
                if (exportAttributes == null) {
                    return false;
                }
                Object exportAttributeValue = exportAttributes.get(importAttributeName);
                if (importAttributeName.equals(VERSION_ATTRIBUTE_NAME)) {
                    if (exportAttributeValue != null && exportAttributeValue instanceof Version) {
                        Version exportVersion = (Version)exportAttributeValue;
                        importAttributeValue = (String)importAttributes.get(importAttributeName);
                        VersionRange importVersion = new VersionRange(importAttributeValue);
                        if (importVersion.isIncluded(exportVersion)) continue;
                        return false;
                    }
                    return false;
                }
                if (exportAttributeValue != null && exportAttributeValue instanceof String) {
                    String exportAttributeValueString = (String)exportAttributeValue;
                    importAttributeValue = (String)importAttributes.get(importAttributeName);
                    if (exportAttributeValueString.equals(importAttributeValue)) continue;
                    return false;
                }
                return false;
            }
            if (exportDirectives != null && (mandatoryDirectiveValue = exportDirectives.get(MANDATORY_DIRECTIVE_NAME)) != null) {
                String[] stringArray = mandatoryDirectiveValue.split(MANDATORY_ATTRIBUTE_NAME_SEPARATOR);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String mandatoryAttribute = stringArray[n2];
                    if (!importAttributeNames.contains(mandatoryAttribute)) {
                        return false;
                    }
                    ++n2;
                }
            }
            return true;
        }
        return false;
    }
}

